/**
 * 库区信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2016-07-09
 */
Ext.define('WMS.view.baseinfo.WarehouseAreaEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.warehouseareaeditview',
	id : 'warehouseareaeditview',
	title : '库区信息编辑',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	width : 585,
	height : 325,
	layout : 'fit',
	modal : true,
	initComponent : function() {
		this.items = [{
			xtype : 'panel',
			border : false,
			margin : 10,
			items : [{
				xtype : 'form',
				border : false,
				items : [{
					xtype : 'panel',
			        layout:'column',
				    border: false,
			        defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '6'
			    	},
		    		items: [{
		        		xtype: 'textfield',
		        		width: 260,
		        		labelWidth : 90,
		        		name: 'areaCode',
		        		allowBlank : false,
		        		fieldLabel: '库区编码',
		        		length:20,
			        	vtypeText:'库区编码最多可输入20个字符<br>库区编码只能输入英文、数字和字符',
		        		vtype: 'exceptChinese',
		        		listeners:{  
	        				   'blur':function(e){e.setValue(e.getValue().trim())}  
			        				} 
		       		 },{
		        		xtype: 'textfield',
		        		width: 250,
		        		labelWidth : 80,
		        		name: 'areaName',
		        		allowBlank : false,
		        		fieldLabel: '库区名称',
		        		length:20,
		        		vtypeText : '库区名称最多可输入20个字符',
	        		    vtype: 'limitLen',
	        		    listeners:{  
	        				   'blur':function(e){e.setValue(e.getValue().trim())}  
			        				} 
					}]
			     },{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '6'
		    		},
		    		items:[{
		    			xtype:'combobox',
						fieldLabel:'库区性质',
						name:'areaNature',
						labelWidth:90,
						editable: false,
						allowBlank : false,
						width:260,
						displayField: 'name',
			            valueField: 'value',
		            	store: Ext.create('WMS.store.common.AreaNatureStr', {
		            		hasEmptyItem: false,
		            	}),
		            	
		            	value: 1
		    		},{
		    			xtype: 'textfield',
		        		width: 250,
		        		labelWidth : 80,
		        		name: 'address',
		        		fieldLabel: '库区地点',
		        		length:50,
		        		vtypeText : '库区地点最多可输入50个字符',
	        		    vtype: 'limitLen',
	        		    allowBlank : false,
	        		    listeners:{  
	        				   'blur':function(e){e.setValue(e.getValue().trim())}  
			        				} 
	    		    }]
			    },{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '6'
		    		},
		    		items:[{
				    	xtype: 'textfield',
		        		width: 260,
		        		labelWidth : 90,
		        		name: 'maxStorageCapacity',
		        		fieldLabel: '最大存放能力',
		        		length:10,
		        		vtypeText:'最大存放能力最多可输入10个字符<br>最大存放能力只能输入正整数',
		        		vtype: 'number'
	   				},{
		    			xtype: 'textfield',
		        		width: 250,
		        		labelWidth : 80,
		        		name: 'acreage',
		        		fieldLabel: '面积',
		        		length:10,
		        		decimalDigits:2,
		        		vtypeText:'面积最多可输入10个字符<br>面积只能输入两位小数',
		        		vtype: 'currency'
	    			}]
			    },{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '6'
		    		},
		    		items:[{
		    			xtype: 'textfield',
		        		width: 260,
		        		labelWidth :90,
		        		//allowBlank : false,
		        		name: 'manager1',
		        		fieldLabel: '管理人员1',
		        		length:20,
		        		vtypeText:'管理人员最多可输入20个字符<br>管理人员只能输入中文和英文',
		        		vtype: 'chnEng'
		    		},{
		    			xtype: 'textfield',
		    			//allowBlank : false,
		        		width: 250,
		        		labelWidth : 80,
		        		name: 'tel1',
		        		fieldLabel: '联系电话1',
		        		length:50,
		        		vtypeText:'联系电话最多可输入50个字符<br>联系电话只能输入数字和符号',
		        		vtype: 'phone'
					}]
				},{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '6'
		    		},
		    		items:[{
			    		xtype: 'textfield',
		        		width: 260,
		        		labelWidth :90,
		        		name: 'manager2',
		        		fieldLabel: '管理人员2',
		        		length:20,
		        		vtypeText:'管理人员最多可输入20个字符<br>管理人员只能输入中文和英文',
		        		vtype: 'chnEng'
		    		},{
		    			xtype: 'textfield',
		        		width: 250,
		        		labelWidth : 80,
		        		name: 'tel2',
		        		fieldLabel: '联系电话2',
		        		length:50,
		        		vtypeText:'联系电话最多可输入50个字符<br>联系电话只能输入数字和符号',
		        		vtype: 'phone'
	    			}]
				},{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			xtype: 'radiofield',
		    			labelWidth : 100,
		    			margin: '0 5'
		    		},
		    		items:[{
				        xtype: 'displayfield',
				        margin: '0 0 0 5',
				        fieldLabel: '状态',
				        width: 100,
				        style: 'text-align: right;'
				    },{
    					boxLabel : '启用',
                		name : 'status',
                		inputValue: '1',
                		checked:"checked"
	    			},{
    			        boxLabel : '禁用',
                		name : 'status',
                		inputValue: '0'
					}]
				}]
			}]
		}],
		this.fbar = [{
	    		xtype: 'button',
	        	margin: '6',
	        	text: '保存',
	        	name: 'btn-save',
				iconCls: 'btn-save'
	    	},{
	    		xtype: 'button',
	        	margin: '6',
	        	text: '取消',
	        	name: 'btn-cancel',
				iconCls: 'btn-cancel',
	        	scope: this,
	        	handler: this.close
	    	}];
		this.callParent(arguments);
	}
});