/**
 * 库区信息管理view.
 * @author 高元称
 * @version 1.0.0, 2015-07-09
 */
Ext.define('WMS.view.baseinfo.WarehouseAreaSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.warehouseareasearchview',
	id: 'warehouseareasearchview',
	resizable : false,
	closeAction : 'hide',
	multiSelect : true,
	loadMask : true,
	layout:'fit',
	 
	requires:[
		'WMS.store.baseinfo.WarehouseAreaStr'
	],
	stores:[
		'WMS.store.baseinfo.WarehouseAreaStr'
	],
	models:[
		'WMS.model.baseinfo.WarehouseAreaMdl'
	],
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 90,
				    margin : 6
				},
				items:[{
					xtype:'textfield',
					fieldLabel:'库区编码',
					name:'areaCode',
			        labelWidth:90,
			        width:250,
					length:20,
		        	vtypeText:'库区编码最多可输入20个字符<br>库区编码只能输入英文、数字和字符',
	        		vtype: 'exceptChinese'
				},{
			    	xtype:'textfield',
					fieldLabel:'库区名称',
					name:'areaName',
					labelWidth:70,
					width:230,
			        length:20,
	        		vtypeText : '库区名称最多可输入20个字符',
        		    vtype: 'limitLen'
				},{
					xtype:'combobox',
					fieldLabel:'库区性质',
					name:'areaNature',
					labelWidth:70,
					width:230,
					editable: false,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.AreaNatureStr'),
		            value: '-1'
				},{
					/**
					 * @author 李树雪 2015年12月22日 上午10.34
					 * @bug 714
					 * @code:72-82
					 */
		    		xtype:'checkbox',
		    		boxLabel:'<span>显示禁用项</span><img data-qtip="选中时显示所有查询条件（下拉框项）中已禁用的项，<br/>查询结果中包含已禁用项的结果；未选中时不显示" src="images/hint.png" class="hintico">',
		    		name: 'showForbidden',
		    		checked: true
		    	}]	
			},{
				xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 90,
	        	 	margin: 6
				},
				items:[{
			    	xtype:'textfield',
					fieldLabel:'库区地点',
					name:'address',
					labelWidth:90,
					width:250,
					length:50,
	        		vtypeText : '库区地点最多可输入50个字符',
        		    vtype: 'limitLen'
		   		},{
			        xtype:'textfield',
					fieldLabel:'管理人员',
					name:'manager1',
					labelWidth:70,
					width:230,
					length:20,
	        		vtypeText:'管理人员最多可输入20个字符<br>管理人员只能输入中文和英文',
	        		vtype: 'chnEng'
		   		},{
			        xtype:'textfield',
					fieldLabel:'联系电话',
					name:'tel1',
					labelWidth:70,
					labelAlign : 'right',
					width:230,
					length:50,
	        		vtypeText:'联系电话最多可输入50个字符<br>联系电话只能输入数字和符号',
	        		vtype: 'phone'
		  		}]
		   	},{
		   		xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 90,
	        	 	margin: 6
				},
				items:[{
				    xtype:'combobox',
				    fieldLabel:'状态',
				    editable: false,
				    name:'status',
				    labelWidth :90,
				    width : 250,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.StatusStr'),
		            value: '-1'
				},{
					border:false
				},{
			    	xtype:'button',
			    	width: 60,
			    	text:'查询',
			    	name:'btn-search',
			    	iconCls: 'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'重置',
			    	name:'btn-clear',
			    	iconCls: 'btn-clear'
	   			}]
		   	}]
		};
		
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 60,
			 	margin: 6
			},
			items:[{
				xtype : 'button',
				text : '添加',
				name : 'btn-add',
				iconCls: 'btn-add'
			},{
				xtype : 'button',
				text : '删除',
				name : 'btn-delete',
				iconCls: 'btn-delete'
			},{
				xtype : 'button',
				text : '导入',
				name : 'btn-import',
				iconCls: 'btn-import'
			},{
				xtype:'button',
				text:'导出',
				name:'btn-export',
				iconCls: 'btn-export'
			},{
				xtype:'button',
				text:'启用',
				name:'btn-openStatus',
				iconCls: 'btn-openStatus'
			},{
				xtype:'button',
				text:'禁用',
				name:'btn-closeStatus',
				iconCls: 'btn-closeStatus'
			}]
	    };
		
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列   将序列号宽度40改为60    彭婷婷
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:left", align:'center'
	      	}),
		    { text: '库区编码', dataIndex: 'areaCode', width:150,style :"text-align:center",align:'left'},
	      	{ text: '库区名称', dataIndex: 'areaName', width:200,style :"text-align:center",align:'left'},
		    { text: '库区性质', dataIndex: 'areaNature1', width:110,style :"text-align:center",align:'left'},
		    { text: '库区地点', dataIndex: 'address', style :"text-align:center", width:150,  align:'left'},
		    { text: '最大存放能力', dataIndex: 'maxStorageCapacity', width:100, style :"text-align:center", align:'right'},
		    { text: '面积', dataIndex: 'acreage', hidden: true},
		    { text: '管理人员1', dataIndex: 'manager1', hidden: true},
		    { text: '联系电话1', dataIndex: 'tel1', hidden: true},
		    { text: '管理人员2', dataIndex: 'manager2', hidden: true},
		    { text: '联系电话2', dataIndex: 'tel2', hidden: true},
		    { text: '状态', dataIndex: 'displayStatus', width:80, style :"text-align:center",  align:'center'},
		    ACBEE.Ext.Util.createEditBtn(this.functionCodes)
		];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的库区信息！',
			/********
			 * 2015/12/23
			 * 王玉涛
			 * bug675
			 */
			store:Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
            	url: 'warehouseArea/searchWarehouseAreaPage.action'        	
            }),
            /********
			 * 2015/12/26
			 * 王玉涛
			 * bug745
			 */
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
		listeners:{
			afterrender:function(view, eOpts){
				view.down('pagingtoolbar').bindStore(view.getStore());
			}
		}
});
