/**
 * 库位信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2016-07-10
 */
Ext.define('WMS.view.baseinfo.WarehouseLocationEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.warehouselocationeditview',
	id : 'warehouselocationeditview',
	title : '库位信息编辑',
	resizable : false,
	constrainHeader:true,
	closeAction : 'hide',
	width : 600,
	height : 300,
	layout : 'fit',
	modal : true,
	requires:[
		'WMS.store.baseinfo.WarehouseLocationStr'
	],
	models:[
		'WMS.model.baseinfo.WarehouseLocationMdl'
	],
	stores:[
		'WMS.store.baseinfo.WarehouseLocationStr'
	],
	initComponent : function() {
		this.items = [{
			xtype : 'panel',
			border : false,
			margin : 10,
			items : [{
				xtype : 'form',
				border : false,
				items : [{
					xtype : 'panel',
			        layout:'column',
				    border: false,
			        defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '6'
			    	},
		    		items: [{
		        		xtype: 'textfield',
						labelWidth:100,
						width:270,
		        		name: 'locationNo',
		        		allowBlank : false,
		        		fieldLabel: '库位号',
		        		length:50,
		        		vtypeText : '库位号最多可输入50个字符',
	        		    vtype: 'limitLen',
	        		    listeners:{  
	        				   'blur':function(e){e.setValue(e.getValue().trim())}  
			        				} 
		       		 },{
			    		xtype: 'textfield',
		        		width: 260,
		        		labelWidth :90,
		        		name: 'maxStorageCapacity',
		        		fieldLabel: '最大存放量',
		        		length:10,
		        		vtypeText:'最大存放能力最多可输入10个字符<br>最大存放能力只能输入正整数',
		        		vtype: 'number'
			    	}]
			     },{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '6'
		    		},
		    		items:[{
		        		xtype: 'combobox',
		        		width: 270,
		        		labelWidth : 100,
		        		name: 'areaId',
		        		allowBlank : false,
		        		fieldLabel: '所属库区',
		        		emptyText: "--请选择--", 
		        		editable: false,
						listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
	    	                }
	    	            },
						queryMode: 'remote',
			            displayField: 'areaName',
			            valueField: 'areaId',
			            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
			            	params:{
			            	 	areaNature: -1,
			            	 	status : 1
			            	},
			            	url: 'warehouseArea/getWarehouseAreaList.action'        	
			            })
					},{
		    			xtype: 'textfield',
		        		width: 260,
		        		labelWidth : 90,
		        		name: 'acreage',
		        		fieldLabel: '面积',
		        		length:10,
		        		decimalDigits:2,
		        		vtypeText:'面积最多可输入10个字符<br>面积只能输入两位小数',
		        		vtype: 'currency'
	    		    }]
			    },{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '6'
		    		},
		    		items:[{
		    			xtype:'combobox',
						fieldLabel:'库位性质',
						name:'natureId',
		        		width: 270,
		        		labelWidth : 100,
						listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
	    	                }
	    	            },
						editable: false,
						allowBlank : false,
						queryMode: 'remote',
			            displayField: 'natureName',
			            emptyText: "--请选择--", 
			            valueField: 'natureId',
			            store: Ext.create('WMS.store.common.LocationNatureNameStr',{
			            	params:{
			            	 	status: 1,
			            	 	areaId:0
			            	},
			            	url: 'locationNature/getLocationNatureList.action'        	
			            })
		    		},{
		    			xtype: 'textfield',
		        		width: 260,
		        		labelWidth :90,
		        		name: 'manager2',
		        		fieldLabel: '管理人员2',
		        		length:10,
		        		vtypeText:'管理人员最多可输入10个字符<br>管理人员只能输入中文和英文',
		        		vtype: 'chnEng'
		    		}]
			    },{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '6'
		    		},
		    		items:[{
				    	xtype: 'textfield',
		        		width: 270,
		        		labelWidth : 100,
		        		name: 'manager1',
		        		//allowBlank : false,
		        		fieldLabel: '管理人员1',
		        		length:10,
		        		vtypeText:'管理人员最多可输入10个字符<br>管理人员只能输入中文和英文',
		        		vtype: 'chnEng'
	   				},{
		    			xtype: 'textfield',
		        		width: 260,
		        		labelWidth : 90,
		        		name: 'tel2',
		        		fieldLabel: '联系电话2',
		        		length:15,
		        		vtypeText:'联系电话最多可输入15个字符<br>联系电话只能输入数字和符号',
		        		vtype: 'phone'
    				}]
				},{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			xtype: 'radiofield',
		    			labelWidth : 70,
		    			margin: '6'
		    		},
		    		items:[{
		    			xtype: 'textfield',
		        		width: 270,
		        		labelWidth :100,
		        		//allowBlank : false,
		        		name: 'tel1',
		        		fieldLabel: '联系电话1',
		        		length:15,
		        		vtypeText:'联系电话最多可输入15个字符<br>联系电话只能输入数字和符号',
		        		vtype: 'phone'
	    			},{
				        xtype: 'displayfield',
				        fieldLabel: '状态',
				        style: 'text-align: right;'
				    },{
    					boxLabel : '启用',
                		name : 'status',
                		inputValue: '1',
                		checked:"checked"
	    			},{
    			        boxLabel : '禁用',
                		name : 'status',
                		inputValue: '0'
			    	}]
				}]
			}]
		}],
		this.fbar = [{
	    		xtype: 'button',
	        	margin: '6',
	        	text: '保存',
	        	name: 'btn-save',
				iconCls: 'btn-save'
	    	},{
	    		xtype: 'button',
	        	margin: '6',
	        	text: '取消',
	        	name: 'btn-cancel',
				iconCls: 'btn-cancel',
	        	scope: this,
	        	handler: this.close
	    	}];
		this.callParent(arguments);
	}
});