/**
 * 库位信息管理view.
 * @author 高元称
 * @version 1.0.0, 2015-07-10
 */
Ext.define('WMS.view.baseinfo.WarehouseLocationSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.warehouselocationsearchview',
	id: 'warehouselocationsearchview',
	resizable : false,
	multiSelect : true,
	closeAction : 'hide',
	loadMask : true,
	layout:'fit',
	 
	requires:[
		'WMS.store.baseinfo.WarehouseLocationStr'
	],
	models:[
		'WMS.model.baseinfo.WarehouseLocationMdl'
	],
	stores:[
		'WMS.store.baseinfo.WarehouseLocationStr'
	],
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					xtype:'textfield',
					fieldLabel:'库位号',
					name:'locationNo',
					labelWidth:90,
					width:250,
			        length:50,
	        		vtypeText : '库位号最多可输入50个字符',
        		    vtype: 'limitLen'
				},{
					xtype:'combobox',
					fieldLabel:'库位性质',
					name:'natureId',
					labelWidth:70,
					width:230,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					editable: false,
					queryMode: 'remote',
		            displayField: 'natureName',
		            valueField: 'natureId',
		            value:-1,
		            store: Ext.create('WMS.store.common.LocationNatureNameStr',{
		            	params:{
		            	 	status: -1,
		            	 	areaId:-1
		            	},
                    	hasEmptyItem: true,
		            	url: 'locationNature/getLocationNatureList.action'        	
		            })
				},{
			    	xtype:'combobox',
					fieldLabel:'所属库区',
					name:'areaName',
			        labelWidth:90,
			        width:250,
					editable: false,
					queryMode: 'remote',
		            displayField: 'areaName',
		            valueField: 'areaId',
		            value:-1,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
		            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
		            	params:{
		            	 	areaNature: -1,
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'warehouseArea/getWarehouseAreaList.action'        	
		            })
				},{
		    		border:false
		    	},{
		    		xtype:'checkbox',
		    		boxLabel:'<span>显示禁用项</span><img data-qtip="选中时显示所有查询条件（下拉框项）中已禁用的项，<br/>查询结果中包含已禁用项的结果；未选中时不显示" src="images/hint.png" class="hintico">',
		    		name: 'showForbidden',
		    		checked: true
		    	}]
			},{
				xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 70,
	        	 	margin: 6
				},
				items:[{
			    	xtype:'textfield',
					fieldLabel:'管理人员',
					name:'manager1',
					labelWidth:90,
					width:250,
			        length:20,
	        		vtypeText : '管理人员最多可输入20个字符，只允许输入中文和英文',
        		    vtype: 'chnEng'
		   		},{
			        xtype:'textfield',
					fieldLabel:'联系电话',
					name:'tel1',
					labelWidth:70,
					width:230,
			        length:50,
	        		vtypeText : '联系电话最多可输入50个字符，只能输入数字和符号',
        		    vtype: 'phone'
		   		},{
				    xtype:'combobox',
				    fieldLabel:'状态',
				    editable: false,
				    name:'status',
				    labelWidth :90,
				    width : 250,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.StatusStr'),
		            value: '-1'
				},{
			    	xtype:'button',
			    	width: 60,
			    	text:'查询',
			    	name:'btn-search',
			    	iconCls: 'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'重置',
			    	name:'btn-clear',
			    	iconCls: 'btn-clear'
	   			}]
		   	}]
		};
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 60,
			 	margin: 6
			},
			items:[{
				xtype : 'button',
				text : '添加',
				name : 'btn-add',
				iconCls: 'btn-add'
			},{
				xtype : 'button',
				text : '删除',
				name : 'btn-delete',
				iconCls: 'btn-delete'
			},{
				xtype : 'button',
				text : '导入',
				name : 'btn-import',
				iconCls: 'btn-import'
			},{
				xtype:'button',
				text:'导出',
				name:'btn-export',
				iconCls: 'btn-export'
			},{
				xtype:'button',
				text:'启用',
				name:'btn-openStatus',
				iconCls: 'btn-openStatus'
			},{
				xtype:'button',
				text:'禁用',
				name:'btn-closeStatus',
				iconCls: 'btn-closeStatus'
			}]
	    };
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列   将序号宽度从40改为60   彭婷婷
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:left", align:'center'
	      	}),
	      	{ text: '库位号', dataIndex: 'locationNo', style :"text-align:center", width:130,  align:'left'},
	      	{ text: '库位性质', dataIndex: 'natureName', width:130,style :"text-align:center",align:'left'},
	      	{ text: '所属库区', dataIndex: 'areaName', width:200,style :"text-align:center",align:'left'},
	      	{ text: '库区编码', dataIndex: 'areaCode',hidden: true},
	      	{ text: '库区性质', dataIndex: 'areaNature',hidden: true},
	      	{ text: '最大存放量', dataIndex: 'maxStorageCapacity', width:100, style :"text-align:center", align:'right'},
		    { text: '面积', dataIndex: 'acreage', width:100, style :"text-align:center", align:'right'},
		    { text: '管理人员1', dataIndex: 'manager1',hidden: true},
		    { text: '联系电话1', dataIndex: 'tel1',hidden: true},
		    { text: '管理人员2', dataIndex: 'manager2',hidden: true},
		    { text: '联系电话2', dataIndex: 'tel2',hidden: true},
		    { text: '状态', dataIndex: 'displayStatus', width:80, style :"text-align:center",  align:'center'},
		    ACBEE.Ext.Util.createEditBtn(this.functionCodes)
		];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的库位信息！',
			/********
			 * 2015/12/23
			 * 王玉涛
			 * bug692
			 */
			store:Ext.create('WMS.store.baseinfo.WarehouseLocationStr',{
            	url: 'warehouseLocation/searchLocationPage.action'        	
            }),
            /********
			 * 2015/12/26
			 * 王玉涛
			 * bug745
			 */
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
	listeners:{
		afterrender:function(view, eOpts){
			view.down('pagingtoolbar').bindStore(view.getStore());
		}
	}
});
