/**
 * 退库操作信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2016-07-20
 */
Ext.define('WMS.view.cancelstock.CancelstockBillEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.cancelstockbilleditview',
	id : 'cancelstockbilleditview',
	title : '退库操作信息编辑',
	resizable : false,
	closeAction : 'hide',
	autoHeight : true,
	constrainHeader:true,
	width : 860,
	//height : 567,
	layout : 'fit',
	modal : true,
	stores:[
	    'WMS.store.cancelstock.CancelStockDemandBillGridStr'
	],
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createInstockDemand(),
				this.createGoodsInfo()
			]	
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '6',
        	text : '保存',
        	name : 'btn-save',
        	iconCls:'btn-save'
    	},{
    		xtype : 'button',
        	margin : '6',
        	text : '取消',
        	iconCls:'btn-cancel',
        	name : 'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	},
	//创建预约退库编辑form
	createInstockDemand : function(){
		var instockDemand={
			xtype : 'form',
			border : false,
			margin : '10',
			items : [{
			    xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype : 'label',
			        margin: '10 0 0 13',
	        		width : 70,
	        		name : 'demandNoLabel',
	        		text : '退库需求号:',
	        		style: 'text-align: right;'
				},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'demandNo',
			        width:145
				},{
		    		xtype: 'label',
			        margin: '10 0 0 105',
	        		name : 'appointmentDateLabel',
			        width:70,
	        		text : '预约日期:',
	        		style: 'text-align: right;'
				},{
					xtype : 'displayfield',
	        		width : 145,
	        		name : 'appointmentDate',
	        		margin: '5 0 0 5'
				},{
		    		xtype: 'label',
			        margin: '10 0 0 0',
	        		name : 'planCancelTimeLabel',
			        width: 100,
	        		text : '计划退库时间:',
	        		style: 'text-align: right;'
				},{
					xtype : 'displayfield',
	        		width : 145,
	        		name : 'planCancelTime',
	        		margin: '5 0 0 5'
				}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'pickupPersonLabel',
			        width:70,
	        		text : '提货人:',
	        		style: 'text-align: right;'
		    	},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'pickupPerson',
	        		width : 145
		    	},{
					xtype : 'label',
	        		width :70,
	        		name : 'pickupCompanyLabel',
	        		margin: '10 0 0 105',
	        		text : '提货公司:',
	        		style: 'text-align: right;'
				},{
		    		xtype : 'displayfield',
	        		width : 145,
	        		name : 'pickupCompany',
	        		margin: '5 0 0 5'
		    	},{
		    		xtype: 'datetimefield',
			        margin: '10 0 0 0',
	        		name : 'actualCancelTime',
			        width: 245,
	        		fieldLabel : '实际退库时间:',
	        		allowBlank : false,
	        		labelWidth:100,
	        		format : "Y-m-d",
	        		length:19,
					vtype:'datetime',
					vtypeText : '实际退库时间必须晚于计划退库时间'
				}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'orderNoLabel',
			        width:70,
	        		text : '订单号:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'orderNo',
	        		width : 145	
		    	},{
					xtype : 'label',
	        		width :70,
	        		name : 'itemNoLabel',
	        		margin: '10 0 0 105',
	        		text : '项号:',
	        		style: 'text-align: right;'
				},{
		    		xtype : 'displayfield',
					width:145,
					margin:'5 0 0 5',
	        		name : 'itemNo'
		    	},{
		    		xtype: 'label',
			        margin: '10 0 0 10',
			        name: 'vehicleNoLabel',
			        width:90,
	        		text : '车辆号码:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'vehicleNo',
	        		width : 145
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'areaNameLabel',
			        width:70,
	        		text : '退库库区:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'areaName',
	        		width : 145
		    	},{
		    		xtype: 'label',
			        margin: '10 0 0 105',
			        name: 'cancelCauseNameLabel',
			        width:70,
	        		text : '退库原因:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'cancelCauseName',
	        		width : 145
		    	},{
		    		xtype:'combobox',
				    fieldLabel:'实际退库组',
				    editable: false,
				    name:'actualCancelstockGroup',
	        		width : 235,
	        		margin: '5 0 0 10',
	        		labelWidth : 90,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 6);
    	                }
    	            },
	        		allowBlank : false,
	        		queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            emptyText: "--请选择--", 
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 10,
		            	 	status: 1
		            	},
		            	url: 'dict/getDictList.action'        	
		            }).load()
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'supplierIdLabel',
			        width:70,
	        		text : '供应商:',
	        		style: 'text-align: right;'
		    	},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'supplierName',
	        		width : 200
		    	},{
            		xtype: 'hiddenfield',
    	    		name: 'supplierId'
		    	}]
			}]
		};
		return instockDemand;
	},
	//创建预约退库货物明细
	createGoodsInfo : function(){
		var goodsInfo={
			xtype : 'grid',
			border : false,
			autoScroll : true,
			height : 305,
			columns : this.createColumns(),
			store :  'WMS.store.cancelstock.CancelStockDemandBillGridStr',
			plugins:[
					Ext.create('Ext.grid.plugin.CellEditing', {
						clicksToEdit: 1 //设置单击单元格编辑  
					})  
				]
		};
		return goodsInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
  		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'left'
	      	}),
	      	{ text: '货物号', dataIndex: 'goodsCode', width:100,style :"text-align:center",align:'left'},
		    { text: '品名', dataIndex: 'goodsName', width:110,style :"text-align:center",align:'left'},
		    { text: '生产批号', dataIndex: 'productBatch', width:130, style :"text-align:center", align:'left'},
		    { text: '计划退库数量', dataIndex: 'planCancelQuantity', width:130, style :"text-align:center", align:'left'},
		    { text: '实际退库数量', dataIndex: 'actualCancelQuantity', width:130, style :"text-align:center", align:'left',field:{
	      		allowBlank: true,
	      		length:15,
        		vtypeText : '实际退库数量最多可输入15个字符<br>实际退库数量只能输入正整数',
    		    vtype: 'currency'
	      	}},
		    { text: '退库库位号', dataIndex: 'locationNo', width:130, style :"text-align:center", align:'left'},
		    { text: '单价', dataIndex: 'price', width:80, style :"text-align:center",  align:'left'},
		    { text: '金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'left',
		    renderer:function(value,metaData,record,rowIndex,colIndex,store){
	        	var actualCancelQuantity = (null == record.data.actualCancelQuantity ? 0 : record.data.actualCancelQuantity);
	  	    	var price =(null == record.data.price ? 0 : record.data.price);
	  	    	 
	  	        return (actualCancelQuantity*10000) * (price*10000)/100000000;
        	}},
		    { text: '下架状态', dataIndex: 'displayStatus', width:100, style :"text-align:center",  align:'left'}
		];
		return columns;		
	}
});
