/**
 * 预约退库信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.view.cancelstock.CancelstockDemandBillEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.cancelstockdemandbilleditview',
	id : 'cancelstockdemandbilleditview',
	title : '预约退库信息编辑',
	resizable : false,
	constrainHeader:true,
	width : 870,
	height : 575,
	layout : 'fit',
	modal : true,
	stores:[
	    'WMS.store.cancelstock.CancelStockDemandBillGridStr'
	],
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createInstockDemand(),
				this.createGoodsInfo()
			]	
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '5',
        	text : '保存',
        	name : 'btn-save',
        	iconCls:'btn-save'
    	},{
    		xtype : 'button',
        	margin : '5',
        	text : '打印',
        	name : 'btn-print'
    	},{
    		xtype : 'button',
        	margin : '5',
        	text : '取消',
        	name : 'btn-cancel',
        	iconCls:'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	},
	//创建退库操作编辑form
	createInstockDemand : function(){
		var instockDemand={
			xtype : 'form',
			border : false,
			margin : '10',
			items : [{
			    xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '5'
		    	},
		    	items : [{
	        		xtype : 'textfield',
	        		width : 260,
	        		labelWidth : 100,
	        		name : 'demandNo',
	        		allowBlank : false,
	        		maxLength : 100,
	        		fieldLabel : '退库需求号',
	        		readOnly : true,
	        		length:15,
	        		vtypeText : '退库需求号最多可输入15个字符<br>退库需求号不能输入中文',
        		    vtype: 'exceptChinese'
				},{
					xtype : 'datefield',
	        		width : 250,
	        		labelWidth : 90,
	        		name : 'appointmentDate',
	        		allowBlank : false,
	        		fieldLabel : '预约日期',
	        		format : "Y-m-d",
					length:10,
	        		vtypeText:'预约日期必须早于计划退库时间',
	        		vtype: 'date'
				},{
		    		xtype : 'datetimefield',
	        		width : 260,
	        		labelWidth : 100,
	        		name : 'planCancelTime',
	        		allowBlank : false,
	        		fieldLabel : '计划退库时间',
	        		format : "Y-m-d",
					vtype:'datetime',
					compareToDate: true,
					compareTo: 'appointmentDate',
					length:19,
					vtypeText : '计划退库时间必须晚于预约日期'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '5'
		    	},
		    	items : [{
		    		xtype:'combobox',
				    fieldLabel:'供应商',
				    allowBlank:false,
				    name:'supplierId',
					labelWidth : 100,
					width : 260,
	        		emptyText: "--选择或输入--",
	        		editable: true,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
    	                }
    	            },
	        		displayField: 'supplierName',
		            valueField: 'supplierId',
		            store: Ext.create('WMS.store.baseinfo.SupplierViewStr',{
		            	params:{
		            	 	status: 1
		            	},
		            	url: 'supplier/getSupplierList.action'        	
		            }),
		            
		            //监听事件对下拉选项进行模糊匹配
		            listeners:{
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
		    	},{
		    		xtype : 'textfield',
	        		width : 250,
	        		labelWidth : 90,
	        		name : 'pickupPerson',
	        		allowBlank : true,
	        		fieldLabel : '提货人'	,
	        		length:20,
	        		vtypeText : '提货人最多可输入20个字符<br>提货人不能输入数字',
        		    vtype: 'exceptNumber'
		    	},{
		    		xtype : 'textfield',
	        		width : 260,
	        		labelWidth : 100,
	        		name : 'pickupCompany',
	        		allowBlank : true,
	        		fieldLabel : '提货公司',
	        		length:100,
	        		vtypeText : '送货公司最多可输入100个字符',
        		    vtype: 'limitLen'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '5'
		    	},
		    	items : [{
		    		xtype : 'textfield',
	        		width : 260,
	        		labelWidth : 100,
	        		name : 'orderNo',
	        		allowBlank : true,
	        		fieldLabel : '订单号'	,
	        		length:20,
	        		vtypeText : '订单号最多可输入20个字符<br>订单号不能输入中文',
        		    vtype: 'exceptChinese'
		    	},{
		    		xtype : 'textfield',
	        		width : 250,
	        		labelWidth : 90,
	        		name : 'itemNo',
	        		allowBlank : true,
	        		fieldLabel : '项号',
	        		length:20,
	        		vtypeText : '项号最多可输入5个字符<br>项号只能输入数字',
        		    vtype: 'number'
		    	},{
		    		xtype : 'textfield',
	        		width : 260,
	        		labelWidth : 100,
	        		name : 'vehicleNo',
	        		allowBlank : true,
	        		maxLength : 100,
	        		fieldLabel : '车辆号码',
	        		length:10,
	        		/**
	        		 * @author 李树雪 2015年12月22日 上午17.24
	        		 * @bug 717
	        		 * @code:209-215
	        		 */
	        		vtypeText : '车辆号码格式不对，应该以汉字开头，后面是6位数字或字母。<br><br>如：京A00000',
        		    vtype: 'checkNumber'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '5'
		    	},
		    	items : [{
		    		xtype : 'combobox',
	        		width : 260,
	        		labelWidth : 100,
	        		name : 'cancelCause',
	        		emptyText : '--请选择--',
	        		allowBlank : false,
	        		maxLength : 100,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 7);
    	                }
    	            },
	        		fieldLabel : '退库原因',
	        		editable: false,
					queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
		            		dictType: 5,
		            		status: 1
		            	},
		            	url: 'dict/getDictList.action'   
		            }).load()
		    	},{
	    			xtype:'combobox',
					fieldLabel:'退库库区',
					name:'areaId',
	        		width : 250,
	        		labelWidth : 90,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 7);
    	                }
    	            },
					emptyText : '--请选择--',
					editable: false,
					//allowBlank : false,
					queryMode: 'remote',
		            displayField: 'areaName',
		            valueField: 'areaId',
		            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
		            	params:{
		            	 	areaNature: -1,
		            	 	status: 1
		            	},
		            	url: 'warehouseArea/getWarehouseAreaList.action'        	
		            })
		    	},{
		    		xtype : 'label',
			        margin: '10 0 0 25',
	        		width : 80,
	        		text : '货物总数量：'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 0',
			        name: 'totalQuantity',
			        width: 50
				},{
		    		xtype : 'label',
			        margin: '10 0 0 0',
	        		width : 80,
	        		text : '货物总金额：'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 0',
			        name: 'totalPrice',
			        width: 60
				},{
            		xtype: 'hiddenfield',
    	    		name: 'supplierCode'
		    	}]
			}]
		};
		return instockDemand;
	},
	//创建退库操作货物明细
	createGoodsInfo : function(){
		var goodsInfo={
			xtype : 'grid',
			border : false,
			height : 330,
			columns : this.createColumns(),
			store :  'WMS.store.cancelstock.CancelStockDemandBillGridStr',
			plugins:[
					Ext.create('Ext.grid.plugin.CellEditing', {
						clicksToEdit: 1 //设置单击单元格编辑  
					})  
				],
			listeners : {
				beforeedit : function(editor, e, eOpts){
					if(this.up('window').oldCancelstockDemandBillId!=0 && this.up('window').status){
						var goodsCode = e.record.data.goodsCode;
						e.cancel = (null == goodsCode || "" == goodsCode ? false : true);
					}
				},
				edit:function(editor,e){
					if(1 == e.colIdx){
						var goodsCode = this.down('textfield[name=goodsCode]').getValue();
						ACBEE.Ext.Util.ajaxRequest("goods/searchGoodsByGoodsCode.action",{goodsCode:goodsCode},function(result){
							if(true == result.success){
								e.record.data.goodsCode = result.map.goodsCode;
								e.record.data.goodsName = result.map.goodsName;
								e.record.data.price = result.map.price;
		                		e.record.data.goodsId = result.map.goodsId;
	                			e.record.data.planCancelQuantity = '';
								e.record.data.productBatch = '';
							} else {
								ACBEE.Ext.Util.showAlertBox(result.msg);
								e.record.data.goodsCode = '';
								e.record.data.goodsName = '';
								e.record.data.price = '';
								e.record.data.goodsId = '';
								e.record.data.planCancelQuantity = '';
								e.record.data.productBatch = '';
							}
							e.record.commit();
						});
					}
				}
			},
		 	fbar:[{
		        	xtype : 'button',
		        	margin : '5',
		        	text : '添加',
		        	name : 'btn-add',
		        	iconCls:'btn-add'
	        	},{
		        	xtype : 'button',
		        	margin : '5',
		        	text : '导入',
		        	name : 'btn-import',
		        	iconCls:'btn-import'
	        	},{
		        	xtype : 'button',
		        	margin : '5',
		        	text : '导出',
		        	name : 'btn-export',
		        	iconCls:'btn-export'
	        	},{
		        	xtype : 'button',
		        	margin : '5',
		        	text : '删除',
		        	name : 'btn-delete',
		        	iconCls:'btn-delete'
	        	},'->'
        	]
		};
		return goodsInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
  		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'left'
	      	}),
	      	{text: '货物号', dataIndex: 'goodsCode', width:100,style :"text-align:center",align:'left',field:{
      	    	allowBlank: false,
	      		length:20,
        		vtypeText : '货物号最多可输入20个字符',
    		    vtype: 'exceptChinese'
	      	}},
		    { text: '品名', dataIndex: 'goodsName', width:110,style :"text-align:center",align:'left'},
		    { text: '生产批号', dataIndex: 'productBatch', width:130, style :"text-align:center", align:'left'},
		    { text: '计划退库数量', dataIndex: 'planCancelQuantity', width:130, style :"text-align:center", align:'left',field:{
      	    	allowBlank: true,
	      		length:15,
        		vtypeText : '计划退库数量最多可输入15个字符',
    		    vtype: 'currency'
	      	}},
		    { text: '单价', dataIndex: 'price', width:80, style :"text-align:center",  align:'left'},
		    { text: '金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'left', 
		    renderer:function(value,metaData,record,rowIndex,colIndex,store){
        	var planCancelQuantity = (null == record.data.planCancelQuantity ? 0 : record.data.planCancelQuantity);
  	    	var price =(null == record.data.price ? 0 : record.data.price);
  	    	record.data.totalPrice = (planCancelQuantity*10000) * (price*10000)/100000000;
  	        return (planCancelQuantity*10000) * (price*10000)/100000000;
        	}}
		];
		return columns;		
	}
});
