/**
 * 退库库位号列表view.
 * @author 高元称
 * @version 1.0.0, 2015-09-01
 */
Ext.define('WMS.view.cancelstock.LocationNoView', {
	extend : 'Ext.window.Window',
	alias : 'widget.locationnoview',
	resizable : false,
	closeAction : 'hide',
	constrain:true,
	width : 250,
	height : 300,
	layout : 'fit',
	modal : true,
	header : false,
	stores:[
	    'WMS.store.common.LocationNoStr'
	],
	//退库库位号列表
	createLocationInfo : function(){
		var locationInfo={
			xtype : 'grid',
			border : false,
			height : 220,
			store : 'WMS.store.common.LocationNoStr',
			selModel:Ext.create('Ext.selection.RowModel',{mode:"SIMPLE"}),
			columns : this.createColumns()
		};
		return locationInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
			new Ext.grid.RowNumberer({
	      		header:"序号", width:70, style :"text-align:left", align:'left'
	      	}),
	      	{text: '库位号', dataIndex: 'locationNo', width:150,style :"text-align:center",align:'left'},
	      	{text: '库位Id', dataIndex: 'locationId', hidden : true}
		];
		return columns;		
	},
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createLocationInfo()
			]
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '3',
        	text : '确定',
        	name : 'btn-sure',
        	iconCls: 'btn-save'
    	},{
    		xtype : 'button',
        	margin : '3',
        	text : '取消',
        	name : 'btn-cancel',
        	iconCls: 'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	}
});

