/**
 * 生产批号列表view.
 * @author 高元称
 * @version 1.0.0, 2015-08-26
 */
Ext.define('WMS.view.cancelstock.ProductBatchView', {
	extend : 'Ext.window.Window',
	alias : 'widget.productbatchview',
	resizable : false,
	closeAction : 'hide',
	width : 250,
	height : 300,
	constrain:true,
	layout : 'fit',
	modal : true,
	header : false,
	stores:[
	    'WMS.store.common.ProductBatchStr'
	],
	//供应商列表
	createSupplierInfo : function(){
		var supplierInfo={
			xtype : 'grid',
			border : false,
			height : 220,
			store : 'WMS.store.common.ProductBatchStr',
			columns : this.createColumns()
		};
		return supplierInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
			new Ext.grid.RowNumberer({
	      		header:"序号", width:70, style :"text-align:left", align:'left'
	      	}),
	      	{text: '生产批号', dataIndex: 'productBatch', width:150,style :"text-align:center",align:'left'}
		];
		return columns;		
	},
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createSupplierInfo()
			]
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '3',
        	text : '确定',
        	name : 'btn-sure',
        	iconCls: 'btn-save'
    	},{
    		xtype : 'button',
        	margin : '3',
        	text : '取消',
        	name : 'btn-cancel',
        	iconCls: 'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	}
});

