/**
 * 入库上架操作信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2015-07-21
 */
Ext.onReady(function(){
	//库位号store
	locationStore = Ext.create('WMS.store.baseinfo.WarehouseLocationStr',{
    	params:{
    	 	areaId: -1,
    	 	areaNature:-1,
    	 	status : 1
    	},
    	url: 'warehouseLocation/getWarehouseLocationViewList.action'         	
    });
});
Ext.define('WMS.view.instock.InstockBillEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.instockbilleditview',
	title : '入库上架操作信息编辑',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	autoHeight : true,
	width : 870,
	//height : 580,
	layout : 'fit',
	modal : true,
	stores : [
    		'WMS.store.instock.InstockBillItemGoodsViewStr'
	],
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createInstockDemand(),
				this.fbar=this.createGoodsInfo()
			]	
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '6',
        	text : '保存',
        	name : 'btn-save',
        	iconCls:'btn-save'
    	},{
    		xtype : 'button',
        	margin : '6',
        	text : '取消',
        	name : 'btn-cencel',
        	iconCls:'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	},
	//创建预约入库编辑form
	createInstockDemand : function(){
		var instockDemand={
			xtype : 'form',
			border : false,
			margin : '10',
			items : [{
			    xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
	        		xtype : 'label',
			        margin: '10 0 0 13',
	        		width : 70,
	        		name : 'demandNoLabel',
	        		text : '入库需求号:',
	        		style: 'text-align: right;'
				},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'demandNo',
			        width:145
				},{
		    		xtype: 'label',
			        margin: '10 0 0 105',
	        		name : 'appointmentDateLabel',
			        width:70,
	        		text : '预约日期:',
	        		style: 'text-align: right;'
				},{
					xtype : 'displayfield',
	        		width : 145,
	        		name : 'appointmentDate',
	        		margin: '5 0 0 5'
				},{
					xtype : 'label',
	        		width : 90,
	        		name : 'planArrivalTimeLabel',
	        		margin: '10 0 0 10',
	        		text : '计划到货时间:',
	        		style: 'text-align: right;'
		    	},{
		    		xtype : 'displayfield',
	        		width : 145,
	        		name : 'planArrivalTime',
	        		margin: '5 0 0 5'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'supplierIdLabel',
			        width:70,
	        		text : '供应商:',
	        		style: 'text-align: right;'
		    	},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'supplierName',
	        		width : 200
		    	},{
		    		xtype: 'label',
			        margin: '10 0 0 50',
			        name: 'deliverymanLabel',
			        width:70,
	        		text : '送货人:',
	        		style: 'text-align: right;'
		    	},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'deliveryman',
	        		width : 145
		    	},{
		    		xtype : 'label',
	        		width : 90,
	        		margin: '10 0 0 10',
	        		name : 'actualArrivalTimeLabel',
	        		text : '实际到货时间:',
	        		style: 'text-align: right;'
		    	},{
		    		xtype : 'displayfield',
	        		width : 145,
	        		name : 'actualArrivalTime',
	        		margin: '5 0 0 5'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'orderNoLabel',
			        width:70,
	        		text : '订单号:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'orderNo',
	        		width : 145	
		    	},{
		    		xtype: 'label',
			        margin: '10 0 0 105',
			        name: 'vehicleNoLabel',
			        width:70,
	        		text : '车辆号码:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'vehicleNo',
	        		width : 145
		    	},{
					xtype : 'label',
	        		width :90,
	        		name : 'deliveryCompanyLabel',
	        		margin: '10 0 0 10',
	        		text : '送货公司:',
	        		style: 'text-align: right;'
				},{
		    		xtype : 'displayfield',
	        		width : 145,
	        		name : 'deliveryCompany',
	        		margin: '5 0 0 5'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
					xtype : 'label',
	        		width :70,
	        		name : 'itemNoLabel',
	        		margin: '10 0 0 13',
	        		text : '项号:',
	        		style: 'text-align: right;'
				},{
		    		xtype : 'displayfield',
					width:145,
					margin:'5 0 0 5',
	        		name : 'itemNo'
		    	},{
					xtype : 'label',
	        		width :70,
	        		name : 'instockGroupLabel',
	        		margin: '10 0 0 105',
	        		text : '预约入库组:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin:'5 0 0 5',
				    name:'instockGroupName',
					width:145
		    	},{
					xtype : 'label',
	        		width :90,
	        		name : 'actualInstockGroupLabel',
	        		margin: '10 0 0 10',
	        		text : '实际入库组:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    editable: false,
				    name:'actualInstockGroupName',
				    margin: '5 0 0 5',
					width:145
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
					xtype : 'label',
	        		width :70,
	        		name : 'groundingGroupLabel',
	        		margin: '10 0 0 13',
	        		text : '上架组:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    name:'groundingGroupName',
					width:145,
					margin:'5 0 0 5'
		    	},{
					xtype : 'label',
	        		width :70,
	        		name : 'statusLabel',
	        		margin: '10 0 0 105',
	        		text : '入库状态:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    name:'displayStatus',
					width:145,
					margin:'5 0 0 5'
		    	}]
			}]
		};
		return instockDemand;
	},
	//创建预约入库货物明细
	createGoodsInfo : function(){
		var goodsInfo={
			xtype : 'grid',
			width : 860,
			autoScroll : true,
			border : false,
			height : 295,
			columns : this.createColumns(),
			store : 'WMS.store.instock.InstockBillItemGoodsViewStr',
			plugins:[
					Ext.create('Ext.grid.plugin.CellEditing', {
						clicksToEdit: 1 //设置单击单元格编辑  
					})  
				],
			listeners : {
				beforeedit : function(editor, e, eOpts){
					var groundingStatus = e.record.data.groundingStatus;
					if(groundingStatus != 0){
						var flag = true;
						e.cancel = null == groundingStatus || "" == groundingStatus? false : true;
					}
				}
			}
		};
		return goodsInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
  		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'left'
	      	}),
	      	{ text: '货物号', dataIndex: 'goodsCode', width:100,style :"text-align:center",align:'left'},
		    { text: '品名', dataIndex: 'goodsName', width:110,style :"text-align:center",align:'left'},
		    { text: '生产批号', dataIndex: 'actualProductBatch', width:130, style :"text-align:center", align:'left'},
      	  	{ text: '任务入库数量', dataIndex: 'planArrivalQuantity', width:130, style :"text-align:center", align:'left'},
      	  	{ text: '规格', dataIndex: 'specs', style :"text-align:center", width:120,  align:'left'},
      	  	{ text: '卸货方式', dataIndex: 'unloadWayName', width:130, style :"text-align:center", align:'left'},
		    { text: '实际库位', dataIndex: 'actualLocation', style :"text-align:center", width:120,  align:'left',field:{
      			xtype:'combobox',
			    queryMode: 'remote',
			    name:'locationCbx',
	            displayField: 'locationNo',
	            valueField: 'locationId',
	            editable: true,
	            allowBlank:true,
	           // forceSelection:true,//所选择的值限制在下拉框的值中
	            //监听事件对下拉选项进行模糊匹配
	            listeners:{
	            	beforequery:function(e){
	            		var combo =e.combo;
	            		if(!e.forceAll){
	            			var value = e.query;
	            			combo.store.filterBy(function(record,id){
	            				var text = record.get(combo.displayField);
	            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
	            				// 如果是字母 true
	            				if (regFile.test(value) == true){
	            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
	            					record.set('code', code);
		            				text = record.get('code');
	            				}
	            				return(text.indexOf(value)!=-1);
	            			});
	            			combo.expand();
	            			return false;
	            		}
	            	}
	            },
				listConfig: {
	            	getInnerTpl: function(displayField) {
	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
	                },
	             
	            },
	            emptyText: "--选择或输入--", 
	            store:locationStore
	         },renderer:function(value,metaData,record,rowIndex,colIndex,store){
	         	if(undefined == value || '' == value) {
            		return value;
            	}
            	var index = locationStore.find('locationId', value);
            	if(-1 == index) {
            		return value;
            	}
                var record = locationStore.getAt(index);
                if(undefined == record) {
            		return value;
            	}
            	return record.data.locationNo;
	         }},
	    	{ text: '单价', dataIndex: 'price', width:80, style :"text-align:center",  align:'left'},
		    { text: '金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'left',
		    renderer:function(value,metaData,record,rowIndex,colIndex,store){
                	var planArrivalQuantity = (null == record.data.planArrivalQuantity ? 0 : record.data.planArrivalQuantity);
	      	    	var price =(null == record.data.price ? 0 : record.data.price);
	      	    	 
	      	        return (planArrivalQuantity*10000) * (price*10000)/100000000;
    		}},
		    { text: '入库库区', dataIndex: 'areaName', width:90, style :"text-align:center",  align:'left'},
		    { text: '上架状态', dataIndex: 'displayGroundingStatus', width:90, style :"text-align:center",  align:'left'}
		];
		return columns;		
	}
});
