/**
 * 核实数量信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.onReady(function(){
	//卸货方式store
	unloadWayStore =  Ext.create('WMS.store.common.DictStr',{
    	params:{
			dictType: 7,
    	 	status: 1
    	},
    	url: 'dict/getDictList.action'        	
    });
});
Ext.define('WMS.view.instock.InstockCheckNumberEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.instockchecknumbereditview',
	id :'instockchecknumbereditview',
	title : '核实数量信息编辑',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	autoHeight : true,
	width : 860,
	//height : 522,
	layout : 'fit',
	modal : true,
	requires : [
		'Ext.ux.form.DateTimeField'
	],
	stores:[
	    'WMS.store.instock.InstockDemandBillItemGoodsViewStr'
	],
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createInstockDemand(),
				this.createGoodsInfo()
			]	
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '6',
        	text : '保存',
        	name : 'btn-save',
        	iconCls:'btn-save'
    	},{
    		xtype : 'button',
        	margin : '6',
        	text : '取消',
        	name : 'btn-cancel',
        	iconCls:'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	},
	//创建预约入库编辑form
	createInstockDemand : function(){
		var instockDemand={
			xtype : 'form',
			border : false,
			margin : '10',
			items : [{
			    xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
		        	labelAlign : 'right',
				    labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'demandNoLabel',
			        width:70,
	        		text : '入库需求号:',
	        		style: 'text-align: right;'
				},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'demandNo',
			        width:200
				},{
		    		xtype: 'label',
			        margin: '10 0 0 50',
			        name: 'appointmentDateLabel',
			        width:70,
	        		text : '预约日期:',
	        		style: 'text-align: right;'
				},{
					xtype : 'displayfield',
	        		width : 145,
	        		name : 'appointmentDate',
	        		margin: '5 0 0 5'
				},{
					xtype : 'label',
	        		width : 100,
	        		name : 'planArrivalTimeLabel',
	        		margin: '10 0 0 10',
	        		text : '计划到货时间:',
	        		style: 'text-align: right;'
				},{
		    		xtype : 'displayfield',
	        		width : 130,
	        		name : 'planArrivalTime',
	        		margin: '5 0 0 5'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'supplierIdLabel',
			        width:70,
	        		text : '供应商:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'supplierName',
	        		width : 200
		    	},{
		    		xtype: 'label',
			        margin: '10 0 0 50',
			        name: 'deliverymanLabel',
			        width:70,
	        		text : '送货人:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'deliveryman',
	        		width : 145
		    	},{
		    		xtype : 'datetimefield',
	        		width : 230,
	        		labelWidth : 100,
	        		name : 'actualArrivalTime',
	        		allowBlank : false,
	        		margin: '5 0 0 10',
	        		fieldLabel : '实际到货时间:',
	        		format : "Y-m-d",
					length:19,
					vtype:'datetime',
					compareTo:'planArrivalTime',
					vtypeText : '实际到货时间必须晚于计划到货时间'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'orderNoLabel',
			        width:70,
	        		text : '订单号:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'orderNo',
	        		width : 145
		    	},{
		    		xtype: 'label',
			        margin: '10 0 0 105',
			        name: 'itemNoLabel',
			        width:70,
	        		text : '项号:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'itemNo',
	        		width : 143
		    	},{
					xtype : 'label',
	        		width : 100,
	        		name : 'deliveryCompanyLabel',
	        		margin: '10 0 0 10',
	        		text : '送货公司:',
	        		style: 'text-align: right;'
				},{
		    		xtype : 'displayfield',
	        		width : 130,
	        		name : 'deliveryCompany',
	        		margin: '5 0 0 5'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'vehicleNoLabel',
			        width:70,
	        		text : '车辆号码:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'vehicleNo',
	        		width : 145
		    	},{
		    		xtype: 'label',
			        margin: '10 0 0 105',
			        name: 'entryLabel',
			        width:70,
	        		text : '预约入库组:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    name:'instockGroupName',
				    margin: '5 0 0 5',
	        		width : 145
		    	},{
		    		xtype:'combobox',
				    fieldLabel:'实际入库组',
				    editable: false,
				    allowBlank : false,
				    name:'actualInstockGroup',
				    margin: '5 0 0 10',
	        		width : 250,
	        		labelWidth : 100,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 7);
    	                }
    	            },
	        		queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            emptyText: "--请选择--", 
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 10,
		            	 	status: 1
		            	},
		            	url: 'dict/getDictList.action'        	
		            }).load()
		    	},{
            		xtype: 'hiddenfield',
    	    		name: 'oldQuantity'
		    	}]
			}]
		};
		return instockDemand;
	},
	//创建预约入库货物明细
	createGoodsInfo : function(){
		var goodsInfo={
			xtype : 'grid',
			border : false,
			autoScroll:true,
			height : 293,
			store :  'WMS.store.instock.InstockDemandBillItemGoodsViewStr',
			columns : this.createColumns(),
			plugins:[
				Ext.create('Ext.grid.plugin.CellEditing', {
					clicksToEdit: 1 //设置单击单元格编辑  
				})
			],
			listeners : {
				beforeedit : function(editor, e, eOpts){
					//实际到货数量
					var actualArrivalQuantity = e.record.data.actualArrivalQuantity;
					if(null !=actualArrivalQuantity ||"" !=actualArrivalQuantity){
						//将实际到货数量赋给隐藏框
						var oldQuantity = this.up('window').down('hiddenfield[name=oldQuantity]').setValue(actualArrivalQuantity);
					}
				},
				edit : function(editor, e, eOpts){
					if(7 == e.colIdx){
						//实际到货数量
						var actualArrivalQuantity = e.record.data.actualArrivalQuantity;
						//获取隐藏框的值
						var oldQuantity = this.up('window').down('hiddenfield[name=oldQuantity]').getValue();
						//实际到货数量
						var actualArrivalQuantity = e.record.data.packingSpecs;
						if(undefined !=actualArrivalQuantity){
							if(actualArrivalQuantity !=oldQuantity){
								e.record.data.packingSpecs = '';
								e.record.commit();
							}
						}						
					}
				}
			}
		};
		return goodsInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
  		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'left'
	      	}),
	      	{text: '货物号', dataIndex: 'goodsCode', width:100,style :"text-align:center",align:'left'},
		    { text: '品名', dataIndex: 'goodsName', width:110,style :"text-align:center",align:'left'},
		    { text: '规格', dataIndex: 'specs', style :"text-align:center", width:120,  align:'left'},
		    { text: '生产批号', dataIndex: 'productBatch', width:130, style :"text-align:center", align:'left'},
		    { text: '实际到货生产批号', dataIndex: 'actualProductBatch', width:130, style :"text-align:center", align:'left',field:{
		    	allowBlank: true,
		    	length:20,
        		vtypeText : '实际到货生产批号最多可输入20个字符<br>实际到货生产批号不能输入中文',
    		    vtype: 'exceptChinese'
	      	}},
      	  	{ text: '计划到货数量', dataIndex: 'planArrivalQuantity', width:130, style :"text-align:center", align:'left'},
      	  	{ text: '实际到货数量', dataIndex: 'actualArrivalQuantity', width:130, style :"text-align:center", align:'left',field:{
	      		allowBlank: true,
	      		length:15,
        		vtypeText : '实际到货数量最多可输入15个字符<br>实际到货数量只能输入正整数',
    		    vtype: 'currency'
	      	}},
      	  	{ text: '包装规格', dataIndex: 'packingSpecs', width:130, style :"text-align:center", align:'left'},
      	  	{ text: '卸货方式', dataIndex: 'unloadWay', width:130, style :"text-align:center", align:'left',field:{
      			xtype:'combobox',
	            displayField: 'dictName',
	            valueField: 'dictId',
	            emptyText: "--请选择--", 
				listConfig: {
	            	getInnerTpl: function(displayField) {
	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 7);
	                }
	            },
	            editable: false,
	            allowBlank : false,
	            store: unloadWayStore
	         },renderer:function(value,metaData,record,rowIndex,colIndex,store){
            	if(undefined == value || '' == value) {
            		return value;
            	}
            	var index = unloadWayStore.find('dictId', value);
            	if(-1 == index) {
            		return value;
            	}
                var record = unloadWayStore.getAt(index);
                if(undefined == record) {
            		return value;
            	}
                return record.data.dictName;
      	    }},
		    { text: '单价', dataIndex: 'price', width:80, style :"text-align:center",  align:'left'},
		    { text: '金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'left',
		    renderer:function(value,metaData,record,rowIndex,colIndex,store){
                	var actualArrivalQuantity = (null == record.data.actualArrivalQuantity ? 0 : record.data.actualArrivalQuantity);
	      	    	var price =(null == record.data.price ? 0 : record.data.price);
	      	    	 
	      	        return (actualArrivalQuantity*10000) * (price*10000)/100000000;
        		}
    		},
		    { text: '入库库区', dataIndex: 'areaName', width:90, style :"text-align:center",  align:'left'}
		];
		return columns;		
	}
});
