/**
 * 核实数量信息管理view.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.define('WMS.view.instock.InstockCheckNumberSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.instockchecknumbersearchview',
	resizable : false,
	closeAction : 'hide',
	multiSelect : true,
	loadMask : true,
	layout:'fit',
	requires : [
	    'WMS.store.instock.InstockDemandBillViewStr',
		'Ext.ux.form.DateTimeField'
	],
	models : [
		'WMS.model.instock.InstockDemandBillViewMdl'
	],
	stores : [
		'WMS.store.instock.InstockDemandBillViewStr'
	],
	 
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'form',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
				    xtype:'textfield',
					fieldLabel:'入库需求号',
					name:'demandNo',
					labelWidth:90,
					width:250,
					length:15,
	        		vtypeText : '入库需求号最多可输入15个字符',
        		    vtype: 'exceptChinese'
				},{
			        xtype:'datefield',
					fieldLabel:'预约开始日期',
					name:'instockDemandBillBeginDate',
					labelWidth:120,
					width:280,
					format : "Y-m-d",
					length:10,
	        		vtypeText:'预约开始日期必须早于或等于预约结束日期',
	        		vtype: 'date'
		  		},{
			        xtype:'datefield',
					fieldLabel:'预约结束日期',
					name:'instockDemandBillEndDate',
					labelWidth:120,
					width:280,
					format : "Y-m-d",
					length:10,
	        		vtypeText:'预约结束日期必须晚于或等于预约开始日期',
	        		vtype: 'date',
	        		compareTo:'instockDemandBillBeginDate'
		    	}]	
			},{
				xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 70,
	        	 	margin: 6
				},
				items:[{
					xtype:'combobox',
				    fieldLabel:'供应商',
				    // allowBlank:false,
				    name:'supplierId',
					labelWidth:90,
					width:250,
	        		emptyText: "--选择或输入--",
	        		editable: true,
	        		forceSelection:true,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
    	                }
    	            },
	        		displayField: 'supplierName',
		            valueField: 'supplierId',
		            store: Ext.create('WMS.store.baseinfo.SupplierViewStr',{
		            	params:{
		            	 	status: 1
		            	},
		            	url: 'supplier/getSupplierList.action'        	
		            }),
		            
		            //监听事件对下拉选项进行模糊匹配
		            listeners:{
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
		            				// 如果是字母 true
		            				if (regFile.test(value) == true){
		            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
		            					record.set('code', code);
			            				text = record.get('code');
		            				}
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
		   		},{
			        xtype:'datetimefield',
					fieldLabel:'计划到货开始时间',
					name:'planDemandBillBeginDate',
					labelWidth:120,
					width:280,
					format : "Y-m-d",
					length:19,
					vtype:'datetime',
					vtypeText : '计划到货开始时间必须早于计划到货结束时间'
		  		},{
			        xtype:'datetimefield',
					fieldLabel:'计划到货结束时间',
					name:'planDemandBillEndDate',
					labelWidth:120,
					width:280,
					format : "Y-m-d",
					vtype:'datetime',
					length:19,
					compareTo:'planDemandBillBeginDate',
					vtypeText : '计划到货结束时间必须晚于计划到货开始时间。'
		    	}]
		   	},{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[/*{
					xtype:'combobox',
				    fieldLabel:'入库库区',
				    name:'entry',
					labelWidth:90,
					width:250,
					editable: false
				},*/{
			    	xtype:'textfield',
					fieldLabel:'订单号',
					name:'orderNo',
					labelWidth:90,
					width:250,
					length:20,
	        		vtypeText : '订单号最多可输入20个字符',
        		    vtype: 'exceptChinese'
		   		},{
		   			border:false
		   		},{
		    		border:false
		    	},{
		    		xtype:'checkbox',
		    		boxLabel:'<span>显示禁用项</span><img data-qtip="选中时显示所有查询条件（下拉框项）中已禁用的项，<br/>查询结果中包含已禁用项的结果；未选中时不显示" src="images/hint.png" class="hintico">',
		    		name: 'showForbidden',
		    		checked: true
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'查询',
			    	name:'btn-search',
			    	iconCls:'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'重置',
			    	name:'btn-clear',
			    	iconCls:'btn-clear'
	   			}]	
			}]
		};
		
		return scPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel()
			]
		};
	},
	//创建表格列  bug:632 将序号宽度从40改为60  彭婷婷
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:center", align:'center'
	      	}),
	      	{ text: '入库需求号', dataIndex: 'demandNo', width:140,style :"text-align:center",align:'left'},
		    { text: '预约日期', dataIndex: 'appointmentDate', width:90,style :"text-align:center",align:'center'},
		    { text: '计划到货时间', dataIndex: 'planArrivalTime', style :"text-align:center", width:140,  align:'center'},
		    { text: '供应商', dataIndex: 'supplierName', width:160, style :"text-align:center", align:'left'},
		    { text: '订单号', dataIndex: 'orderNo', width:100, style :"text-align:center", align:'left'},
		    { text: '项号', dataIndex: 'itemNo', width:100, style :"text-align:center", align:'left'},
		    { text: '送货公司', dataIndex: 'deliveryCompany', width:160, style :"text-align:center",  align:'left'},
		    { text: '车辆号码', dataIndex: 'vehicleNo', width:90, style :"text-align:center",  align:'left'},
		    { text: '送货人', dataIndex: 'deliveryman', width:80, style :"text-align:center",  align:'left'},
		    { text: '预约入库组', dataIndex: 'instockGroupName', width:100, style :"text-align:center",  align:'left'},
		    ACBEE.Ext.Util.createEditBtn(this.functionCodes)
		];
			return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的核实数量信息！',
			store : Ext.create('WMS.store.instock.InstockDemandBillViewStr',{
				params : {
					flag : 0
				}				
			}),
			/********
			 * 2015/12/26
			 * 王玉涛
			 * bug745
			 */
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
	listeners : {
		afterrender : function(view, eOpts){
			view.down('pagingtoolbar').bindStore(view.getStore());
		}
	}
});
