/**
 * 预约入库信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.onReady(function(){
	//入库库区store
	instockStore = Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
    	params:{
    	 	areaNature: -1,
    	 	status: 1
    	},
    	url: 'warehouseArea/getWarehouseAreaList.action'        	
    });
});
Ext.define('WMS.view.instock.InstockDemandBillEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.instockdemandbilleditview',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	title: '编制入库需求单',
	closeAction : 'hide',
	width : 880,
	height : 545,
	layout : 'fit',
	modal : true,
	requires : [
		'Ext.ux.form.DateTimeField'
	],
	stores:[
	    'WMS.store.instock.InstockDemandBillItemGoodsViewStr'
	],
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createInstockDemand(),
				this.createGoodsInfo()
			]
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '5',
        	text : '保存',
        	name : 'btn-save',
        	iconCls: 'btn-save'
    	},{
    		xtype : 'button',
        	margin : '5',
        	text : '打印',
        	name : 'btn-print'
    	},{
    		xtype : 'button',
        	margin : '5',
        	text : '取消',
        	name : 'btn-cancel',
        	iconCls: 'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	},
	//创建预约入库编辑form
	createInstockDemand : function(){
		var instockDemand={
			xtype : 'form',
			border : false,
			margin : '10',
			items : [{
			    xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
	        		xtype : 'textfield',
	        		width : 270,
	        		labelWidth : 100,
	        		name : 'demandNo',
	        		allowBlank : false,
	        		fieldLabel : '入库需求号',
	        		readOnly : false,
	        		length:15,
	        		vtypeText : '入库需求号最多可输入15个字符<br>入库需求号不能输入中文',
        		    vtype: 'exceptChinese'
				},{
					xtype : 'datefield',
	        		width : 237,
	        		labelWidth : 67,
	        		name : 'appointmentDate',
	        		allowBlank : false,
	        		fieldLabel : '预约日期',
					format : "Y-m-d",
					length:10,
	        		vtypeText:'预约日期必须早于计划到货时间',
	        		vtype: 'date'
				},{
		    		xtype : 'datetimefield',
	        		width : 260,
	        		labelWidth : 100,
	        		name : 'planArrivalTime',
	        		fieldLabel : '计划到货时间',
	        		allowBlank : false,
					format : "Y-m-d",
					length:19,
					vtype:'datetime',
					compareToDate: true,
					compareTo: 'appointmentDate',
					vtypeText : '计划到货时间必须晚于预约日期'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype:'combobox',
				    fieldLabel:'供应商',
				    allowBlank:false,
				    name:'supplierId',
				    labelWidth : 100,
	        		width : 270,
	        		emptyText: "--选择或输入--",
	        		editable: true,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
    	                }
    	            },
	        		displayField: 'supplierName',
		            valueField: 'supplierId',
		            store: Ext.create('WMS.store.baseinfo.SupplierViewStr',{
		            	params:{
		            	 	status: 1
		            	},
		            	url: 'supplier/getSupplierList.action'        	
		            }),
		            
		            //监听事件对下拉选项进行模糊匹配
		            listeners:{
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
		    	},{
		    		xtype:'combobox',
				    fieldLabel:'入库性质',
				    editable: false,
				    name:'instockNature',
				    emptyText: "--请选择--", 
	        		width : 237,
	        		labelWidth : 67,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
    	                }
    	            },
	        		allowBlank : false,
	        		queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 3,
		            	 	status: 1
		            	},
		            	url: 'dict/getDictList.action'        	
		            }).load()
		    	},{
		    		xtype : 'textfield',
	        		width : 260,
	        		labelWidth : 100,
	        		name : 'deliveryCompany',
	        		allowBlank : true,
	        		fieldLabel : '送货公司',
	        		length:100,
	        		vtypeText : '送货公司最多可输入100个字符',
        		    vtype: 'limitLen'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype : 'textfield',
	        		width : 270,
	        		labelWidth : 100,
	        		name : 'orderNo',
	        		fieldLabel : '订单号'	,
	        		length:20,
	        		vtypeText : '订单号最多可输入20个字符<br>订单号不能输入中文',
        		    vtype: 'exceptChinese'
		    	},{
		    		xtype : 'textfield',
	        		width : 237,
	        		labelWidth : 67,
	        		name : 'itemNo',
	        		fieldLabel : '项号',
	        		length:5,
	        		vtypeText : '项号最多可输入5个字符<br>项号只能输入数字',
        		    vtype: 'currency'
		    	},{
		    		xtype:'combobox',
				    fieldLabel:'预约入库组',
				    editable: false,
				    name:'instockGroup',
	        		width : 260,
	        		labelWidth : 100,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 7);
    	                }
    	            },
	        		allowBlank : false,
	        		queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            emptyText: "--请选择--", 
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 10,
		            	 	status: 1
		            	},
		            	url: 'dict/getDictList.action'        	
		            }).load()
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype : 'textfield',
	        		width : 270,
	        		labelWidth : 100,
	        		name : 'vehicleNo',
	        		allowBlank : true,
	        		fieldLabel : '车辆号码',
	        		length:10,
	        		/**
	        		 * @author 李树雪 2015年12月22日 上午17.24
	        		 * @bug 717
	        		 * @code:269-275
	        		 */
	        		vtypeText : '车辆号码格式不对，应该以汉字开头，后面是6位数字或字母。<br><br>如：京A00000',
        		    vtype: 'checkNumber'
		    	},{
		    		xtype : 'textfield',
	        		width : 237,
	        		labelWidth : 67,
	        		name : 'deliveryman',
	        		allowBlank : true,
	        		fieldLabel : '送货人'	,
        			length:20,
	        		vtypeText : '送货人最多可输入20个字符<br>送货人不能输入数字',
        		    vtype: 'exceptNumber'
		    	},{
		    		xtype : 'label',
			        margin: '10 0 0 15',
	        		width : 80,
	        		text : '货物总数量：'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 0',
			        name: 'totalQuantity',
			        width: 50
				},{
		    		xtype : 'label',
			        margin: '10 0 0 0',
	        		width : 80,
	        		text : '货物总金额：'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 0',
		            name: 'totalPrice',
		            width: 80
				}]
			}]
		};
		return instockDemand;
	},
	//创建预约入库货物明细
	createGoodsInfo : function(){
		var goodsInfo={
			xtype : 'grid',
			border : false,
			autoScroll : true,
			height : 295,
			selModel:Ext.create('Ext.selection.RowModel',{mode:"SIMPLE"}),
			store :  'WMS.store.instock.InstockDemandBillItemGoodsViewStr',
			columns : this.createColumns(),
			listeners : {
				beforeedit : function(editor, e, eOpts){
					if(this.up('window').oldInstockDemandBillId!=0 && this.up('window').status){
						var areaId = e.record.data.areaId;
						e.cancel = (null == areaId || "" == areaId ? false : true);
					}
				},
				edit:function(editor,e){
					if(1 == e.colIdx){
						var goodsCode = this.down('textfield[name=goodsCode]').getValue();
						ACBEE.Ext.Util.ajaxRequest("goods/searchGoodsByGoodsCode.action",{goodsCode:goodsCode},function(result){
							if(true == result.success){
								e.record.data.goodsCode = result.map.goodsCode;
								e.record.data.goodsName = result.map.goodsName;
								e.record.data.price = result.map.price;
		                		e.record.data.specs = result.map.specs;
		                		e.record.data.goodsId = result.map.goodsId;
		                		//e.record.data.goodsCode = result.map.goodsCode;
		                		e.record.data.productBatch = '';
	                			e.record.data.areaId = '';
		                		e.record.data.planArrivalQuantity = '';
							} else {
								ACBEE.Ext.Util.showAlertBox(result.msg);
								e.record.data.goodsCode = '';
								e.record.data.goodsName = '';
								e.record.data.price = '';
								e.record.data.specs = '';
								e.record.data.goodsId = '';
								e.record.data.planArrivalQuantity = '';
								e.record.data.productBatch = '';
								e.record.data.areaId = '';
							}
							e.record.commit();
						});
					}
				}
			},
			plugins:[
					Ext.create('Ext.grid.plugin.CellEditing', {
						clicksToEdit: 1 //设置单击单元格编辑  
					})  
				],
		 	fbar:[{
		        	xtype : 'button',
		        	margin : '6',
		        	text : '添加',
		        	name : 'btn-add',
		        	iconCls: 'btn-add'
	        	},{
		        	xtype : 'button',
		        	margin : '6',
		        	text : '导入',
		        	name : 'btn-import',
		        	iconCls: 'btn-import'
	        	},{
		        	xtype : 'button',
		        	margin : '6',
		        	text : '导出',
		        	name : 'btn-export',
		        	iconCls: 'btn-export'
	        	},{
		        	xtype : 'button',
		        	margin : '6',
		        	text : '删除',
		        	name : 'btn-delete',
		        	iconCls: 'btn-delete'
	        	},'->'
        	]
		};
		return goodsInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
   		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'left'
	      	}),
	      	{text: '货物号', dataIndex: 'goodsCode', width:110,style :"text-align:center",align:'left',field:{
	      		allowBlank: false,
	      		length:20,
        		vtypeText : '货物号最多可输入20个字符<br>货物号不能输入中文',
    		    vtype: 'exceptChinese'
	      	}
   		    /*
   		     * bug:718  苏雅欣  未与供应商关联，取消combobox展现方式
   		     */
	      	/*{
	      		xtype:'combobox',
	      		name:'goodsCode',
	      		allowBlank: false,
	      		forceSelection: true,
        		displayField: 'goodsCode',
	            valueField: 'goodsId',
	      		length:20,
        		vtypeText : '货物号最多可输入20个字符<br>货物号不能输入中文',
    		    vtype: 'exceptChinese',
    		    listConfig: {
	            	getInnerTpl: function(displayField) {
	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 20);
	                }
	            },
	            store: Ext.create('WMS.store.baseinfo.GoodsStr',{
	            	params:{
	            	 	status: -1
	            	},
	            	url: 'goods/getGoodsList.action'        	
	            }),
	      	}*/},
		    { text: '品名', dataIndex: 'goodsName', width:110,style :"text-align:center",align:'left'},
		    { text: '规格', dataIndex: 'specs', style :"text-align:center", width:120,  align:'left'},
		    { text: '生产批号', dataIndex: 'productBatch', width:110, style :"text-align:center", align:'left',field:{
		    	allowBlank: true,
		    	length:20,
        		vtypeText : '生产批号最多可输入20个字符<br>生产批号不能输入中文',
    		    vtype: 'exceptChinese'
	      	}},
		    { text: '计划到货数量', dataIndex: 'planArrivalQuantity', width:110, style :"text-align:center", align:'left',field:{
	      		allowBlank: true,
	      		length:15,
        		vtypeText : '计划到货数量最多可输入15个字符<br>计划到货数量只能输入正整数',
    		    vtype: 'currency'
	      	}},
		    { text: '单价', dataIndex: 'price', width:100, style :"text-align:center",  align:'left'},
		    { text: '金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'left',
		    renderer:function(value,metaData,record,rowIndex,colIndex,store){
            	var planArrivalQuantity = (null == record.data.planArrivalQuantity ? 0 : record.data.planArrivalQuantity);
      	    	var price =(null == record.data.price ? 0 : record.data.price);
      	    	
      	    	record.data.totalPrice = (planArrivalQuantity*10000) * (price*10000)/100000000;
      	        return (planArrivalQuantity*10000) * (price*10000)/100000000;
        	}},
            {text: '入库库区', dataIndex: 'areaName', hidden: true},
		    { text: '入库库区', dataIndex: 'areaId', width:140, style :"text-align:center",  align:'left',field:{
      			xtype:'combobox',
			    editable: false,
	            displayField: 'areaName',
	            valueField: 'areaId',
	            emptyText: "--请选择--", 
	            store:instockStore,
				listConfig: {
	            	getInnerTpl: function(displayField) {
	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
	                }
	            },
	            allowBlank : false
	         },renderer:function(value,metaData,record,rowIndex,colIndex,store){
            	if(undefined == value || '' == value) {
            		return value;
            	}
            	var index = instockStore.find('areaId', value);
            	if(-1 == index) {
            		return value;
            	}
                var r = instockStore.getAt(index);
                if(undefined == r) {
            		return value;
            	}
                
                record.data.areaName = r.data.areaName;
                return r.data.areaName;
      	    }}
		];
		return columns;		
	}
});
