/**
 * 入库任务分配信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2015-07-21
 */
Ext.define('WMS.view.instock.InstockTaskEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.instocktaskeditview',
	title : '入库任务分配信息编辑',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	autoHeight : true,
	width : 860,
	//height : 590,
	layout : 'fit',
	modal : true,
	requires : [
	    		'Ext.ux.form.DateTimeField'
	],
	stores : [
    		'WMS.store.instock.InstockBillItemGoodsViewStr'
	],
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createInstockDemand(),
				this.createGoodsInfo()
			]	
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '6',
        	text : '保存',
        	name : 'btn-save',
        	iconCls:'btn-save'
    	},{
    		xtype : 'button',
        	margin : '5',
        	text : '打印',
        	name : 'btn-print'
    	},{
    		xtype : 'button',
        	margin : '6',
        	text : '取消',
        	name : 'btn-cancel',
        	iconCls:'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	},
	//创建预约入库编辑form
	createInstockDemand : function(){
		var instockDemand={
			xtype : 'form',
			border : false,
			margin : '10',
			items : [{
			    xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'demandNoLabel',
			        width:70,
	        		text : '入库需求号:',
	        		style: 'text-align: right;'
				},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'demandNo',
			        width:145
				},{
		    		xtype: 'label',
			        margin: '10 0 0 105',
			        name: 'appointmentDateLabel',
			        width:70,
	        		text : '预约日期:',
	        		style: 'text-align: right;'
				},{
					xtype : 'displayfield',
	        		width : 145,
	        		name : 'appointmentDate',
	        		margin: '5 0 0 5'
				},{
					xtype : 'label',
	        		width : 100,
	        		name : 'planArrivalTimeLabel',
	        		margin: '10 0 0 10',
	        		text : '计划到货时间:',
	        		style: 'text-align: right;'
				},{
		    		xtype : 'displayfield',
	        		width : 145,
	        		name : 'planArrivalTime',
	        		margin: '5 0 0 5'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'supplierIdLabel',
			        width:70,
	        		text : '供应商:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'supplierName',
	        		width : 200
		    	},{
		    		xtype: 'label',
			        margin: '10 0 0 50',
			        name: 'deliverymanLabel',
			        width:70,
	        		text : '送货人:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'deliveryman',
	        		width : 145
		    	},{
		    		xtype: 'label',
			        margin: '10 0 0 10',
			        name: 'actualArrivalTimeLabel',
			        width:100,
	        		text : '实际到货时间:',
	        		style: 'text-align: right;'
				},{
		    		xtype : 'displayfield',
	        		width : 145,
	        		name : 'actualArrivalTime',
	        		margin: '5 0 0 5'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'orderNoLabel',
			        width:70,
	        		text : '订单号:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '5 0 0 5',
				    name:'orderNo',
	        		width : 145
		    	},{
		    		xtype : 'label',
					width:70,
					margin: '10 0 0 105',
	        		name : 'itemNoLabel',
	        		text : '项号:',
	        		style: 'text-align: right;'
		    	},{
		    		xtype : 'displayfield',
					width:145,
	        		name : 'itemNo',
	        		 margin: '5 0 0 5'
		    	},{
		    		xtype:'combobox',
				    fieldLabel:'上架组',
				    editable: false,
				    allowBlank : false,
				    margin:'5 0 0 9',
				    name:'groundingGroup',
					labelWidth:100,
					width:245,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 6);
    	                }
    	            },
					queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            emptyText: "--请选择--", 
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 10,
		            	 	status: 1
		            	},
		            	url: 'dict/getDictList.action'        	
		            }).load()
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '5 0 0 13',
			        name: 'vehicleNoLabel',
			        width:70,
	        		text : '车辆号码:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '0 0 0 5',
				    name:'vehicleNo',
	        		width : 145
		    	},{
		    		xtype: 'label',
			        margin: '5 0 0 105',
			        name: 'instockGroupLabel',
			        width:70,
	        		text : '预约入库组:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin:'0 0 0 5',
				    name:'instockGroupName',
					width:145
		    	},{
		    		xtype:'label',
				    text:'实际入库组:',
				    margin:'5 0 0 40',
				    name:'actualInstockGroupLabel',
					width:70,
					style: 'text-align: right;'
		    	},{
		    		xtype:'displayfield',
				    margin:'0 0 0 5',
				    name:'actualInstockGroupName',
					width:145
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
					xtype : 'label',
	        		width : 70,
	        		name : 'deliveryCompanyLabel',
	        		margin: '10 0 0 13',
	        		text : '送货公司:',
	        		style: 'text-align: right;'
				},{
		    		xtype : 'displayfield',
	        		width : 145,
	        		name : 'deliveryCompany',
	        		margin: '5 0 0 5'	
		    	}]
			}]
		};
		return instockDemand;
	},
	//创建预约入库货物明细
	createGoodsInfo : function(){
		var goodsInfo={
			xtype : 'grid',
			border : false,
			height : 311,
			autoScroll:true,
			columns : this.createColumns(),
			store : 'WMS.store.instock.InstockBillItemGoodsViewStr'
		};
		return goodsInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
  		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'left'
	      	}),
	      	{ text: '货物号', dataIndex: 'goodsCode', width:100,style :"text-align:center",align:'left'},
		    { text: '品名', dataIndex: 'goodsName', width:110,style :"text-align:center",align:'left'},
		    { text: '生产批号', dataIndex: 'productBatch', width:130, style :"text-align:center", align:'left'},
		    { text: '实际到货生产批号', dataIndex: 'actualProductBatch', width:130, style :"text-align:center", align:'left'},
      	  	{ text: '任务入库数量', dataIndex: 'planArrivalQuantity', width:130, style :"text-align:center", align:'left'},
      	  	{ text: '规格', dataIndex: 'specs', style :"text-align:center", width:120,  align:'left'},
      	  	{ text: '卸货方式', dataIndex: 'unloadWayName', width:130, style :"text-align:center", align:'left'},
		    { text: '单价', dataIndex: 'price', width:80, style :"text-align:center",  align:'left'},
		    { text: '金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'left',
		    renderer:function(value,metaData,record,rowIndex,colIndex,store){
                	var planArrivalQuantity = (null == record.data.planArrivalQuantity ? 0 : record.data.planArrivalQuantity);
	      	    	var price =(null == record.data.price ? 0 : record.data.price);
	      	    	 
	      	        return (planArrivalQuantity*10000) * (price*10000)/100000000;
    		}},
		    { text: '入库库区', dataIndex: 'areaName', width:90, style :"text-align:center",  align:'left'}
		];
		return columns;		
	}
});
