/**
 * 主界面Tab内容区view.
 * @author 奚志敏
 * @version 1.0.0, 2015-07-07
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.define('WMS.view.main.TabView',{ 
	extend: 'Ext.tab.Panel', 
	alias: 'widget.tabview',
	requires: [
        'Ext.ux.TabCloseMenu',
        'Ext.ux.TabScrollerMenu',
        'WMS.view.guide.IndexView'
  	],
	initComponent : function(){ 
		Ext.History.init();
		
		//设置截断符
	    var tokenDelimiter = ':';
	    Ext.History.add("mainTab:indexview");	
		Ext.apply(this, {
			renderTo: Ext.getBody(),
			id: 'mainTab', 
		    region: 'center',
		    autoScroll : false,
		    plugins: [{
                ptype: 'tabscrollermenu',
                menuPrefixText: '标签',
                maxText  : 10,
                pageSize : 5
            }, Ext.create('Ext.ux.TabCloseMenu', {
		    	closeTabText: '关闭标签',
		    	closeOthersTabsText: '关闭其它标签',
		    	closeAllTabsText: '关闭全部标签'
		    })],
		    tabBar : {
		        height : 30,
		        defaults : {
		            height : 30
		        }
		    },
		    defaults: { 
		    	autoScroll : true,
				bodyPadding : 0 
		    }, 
		    activeTab: 0, 
		    border: false, 
		    
		    items: [{
		    	title: '首页',
		    	xtype: 'indexview'
		    }],
		    /*********************、
		     * 2015/12/22
		     * 王玉涛
		     **************************/
		    listeners: {
	            'tabchange': function(tabPanel, tab){
	            		//main-tabs切换时修改浏览器hash
	            		Ext.History.add(tabPanel.id + tokenDelimiter + tab.id);	
	            	
	            		
	            	
	            	
	            }
	        }
		}); 
	
		
	    //获取浏览器hash中#后面的字符串
	    Ext.History.on('change', function(token){
	    	
	        if(token){
	        //如果有字符串则进行相应处理
	            var parts = token.split(tokenDelimiter);
	            var tabPanel = Ext.getCmp(parts[0]);
	            var tabId = parts[1];
	       //     alert(1);
	            	tabPanel.show();
		            tabPanel.setActiveTab(tabId);
		     
	           
	            
	            
	        }
	        
	    });
		
	    
		this.callParent(arguments); 
	}
});