/**
 * 出库下架操作信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2015-07-21
 */
Ext.onReady(function(){
	commonStore = Ext.create('WMS.store.stock.StockViewStr',{
    	params:{
			goodsId: -1,
	 		supplierId: -1,
	 		locationId: -1,
	 		areaId: -1
    	},
    	hasEmptyItem: true,
    	url: 'stock/getInitCombobxItems.action'
    });
})
Ext.define('WMS.view.outstock.OutstockBillEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.outstockbilleditview',
	id : 'outstockbilleditview',
	title : '出库下架操作信息编辑',
	resizable : true,
	constrainHeader:true,
	autoHeight : true,
	width : 860,
	//height : 585,
	layout : 'fit',
	modal : true,
	stores:[
	    'WMS.store.outstock.OutstockBillItemGoodsViewStr'
	],
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createOutstockDemand(),
				this.createGoodsInfo()
			]	
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '6',
        	text : '保存',
        	name : 'btn-save',
        	iconCls:'btn-save'
    	},{
    		xtype : 'button',
        	margin : '6',
        	text : '取消',
        	name : 'btn-exit',
        	iconCls:'btn-exit',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	},
	//创建预约入库编辑form
	createOutstockDemand : function(){
		var outstockDemand={
			xtype : 'form',
			border : false,
			margin : '10',
			items : [{
			    xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'demandNoLabel',
			        width:70,
	        		style: 'text-align: right;',
	        		text : '出库需求号:'
				},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'demandNo',
			        width:145
				},{
					xtype : 'label',
	        		width : 70,
	        		margin:'10 0 0 95',
	        		name : 'appointmentDateLabel',
	        		text : '预约日期:',
	        		style: 'text-align: right;'
				},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'appointmentDate',
			        width:145
				},{
		    		xtype : 'label',
	        		width : 90,
	        		name : 'planArrivalTimeLabel',
	        		text : '计划出库时间:',
	        		margin:'10 0 0 10',
	        		style: 'text-align: right;'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'planArrivalTime',
			        width:145
				}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype:'label',
				    text:'需方商:',
				    margin:'10 0 0 13',
				    style:'text-align:right;',
				    name:'demanderIdLabel',
	        		width : 70
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'demanderName',
			        width:200
				},{
		    		xtype:'label',
				    text:'提货人:',
				    style:'text-align:right;',
				    name:'pickupPersonLabel',
				    margin:'10 0 0 40',
	        		width : 70
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'pickupPerson',
			        width:145
				},{
		    		xtype : 'label',
	        		width : 90,
				    style:'text-align:right;',
				    margin:'10 0 0 10',
	        		name : 'pickupCompanyLabel',
	        		text : '提货公司:'	
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'pickupCompany',
			        width:145
				}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype : 'label',
	        		width : 70,
	        		name : 'orderNoLabel',
	        		style:'text-align:right;',
	        		margin:'10 0 0 13',
	        		text : '订单号:'	
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'orderNo',
			        width:145
				},{
		    		xtype : 'label',
	        		width : 70,
	        		name : 'itemNoLabel',
	        		style:'text-align:right;',
	        		margin:'10 0 0 95',
	        		text : '项号:'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'itemNo',
			        width:145
				},{
		    		xtype : 'label',
	        		width : 90,
	        		name : 'vehicleNoLabel',
	        		style:'text-align:right;',
	        		margin:'10 0 0 10',
	        		text : '车辆号码:'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'vehicleNo',
			        width:145
				}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype : 'label',
	        		width : 70,
	        		name : 'outstockNatureLabel',
	        		style:'text-align:right;',
	        		margin:'10 0 0 13',
	        		text : '出库性质:'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'outstockNatureName',
			        width:145
				},{
		    		xtype : 'label',
	        		width : 70,
	        		name : 'outstockGroupLabel',
	        		style:'text-align:right;',
	        		margin:'10 0 0 95',
	        		text : '出库组:'
		    	},{
		    		xtype:'displayfield',
				    margin:'5 0 0 5',
				    name:'outstockGroupName',
	        		width : 145,
	        		labelWidth : 70
		    	},{
		    		xtype:'combobox',
				    fieldLabel:'实际出库组',
				    margin:'5 0 0 10',
				    editable: false,
				    name:'actualOutstockGroup',
	        		width : 240,
	        		labelWidth : 90,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 7);
    	                }
    	            },
					queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            emptyText: "--请选择--", 
		            allowBlank : false,
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 10,
		            	 	status: 1
		            	},
		            	url: 'dict/getDictList.action'        	
		            }).load()
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype : 'label',
	        		width : 70,
	        		name : 'displayStatusLabel',
	        		style:'text-align:right;',
	        		margin:'10 0 0 13',
	        		text : '出库状态:'
		    	},{
		    		xtype:'displayfield',
				    name:'displayStatus',
	        		width : 215,
	        		labelWidth : 70
		    	}]
			}]
		};
		return outstockDemand;
	},
	//创建预约入库货物明细
	createGoodsInfo : function(){
		var goodsInfo={
			xtype : 'grid',
			border : false,
			autoScroll : true,
			height : 278,
			columns : this.createColumns(),
			store :  'WMS.store.outstock.OutstockBillItemGoodsViewStr',
			plugins:[
					Ext.create('Ext.grid.plugin.CellEditing', {
						clicksToEdit: 1 //设置单击单元格编辑  
					})  
				]
			};
		return goodsInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
  		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'left'
	      	}),
	      	{ text: '货物号', dataIndex: 'goodsCode', width:100,style :"text-align:center",align:'left'},
		    { text: '品名', dataIndex: 'goodsName', width:110,style :"text-align:center",align:'left'},
		    { text: '生产批号', dataIndex: 'productBatch', width:130, style :"text-align:center", align:'left'},	
      	  	{ text: '计划出库数量', dataIndex: 'actualArrivalQuantity', width:130, style :"text-align:center", align:'right'},
      	  	{ text: '当前可用库存余量', dataIndex: 'stockQuantity', style :"text-align:center", width:120,  align:'right'},
    	  	{ text: '实际出库数量', dataIndex: 'actualOutstockQuantity', width:130, style :"text-align:center", align:'right', field:{
      	  		allowBlank: true,
	      		length:15,
        		vtypeText : '实际出库数量最多可输入15个字符<br>',
    		    vtype: 'currency'
    		}},
    		{ text: '计划出库库区', dataIndex: 'planAreaName', style :"text-align:center", width:120,  align:'left'},
    		{ text: '计划出库库位', dataIndex: 'planLocationNo', style :"text-align:center", width:120,  align:'left'},
    		{ text: '实际出库库区', dataIndex: 'areaName', style :"text-align:center", width:120,  align:'left', field:{
      			xtype:'combobox',
			    queryMode: 'remote',
			    name:'areaCbx',
			    allowBlank:true,
			   // forceSelection:true,//所选择的值限制在下拉框的值中
	            displayField: 'areaName',
	            valueField: 'areaId',
	            editable: true,
				listConfig: {
	            	getInnerTpl: function(displayField) {
	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
	                }
	            },
	            emptyText: "--请选择--", 
	            store: commonStore.load(),
	            listeners:{  //监听事件对下拉选项进行模糊匹配
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
		    },renderer:function(value,metaData,record,rowIndex,colIndex,store){
	         	if(undefined == value || '' == value) {
            		return value;
            	}
            	var index = commonStore.find('areaId', value);
            	if(-1 == index) {
            		return value;
            	}
                var record = commonStore.getAt(index);
                if(undefined == record) {
            		return value;
            	}
            	return record.data.areaName;
	         }},
		    { text: '实际出库库位', dataIndex: 'locationNo', style :"text-align:center", width:120,  align:'left', field:{
      			xtype:'combobox',
			    queryMode: 'remote',
			    name:'locationCbx',
			    allowBlank:true,
			   // forceSelection:true,//所选择的值限制在下拉框的值中
	            displayField: 'locationNo',
	            valueField: 'locationId',
	            editable: true,
				listConfig: {
	            	getInnerTpl: function(displayField) {
	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
	                }
	            },
	            emptyText: "--请选择--", 
	            store: commonStore.load(),
	            listeners:{  //监听事件对下拉选项进行模糊匹配
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
		    },renderer:function(value,metaData,record,rowIndex,colIndex,store){
	         	if(undefined == value || '' == value) {
            		return value;
            	}
            	var index = commonStore.find('locationId', value);
            	if(-1 == index) {
            		return value;
            	}
                var record = commonStore.getAt(index);
                if(undefined == record) {
            		return value;
            	}
            	return record.data.locationNo;
	         }},
	    	{ text: '出库策略', dataIndex: 'outstockTacticsName', width:130, style :"text-align:center", align:'left'},
		    { text: '入库时间', dataIndex: 'instockTime', style :"text-align:center", width:150,  align:'center', field:{
		    	allowBlank:false,
		    	xtype:'combobox',
		    	emptyText:'--请选择--',
		    	editable:false,
		    	name:'instockTime',
		    	displayField: 'instockTime',
	            valueField: 'instockTime',
		    	queryMode: 'remote',
		    	store: commonStore.load()
		    }},
	    	{ text: '单价', dataIndex: 'price', width:80, style :"text-align:center",  align:'left'},
		    { text: '金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'left',
		    renderer:function(value,metaData,record,rowIndex,colIndex,store){
            	var actualOutstockQuantity = (null == record.data.actualOutstockQuantity ? 0 : record.data.actualOutstockQuantity);
      	    	var price =(null == record.data.price ? 0 : record.data.price);
      	    	record.data.totalPrice = (actualOutstockQuantity*10000) * (price*10000)/100000000;
      	        return (actualOutstockQuantity*10000) * (price*10000)/100000000;
        	}},
		    { text: '供应商名称', dataIndex: 'supplierName', width:90, style :"text-align:center",  align:'left'},
		    { text: '下架状态', dataIndex: 'displayStatus', width:90, style :"text-align:center",  align:'left'}
		];
		return columns;		
	}
});
