/**
 * 预约出库信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.define('WMS.view.outstock.OutstockDemandBillEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.outstockdemandbilleditview',
	id : 'outstockdemandbilleditview',
	title : '预约出库信息编辑',
	resizable : false,
	constrainHeader:true,
	width : 870,
	autoHeight : true,
	//height : 550,
	layout : 'fit',
	modal : true,
	requires : [
		'Ext.ux.form.DateTimeField'
	],
	stores:[
	    'WMS.store.outstock.OutstockDemandBillItemGoodsViewStr'
	],
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createOutstockDemand(),
				this.createGoodsInfo()
			]	
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '6',
        	text : '保存',
        	name : 'btn-save',
        	iconCls:'btn-save'
    	},{
    		xtype : 'button',
        	margin : '5',
        	text : '打印',
        	name : 'btn-print'
    	},{
    		xtype : 'button',
        	margin : '6',
        	text : '取消',
        	name : 'btn-cancel',
        	iconCls:'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	},
	//创建预约出库编辑form
	createOutstockDemand : function(){
		var outstockDemand={
			xtype : 'form',
			border : false,
			margin : '10',
			items : [{
			    xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
	        		xtype : 'textfield',
					labelWidth:90,
					width:260,
	        		name : 'demandNo',
	        		allowBlank : false,
	        		maxLength : 100,
	        		fieldLabel : '出库需求号',
	        		readOnly : true,
	        		length:15,
	        		vtypeText : '出库需求号最多可输入15个字符<br>出库需求号不能输入中文',
        		    vtype: 'exceptChinese'
				},{
					xtype : 'datefield',
					labelWidth:70,
					width:240,
	        		name : 'appointmentDate',
	        		allowBlank : false,
	        		maxLength : 100,
	        		fieldLabel : '预约日期',
					format : "Y-m-d",
					length:10,
	        		vtypeText:'预约日期必须早于计划出库时间',
	        		vtype: 'date'
				},{
		    		xtype : 'datetimefield',
					labelWidth:100,
					width:270,
	        		name : 'planArrivalTime',
	        		allowBlank : false,
	        		maxLength : 100,
	        		fieldLabel : '计划出库时间',
					format : "Y-m-d",
					length:19,
					vtype:'datetime',
					compareToDate: true,
					compareTo: 'appointmentDate',
					vtypeText : '计划出库时间必须晚于预约日期'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype:'combo',
				    fieldLabel:'需方商编号',
				    allowBlank : true,
				    name:'demanderCode',
					labelWidth:90,
					emptyText: "--选择或输入--",
					width:260,
					editable: true,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 11);
    	                }
    	            },
					displayField: 'demanderCode',
		            valueField: 'demanderId',
		            store: Ext.create('WMS.store.baseinfo.DemanderViewStr',{
		            	params:{
		            	 	status: 1,
		            	 	demanderId: -1
		            	},
		            	url: 'demander/getDemanderList.action'        	
		            }),
		            listeners:{  //监听事件对下拉选项进行模糊匹配
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
		            				// 如果是字母 true
		            				if (regFile.test(value) == true){
		            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
		            					record.set('code', code);
			            				text = record.get('code');
		            				}
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
		    	},{
		    		xtype:'combo',
				    fieldLabel:'需方商',
				    allowBlank : false,
				    name:'demanderId',
					labelWidth:70,
					emptyText: "--选择或输入--",
					width:240,
					editable: true,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 11);
    	                }
    	            },
					displayField: 'demanderName',
		            valueField: 'demanderId',
		            store: Ext.create('WMS.store.baseinfo.DemanderViewStr',{
		            	params:{
		            	 	status: 1,
		            	 	demanderId: -1
		            	},
		            	url: 'demander/getDemanderList.action'        	
		            }),
		            listeners:{  //监听事件对下拉选项进行模糊匹配
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
		            				// 如果是字母 true
		            				if (regFile.test(value) == true){
		            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
		            					record.set('code', code);
			            				text = record.get('code');
		            				}
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
		    	},{
		    		xtype:'combobox',
				    fieldLabel:'出库性质',
				    name:'outstockNature',
					labelWidth:100,
					width:270,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					allowBlank : false,
					emptyText : '--请选择--',
	        		queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            editable: false,
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 4,
		            	 	status: 1
		            	},
		            	url: 'dict/getDictList.action'        	
		            }).load()
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype : 'textfield',
					labelWidth:90,
					width:260,
	        		name : 'orderNo',
	        		maxLength : 100,
	        		fieldLabel : '订单号'	,
	        		length:20,
	        		vtypeText : '订单号最多可输入20个字符<br>订单号不能输入中文',
        		    vtype: 'exceptChinese'
		    	},{
		    		xtype : 'textfield',
					labelWidth:70,
					width:240,
	        		name : 'itemNo',
	        		maxLength : 100,
	        		fieldLabel : '项号',
	        		length:5,
	        		vtypeText : '项号最多可输入5个字符<br>项号只能输入数字',
        		    vtype: 'currency'
		    	},{
		    		xtype : 'textfield',
					labelWidth:100,
					width:270,
	        		name : 'pickupPerson',
	        		allowBlank : true,
	        		maxLength : 100,
	        		fieldLabel : '提货人'	,
	        		length:20,
	        		vtypeText : '提货人最多可输入20个字符<br>提货人不能输入数字',
        		    vtype: 'exceptNumber'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype : 'textfield',
					labelWidth:90,
					width:260,
	        		name : 'pickupCompany',
	        		allowBlank : true,
	        		maxLength : 100,
	        		fieldLabel : '提货公司',
	        		length:100,
	        		vtypeText : '提货公司最多可输入100个字符',
        		    vtype: 'limitLen'
		    	},{
		    		xtype : 'textfield',
					labelWidth:70,
					width:240,
	        		name : 'vehicleNo',
	        		allowBlank : true,
	        		maxLength : 100,
	        		fieldLabel : '车辆号码',
	        		length:10,
	        		/**
	        		 * @author 李树雪 2015年12月22日 上午17.24
	        		 * @bug 717
	        		 * @code:303-309
	        		 */
	        		vtypeText : '车辆号码格式不对，应该以汉字开头，后面是6位数字或字母。<br><br>如：京A00000',
        		    vtype: 'checkNumber'
		    	},{
		    		xtype : 'label',
			        margin: '10 0 0 15',
	        		width : 80,
	        		text : '货物总数量：'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '6 0 0 0',
			        name: 'totalQuantity',
			        width: 40
				},{
		    		xtype : 'label',
			        margin: '10 0 0 0',
	        		width : 80,
	        		text : '货物总金额：'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '6 0 0 0',
			        name: 'totalPrice',
			        width: 60
				}]
			}]
		};
		return outstockDemand;
	},
	//创建预约出库货物明细
	createGoodsInfo : function(){
		var goodsInfo={
			xtype : 'grid',
			autoScroll : true,
			border : false,
			height : 295,
			columns : this.createColumns(),
			store :  'WMS.store.outstock.OutstockDemandBillItemGoodsViewStr',
			listeners : {
				beforeedit : function(editor, e, eOpts){
					if(this.up('window').oldOutstockDemandBillId!=0 && this.up('window').status){
						var goodsCode = e.record.data.goodsCode;
						e.cancel = (null == goodsCode || "" == goodsCode ? false : true);
					}
				},
				edit:function(editor,e){
					if(1 == e.colIdx){
						var goodsCode = this.down('textfield[name=goodsCode]').getValue();
						ACBEE.Ext.Util.ajaxRequest("goods/searchGoodsByGoodsCode.action",{goodsCode:goodsCode},function(result){
							if(true == result.success ){
								if(result.map.status == 0){//禁用
									ACBEE.Ext.Util.showAlertBox("此货物处于禁用状态，不能被使用!");
									e.record.data.goodsCode = "";
								} else {
									e.record.data.goodsCode = result.map.goodsCode;
									e.record.data.goodsName = result.map.goodsName;
									e.record.data.price = result.map.price;
			                		e.record.data.goodsId = result.map.goodsId;
			                		e.record.data.productBatch = '';
			                		e.record.data.planArrivalQuantity = '';
			                		e.record.data.supplierName = '';
									e.record.data.supplierId = '';
								}
							} else {
								ACBEE.Ext.Util.showAlertBox(result.msg);
								e.record.data.goodsCode = '';
								e.record.data.goodsName = '';
								e.record.data.price = '';
								e.record.data.goodsId = '';
								e.record.data.planArrivalQuantity = '';
								e.record.data.productBatch = '';
								e.record.data.supplierName = '';
								e.record.data.supplierId = '';
							}
							e.record.commit();
						});
					}
				}
			},
			plugins:[
					Ext.create('Ext.grid.plugin.CellEditing', {
						clicksToEdit: 1 //设置单击单元格编辑  
					})  
				],
		 	fbar:[{
		        	xtype : 'button',
		        	margin : '6',
		        	text : '添加',
		        	name : 'btn-add',
		        	iconCls:'btn-add'
	        	},{
		        	xtype : 'button',
		        	margin : '6',
		        	text : '导入',
		        	name : 'btn-import',
		        	iconCls:'btn-import'
	        	},{
		        	xtype : 'button',
		        	margin : '6',
		        	text : '导出',
		        	name : 'btn-export',
		        	iconCls:'btn-export'
	        	},{
		        	xtype : 'button',
		        	margin : '6',
		        	text : '删除',
		        	name : 'btn-delete',
		        	iconCls:'btn-delete'
	        	},'->'
        	]
		};
		return goodsInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
  		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'left'
	      	}),
	      	{text: '货物号', dataIndex: 'goodsCode', width:100,style :"text-align:center",align:'left',field:{
	      		allowBlank: false,
	      		length:20,
        		vtypeText : '货物号最多可输入20个字符<br>货物号不能输入中文',
    		    vtype: 'exceptChinese'
	      	}},
		    { text: '品名', dataIndex: 'goodsName', width:110,style :"text-align:center",align:'left'},
		    { text: '生产批号', dataIndex: 'productBatch', width:130, style :"text-align:center", align:'left'},
		    { text: '计划出库数量', dataIndex: 'planArrivalQuantity', width:130, style :"text-align:center", align:'left',field:{
	      		allowBlank: true,
	      		length:15,
        		vtypeText : '计划出库数量最多可输入15个字符<br>计划出库数量只能输入正整数',
    		    vtype: 'currency'
	      	}},
		    { text: '单价', dataIndex: 'price', width:80, style :"text-align:center",  align:'left'},
		    { text: '金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'left',
		     renderer:function(value,metaData,record,rowIndex,colIndex,store){
            	var planArrivalQuantity = (null == record.data.planArrivalQuantity ? 0 : record.data.planArrivalQuantity);
      	    	var price =(null == record.data.price ? 0 : record.data.price);
      	    	
      	    	record.data.totalPrice = (planArrivalQuantity*10000) * (price*10000)/100000000;
      	        return (planArrivalQuantity*10000) * (price*10000)/100000000;
        	}},
		    { text: '供应商名称', dataIndex: 'supplierName', width:90, style :"text-align:center",  align:'left'}
		];
		return columns;		
	}
});
