/**
 * 预约出库信息管理view.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.define('WMS.view.outstock.OutstockDemandBillSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.outstockdemandbillsearchview',
	id: 'outstockdemandbillsearchview',
	resizable : false,
	multiSelect : true,
	loadMask : true,
	layout:'fit',
	requires : [
		'Ext.ux.form.DateTimeField'
	],
	models : [
		'WMS.model.outstock.OutstockDemandBillGridMdl'
	],
	stores : [
		'WMS.store.outstock.OutstockDemandBillViewStr'
	],
	 
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'form',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
				    xtype:'textfield',
					fieldLabel:'出库需求号',
					name:'demandNo',
					labelWidth:90,
					width:250,
					length : 15,
	        		vtypeText : '出库需求号最多可输入15个字符',
        		    vtype: 'exceptChinese'
				},{
			        xtype:'datefield',
					fieldLabel:'预约开始日期',
					name:'outstockBillBeginDate',
					labelWidth:120,
					width:280,
					format : "Y-m-d",
					length:10,
	        		vtypeText:'预约开始日期必须早于预约结束日期',
	        		vtype: 'date'
		  		},{
			        xtype:'datefield',
					fieldLabel:'预约结束日期',
					name:'outstockBillEndDate',
					labelWidth:120,
					width:280,
					format : "Y-m-d",
					length:10,
	        		vtypeText:'预约结束日期必须晚于预约开始日期',
	        		vtype: 'date',
	        		compareTo:'outstockBillBeginDate'
		    	}]	
			},{
				xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 70,
	        	 	margin: 6
				},
				items:[{
			    	xtype:'textfield',
					fieldLabel:'订单号',
					name:'orderNo',
					labelWidth:90,
					width:250,
					length:20,
	        		vtypeText : '订单号最多可输入20个字符<br>订单号不能输入中文',
        		    vtype: 'exceptChinese'
		   		},{
			        xtype:'datetimefield',
					fieldLabel:'计划出库开始时间',
					name:'planOutstockBillBeginDate',
					labelWidth:120,
					width:280,
					format : "Y-m-d",
					length:19,
					vtype:'datetime',
					vtypeText : '计划出库开始时间必须早于计划出库结束时间'
		  		},{
			        xtype:'datetimefield',
					fieldLabel:'计划出库结束时间',
					name:'planOutstockBillEndDate',
					labelWidth:120,
					width:280,
					format : "Y-m-d",
					vtype:'datetime',
					length:19,
					compareTo:'planOutstockBillBeginDate',
					vtypeText : '计划出库结束时间必须晚于计划出库开始时间。'
		    	}]
		   	},{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					xtype:'combo',
				    fieldLabel:'需方商',
				    // allowBlank:false,
				    name:'demanderId',
					labelWidth:90,
					emptyText: "--选择或输入--",
					width:250,
					editable: true,
					forceSelection:true,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 11);
    	                }
    	            },
					displayField: 'demanderName',
		            valueField: 'demanderId',
		            store: Ext.create('WMS.store.baseinfo.DemanderViewStr',{
		            	params:{
		            	 	status: 1,
		            	 	demanderId: -1
		            	},
		            	url: 'demander/getDemanderList.action'        	
		            }),
		            listeners:{  //监听事件对下拉选项进行模糊匹配
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
		            				// 如果是字母 true
		            				if (regFile.test(value) == true){
		            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
		            					record.set('code', code);
			            				text = record.get('code');
		            				}
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
		   		},{
				    xtype:'combobox',
				    fieldLabel:'分配状态',
				    editable: false,
				    name:'status',
					labelWidth:120,
					width:280,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.AssignStatusStr'),
		            value: '-1'
				},{
					border:false
				},{
		    		border:false
		    	},{
		    		xtype:'checkbox',
		    		boxLabel:'<span>显示禁用项</span><img data-qtip="选中时显示所有查询条件（下拉框项）中已禁用的项，<br/>查询结果中包含已禁用项的结果；未选中时不显示" src="images/hint.png" class="hintico">',
		    		name: 'showForbidden',
		    		checked: true
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'查询',
			    	name:'btn-search',
			    	iconCls:'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'重置',
			    	name:'btn-clear',
			    	iconCls:'btn-clear'
	   			}]	
			}]
		};
		
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 60,
			 	margin: 6
			},
			items:[{
				xtype : 'button',
				text : '编制',
				name : 'btn-drawUp',
				iconCls:'btn-drawUp'
			},{
				xtype : 'button',
				text : '删除',
				name : 'btn-delete',
				iconCls:'btn-delete'
			}]
	    };
		
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列   bug:632 将序号从40改为60 彭婷婷
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:left", align:'center'
	      	}),
	      	{ text: '出库需求号', dataIndex: 'demandNo', width:140,style :"text-align:center",align:'left'},
		    { text: '预约日期', dataIndex: 'appointmentDate', width:100,style :"text-align:center",align:'center'},
		    { text: '计划出库时间', dataIndex: 'planArrivalTime', style :"text-align:center", width:140,  align:'center'},
		    { text: '需方商编码', dataIndex: 'demanderCode', width:160, style :"text-align:center", align:'left'},
		    { text: '需方商', dataIndex: 'demanderName', width:160, style :"text-align:center", align:'left'},
		    { text: '订单号', dataIndex: 'orderNo', width:120, style :"text-align:center", align:'left'},
		    { text: '项号', dataIndex: 'itemNo', width:120, style :"text-align:center", align:'left'},
		    { text: '提货公司', dataIndex: 'pickupCompany', width:160, style :"text-align:center",  align:'left'},
		    { text: '车辆号码', dataIndex: 'vehicleNo', width:90, style :"text-align:center",  align:'left'},
		    { text: '提货人', dataIndex: 'pickupPerson', width:90, style :"text-align:center",  align:'left'},
		    { text: '出库性质', dataIndex: 'outstockNatureName', width:120, style :"text-align:center",  align:'left'},
		    { text: '货物总数量', dataIndex: 'totalQuantity', width:100, style :"text-align:center",  align:'left'},
		    { text: '货物总金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'left'},
		    { text: '状态', dataIndex: 'displayStatus', width:80, style :"text-align:center",  align:'center'},
		    ACBEE.Ext.Util.createEditBtn(this.functionCodes)
		];
			return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的预约出库信息！',
			store: Ext.create('WMS.store.outstock.OutstockDemandBillViewStr'),
			/********
			 * 2015/12/26
			 * 王玉涛
			 * bug745
			 */
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
	listeners:{
		//panel显示事件
		afterrender:function(view,eOpts){
			//绑定分页栏的store为grid的store
			view.down('pagingtoolbar').bindStore(view.getStore());
			
		}
	}
});
