/**
 * 出库任务分配信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2015-07-21
 */
Ext.onReady(function(){
	outstockStore = Ext.create('WMS.store.common.OutstockWayStr');
});

Ext.define('WMS.view.outstock.OutstockTaskEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.outstocktaskeditview',
	title : '出库任务分配信息编辑',
	resizable : false,
	constrainHeader:true,
	autoHeight : true,
	width : 860,
	//height : 520,
	layout : 'fit',
	modal : true,
	stores:[
	    'WMS.store.outstock.OutstockDemandBillItemGoodsViewStr'
	],
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createOutstockDemand(),
				this.createGoodsInfo()
			]	
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '6',
        	text : '保存',
        	name : 'btn-save',
        	iconCls:'btn-save'
    	},{
    		xtype : 'button',
        	margin : '5',
        	text : '打印',
        	name : 'btn-print'
    	},{
    		xtype : 'button',
        	margin : '6',
        	text : '取消',
        	name : 'btn-cancel',
        	iconCls:'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	},
	//创建预约出库编辑form
	createOutstockDemand : function(){
		var outstockDemand={
			xtype : 'form',
			border : false,
			margin : '10',
			items : [{
			    xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 13',
			        name: 'demandNoLabel',
			        width:70,
	        		style: 'text-align: right;',
	        		text : '出库需求号:'
				},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'demandNo',
			        width:145
				},{
					xtype : 'label',
					margin:'10 0 0 85',
					width:70,
	        		name : 'appointmentDateLabel',
	        		style: 'text-align: right;',
	        		text : '预约日期:'
				},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'appointmentDate',
			        width:145
				},{
		    		xtype : 'label',
					width:90,
	        		name : 'planArrivalTimeLabel',
	        		style: 'text-align: right;',
	        		text : '计划出库时间:',
	        		margin:'10 0 0 10'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'planArrivalTime',
			        width:145
				}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype:'label',
				    text:'需方商:',
				    name:'demanderIdLabel',
	        		style: 'text-align: right;',
				    margin:'10 0 0 13',
					width:70
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'demanderName',
			        width:200
				},{
		    		xtype:'label',
				    text:'提货人:',
				    name:'outstockNatureLabel',
	        		style: 'text-align: right;',
				    margin:'10 0 0 30',
					width:70
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'pickupPerson',
			        width:145
				},{
		    		xtype : 'label',
					width:90,
	        		name : 'deliverymanLabel',
	        		style: 'text-align: right;',
	        		margin:'10 0 0 10',
	        		text : '提货公司:'	
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'pickupCompany',
			        width:145
				}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype : 'label',
					width:70,
	        		name : 'orderNoLable',
	        		margin:'10 0 0 13',
	        		style: 'text-align: right;',
	        		text : '订单号:'	
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'orderNo',
			        width:145
				},{
		    		xtype : 'label',
					width:70,
	        		name : 'itemNo',
	        		style: 'text-align: right;',
	        		margin:'10 0 0 85',
	        		text : '项号:'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'itemNo',
			        width:145
				},{
		    		xtype : 'label',
					width:90,
	        		style: 'text-align: right;',
	        		margin:'10 0 0 10',
	        		name : 'vehicleNoLabel',
	        		text : '车辆号码:'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'vehicleNo',
			        width:145
				}]
			},{
				xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '6'
		    	},
		    	items : [{
		    		xtype:'label',
				    text:'出库性质:',
	        		style: 'text-align: right;',
	        		margin:'5 0 0 13',
				    name:'entryLabel',
					width:70
		    	},{
		    		xtype: 'displayfield',
		    		margin: '0 0 0 5',
			        name: 'outstockNatureName',
			        width:145
				},{
		    		xtype:'combobox',
				    fieldLabel:'出库组',
				    margin:' 10 0 75 10',
				    editable: false,
				    allowBlank : false,
				    name:'outstockGroup',
					labelWidth:80,
					width:225,
					queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            emptyText: "--请选择--", 
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 10,
		            	 	status: 1
		            	},
		            	url: 'dict/getDictList.action'        	
		            }).load()
		    	}]
			}]
		};
		return outstockDemand;
	},
	//创建预约出库货物明细
	createGoodsInfo : function(){
		var goodsInfo={
			xtype : 'grid',
			border : false,
			autoScroll : true,
			height : 285,
			columns : this.createColumns(),
			store :  'WMS.store.outstock.OutstockDemandBillItemGoodsViewStr',
			plugins:[
					Ext.create('Ext.grid.plugin.CellEditing', {
						clicksToEdit: 1 //设置单击单元格编辑  
					})  
				],
			listeners : {
				beforeedit : function(editor, e, eOpts){
					if(this.up('window').oldOutstockDemandBillId!=0 && this.up('window').outstockStatus){
						var goodsCode = e.record.data.goodsCode;
						e.cancel = (null == goodsCode || "" == goodsCode ? false : true);
					}
				}
			}
		};
		
		return goodsInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
  		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'center'
	      	}),
	      	{ text: '货物号', dataIndex: 'goodsCode', width:110,style :"text-align:center",align:'left'},
		    { text: '品名', dataIndex: 'goodsName', width:130,style :"text-align:center",align:'left'},
		    { text: '生产批号', dataIndex: 'productBatch', width:130, style :"text-align:center", align:'left'},
      	  	{ text: '预约出库数量', dataIndex: 'planArrivalQuantity', width:100, style :"text-align:center", align:'right'},
      	  	{ text: '总出库数量', dataIndex: 'actualOutstockTotalQuantity', width:100, style :"text-align:center", align:'right',field:{
	      		allowBlank: true,
	      		length:15,
        		vtypeText : '出库数量最多可输入15个字符<br>出库数量只能输入正整数',
    		    vtype: 'currency'
	      	}},
      	  	{ text: '出库策略', dataIndex: 'outstockTactics', width:100, style :"text-align:center", align:'left',field:{
	      		xtype : 'combobox',
      	    	editable: false,
				displayField: 'name',
	            valueField: 'value',
	            emptyText: "--请选择--",
	            forceSelection: true,//所选择的值限制在下拉框的值中
	            allowBlank : false,
            	store: outstockStore
	      	},renderer:function(value,metaData,record,rowIndex,colIndex,store){
	         	if(undefined == value || '' == value) {
            		return value;
            	}
            	var index = outstockStore.find('value', value);
            	if(-1 == index) {
            		return value;
            	}
                var record = outstockStore.getAt(index);
                if(undefined == record) {
            		return value;
            	}
            	return record.data.name;
	         }},
		    { text: '单价', dataIndex: 'price', width:100, style :"text-align:center",  align:'right'},
		    { text: '金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'right',
		     renderer:function(value,metaData,record,rowIndex,colIndex,store){
            	var actualOutstockTotalQuantity = (null == record.data.actualOutstockTotalQuantity ? 0 : record.data.actualOutstockTotalQuantity);
      	    	var price =(null == record.data.price ? 0 : record.data.price);
      	    	
      	    	record.data.totalPrice = (actualOutstockTotalQuantity*10000) * (price*10000)/100000000;
      	        return (actualOutstockTotalQuantity*10000) * (price*10000)/100000000;
      	        }
		    },
		    //{text: '计划出库库位', dataIndex: 'locationNo', width: 130, style: "text-align:center", align:'left'},
		    //{text: '货物入库时间', dataIndex: 'instockTime', width: 140, style: "text-align:center", align:'center',hidden:false},
		    { text: '供应商名称', dataIndex: 'supplierName', width:110, style :"text-align:center",  align:'left'}
		];
		return columns;		
	}
});
