/*
 * 期初期末库存报表信息
 */

Ext.define('WMS.view.report.FutureInventoryEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.futureinventoryeditview',
	title : '期初期末库存报表信息',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	autoHeight : true,
	width : 850,
	//height : 580,
	layout : 'fit',
	modal : true,
	requires : [
		'WMS.store.report.FutureInventoryViewStr'
	],
	
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createInstockDemand(),
				this.createOpeningEndingInfo()
			]	
		}];
		this.callParent(arguments);
	},
	
	//创建预约入库编辑form
	createInstockDemand : function(){
		var instockDemand={
			xtype : 'form',
			border : false,
			margin : '1',
			items : [{
			    xtype : 'panel',
		        layout :'column',
		        bodyStyle:'background:#E8E8E8;',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 80,
		        	margin : '5'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 5',
			        name: 'goodsCodeLabel',
			        width:70,
	        		text : '货物编号:',
	        		style: 'text-align: right;'
				},{
		    		xtype: 'displayfield',
		    		margin: '7 0 0 5',
			        name: 'goodsCode',
			        width:145
				},{
		    		xtype: 'label',
			        margin: '10 0 0 5',
			        name: 'goodsNameLabel',
			        width:70,
	        		text : '货物名称:',
	        		style: 'text-align: right;'
				},{
					xtype : 'displayfield',
	        		width : 145,
	        		name : 'goodsName',
	        		margin: '7 0 0 5'
				},{
					xtype : 'label',
	        		width : 100,
	        		name : 'supplierNameLabel',
	        		margin: '10 0 0 10',
	        		text : '供应商:',
	        		style: 'text-align: right;'
				},{
		    		xtype : 'displayfield',
	        		width : 145,
	        		name : 'supplierName',
	        		margin: '7 0 0 5'
		    	}]
			},{
				xtype : 'panel',
		        layout :'column',
		        bodyStyle:'background:#E8E8E8;',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '2'
		    	},
		    	items : [{
		    		xtype: 'label',
			        margin: '10 0 0 5',
			        name: 'areaNameLabel',
			        width:70,
	        		text : '库区:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '7 0 0 5',
				    name:'areaName',
	        		width : 200
		    	},{
		    		xtype: 'label',
			        margin: '10 0 0 -50',
			        name: 'locationNoLabel',
			        width:70,
	        		text : '库位:',
	        		style: 'text-align: right;'
				},{
		    		xtype:'displayfield',
				    margin: '7 0 0 5',
				    name:'locationNo',
	        		width : 145
		    	},{
		    		xtype: 'label',
			        margin: '10 0 0 10',
			        name: 'natureNameLabel',
			        width:100,
	        		text : '库位性质:',
	        		style: 'text-align: right;'
				},{
		    		xtype : 'displayfield',
	        		width : 145,
	        		name : 'natureName',
	        		margin: '7 0 0 5'
		    	}]
			}]
		};
		return instockDemand;
	},
	//创建期初期末库存明细
	createOpeningEndingInfo : function(){
		var goodsInfo={
				xtype : 'grid',
				//width : 860,
				autoScroll : true,
				border : false,
				height : 450,
				store : 'WMS.store.report.FutureInventoryEditViewStr',
				columns : this.createColumns()
		};
		return goodsInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:left", align:'center'
	      	}),

		    { text: '供应商', dataIndex: 'supplierName', width:130,style :"text-align:center",align:'left'},
		    { text: '需求方', dataIndex: 'demanderName', style :"text-align:center", width:130,  align:'left'},
		    { text: '需求号', dataIndex: 'demandNo', width:130, style :"text-align:center", align:'left'},
		    { text: '货物号', dataIndex: 'goodsCode', width:130, style :"text-align:center", align:'left'},
		    { text: '品名', dataIndex: 'goodsName', width:130, style :"text-align:center", align:'left'},
		    { text: '生产批号', dataIndex: 'productBatch', width:130, style :"text-align:center",  align:'left'},
		    { text: '数量', dataIndex: 'quantity', width:130, style :"text-align:center",  align:'center'},
		    { text: '库区名称', dataIndex: 'areaName', width:130, style :"text-align:center",  align:'left'},
		    { text: '库区性质', dataIndex: 'displayAreaNature', width:130, style :"text-align:center",  align:'center'},
		    { text: '库位号', dataIndex: 'displayLocationNo', width:130, style :"text-align:center",  align:'left'},
		    { text: '操作类型', dataIndex: 'displayOperType', width:130, style :"text-align:center",  align:'center'},
		    { text: '操作时间', dataIndex: 'operTime', width:150, style :"text-align:center",  align:'center'},
		    { text: '操作原因', dataIndex: 'causeName', width:130, style :"text-align:center",  align:'left'},
		    { text: '车辆号码', dataIndex: 'vehicleNo', width:130, style :"text-align:center", align:'left'},
		    { text: '送货人', dataIndex: 'deliveryman', width:130, style :"text-align:center", align:'left'},
		    { text: '送货公司', dataIndex: 'deliveryCompany', width:130, style :"text-align:center", align:'left'},
		    { text: '操作员', dataIndex:'staffName', width:130,style:"text-align:center", align:'left'}
		];
		return columns;		
	}
});