/**
 * 期初期末报表管理view.
 * @author 高元称
 * @version 1.0.0, 2015-07-21
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.define('WMS.view.report.FutureInventorySearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.futureinventorysearchview',
	resizable : false,
	multiSelect : true,
	closeAction : 'hide',
	loadMask : true,
	layout:'fit',
	requires : [
		'WMS.store.report.FutureInventoryViewStr',
		'Ext.ux.form.DateTimeField'
	],
	models : [
		'WMS.model.report.FutureInventoryViewMdl'
	],
	stores : [
		'WMS.store.report.FutureInventoryViewStr'
	],
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
		   			xtype:'datefield',
					fieldLabel:'开始日期',
					name:'beginDate',
					labelWidth:70,
					width:230,
					format : "Y-m-d",
					length:19,
	        		vtypeText:'开始日期必须早于结束日期',
					vtype:'date'
		  		},{
			        xtype:'datefield',
					fieldLabel:'结束日期',
					name:'endDate',
					labelWidth:70,
					width:230,
					format : "Y-m-d",
					vtype:'date',
					length:19,
					compareTo:'beginDate',
					vtypeText : '结束日期必须晚于开始日期。'
		    	},{
			        xtype:'combobox',
					fieldLabel:'供应商',
					name:'supplierName',
					labelWidth:70,
					width:230,
					emptyText: "--选择或输入--",
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					editable: true,
					queryMode: 'remote',
		            displayField: 'supplierName',
		            valueField: 'supplierId',
		           // value:-1,
		            store: Ext.create('WMS.store.baseinfo.SupplierViewStr',{
		            	params:{
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'supplier/getSupplierList.action'        	
		            }),
		            //监听事件对下拉选项进行模糊匹配
		            listeners:{
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
		            				// 如果是字母 true
		            				if (regFile.test(value) == true){
		            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
		            					record.set('code', code);
			            				text = record.get('code');
		            				}
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
		   		}]	
			},{
				xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 70,
	        	 	margin: 6
				},
				items:[{
					xtype:'combobox',
					fieldLabel:'库区名称',
					name:'areaName',
					labelWidth:70,
					width:230,
					emptyText: "--选择或输入--",
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
    	            //监听事件对下拉选项进行模糊匹配
		            listeners:{
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
		            				// 如果是字母 true
		            				if (regFile.test(value) == true){
		            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
		            					record.set('code', code);
			            				text = record.get('code');
		            				}
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            },
					editable: true,
					queryMode: 'remote',
		            displayField: 'areaName',
		            valueField: 'areaId',
		            //value:-1,
		            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
		            	params:{
		            	 	areaNature: -1,
		            	 	status : -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'warehouseArea/getWarehouseAreaList.action'        	
		            })
				},{
					xtype:'combobox',
					fieldLabel:'库位',
					name:'locationNo',
					labelWidth:70,
					width:230,
					emptyText: "--选择或输入--",
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
    	          //监听事件对下拉选项进行模糊匹配
		            listeners:{
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
		            				// 如果是字母 true
		            				if (regFile.test(value) == true){
		            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
		            					record.set('code', code);
			            				text = record.get('code');
		            				}
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            },
					editable: true,
					queryMode: 'remote',
		            displayField: 'locationNo',
		            valueField: 'locationId',
		            //value:-1,
		            store: Ext.create('WMS.store.baseinfo.WarehouseLocationStr',{
		            	params:{
		            	 	areaId: -1,
		            	 	areaNature:-1,
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'warehouseLocation/getWarehouseLocationViewList.action'        	
		            })
				},{
					xtype:'combobox',
					fieldLabel:'库位性质',
					name:'natureId',
					labelWidth:70,
					width:230,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					editable: false,
					queryMode: 'remote',
		            displayField: 'natureName',
		            valueField: 'natureId',
		            value:-1,
		            store: Ext.create('WMS.store.common.LocationNatureNameStr',{
		            	params:{
		            	 	status: -1,
		            	 	areaId:-1
		            	},
                    	hasEmptyItem: true,
		            	url: 'locationNature/getLocationNatureList.action'        	
		            })
				}]
		   	},{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					xtype:'combobox',
					fieldLabel:'货物编号',
					name:'goodsCode',
					labelWidth:70,
					width:230,
					emptyText: "--选择或输入--",
					queryMode: 'remote',
		            displayField: 'goodsCode',
		            valueField: 'goodsId',
		            //value:-1,
		          //监听事件对下拉选项进行模糊匹配
		            listeners:{
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
		            				// 如果是字母 true
		            				if (regFile.test(value) == true){
		            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
		            					record.set('code', code);
			            				text = record.get('code');
		            				}
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            },
					editable: true,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
		            store: Ext.create('WMS.store.baseinfo.GoodsStr',{
		            	params:{
		            	 	supplierId: -1,
		            	 	goodsId: -1,
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'goods/getGoodsList.action'        	
		            })
				},{
					xtype:'combobox',
					fieldLabel:'货物名称',
					name:'goodsName',
					labelWidth:70,
					width:230,
					editable: false,
					queryMode: 'remote',
		            displayField: 'goodsName',
		            valueField: 'goodsId',
		            value:-1,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
		            store: Ext.create('WMS.store.baseinfo.GoodsStr',{
		            	params:{
		            		supplierId: -1,
		            	 	goodsId: -1,
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'goods/getGoodsList.action'        	
		            })
				},{
		    		border:false,
		    		width:15
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'查询',
			    	name:'btn-search',
			    	iconCls: 'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'重置',
			    	name:'btn-clear',
			    	iconCls: 'btn-clear'
	   			},
//	   			{  //该功能还未实现
//			    	xtype:'button',
//			    	width: 60,
//			    	text:'统计',
//			    	name:'btn-total'
//	   			}
	   			]	
			}]
		};
		
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 60,
			 	margin: 6
			},
			items:[{
				xtype : 'button',
				text : '导出',
				name : 'btn-export',
				iconCls: 'btn-export'
			}]
	    };
		
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列   bug:632 将序号宽度从40改为60  彭婷婷
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:center", align:'center'
	      	}),
	      	{ text: '货物编号', dataIndex: 'goodsCode', width:140,style :"text-align:center",align:'left'},
		    { text: '货物名称', dataIndex: 'goodsName', width:90,style :"text-align:center",align:'center'},
		    { text: '供应商', dataIndex: 'supplierName', style :"text-align:center", width:140,  align:'center'},
		    { text: '库区', dataIndex: 'areaName', style :"text-align:center", width:140,  align:'center'},
		    { text: '库位', dataIndex: 'locationNo', width:160, style :"text-align:center", align:'left'},
		    { text: '库位性质', dataIndex: 'natureName', width:100, style :"text-align:center", align:'left'},
		    { text: '期初库存', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'beginQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'beginTotalPrice', width:100, style :"text-align:center",  align:'left'},
						    { text: '体积', dataIndex: 'beginVolume', width:100, style :"text-align:center",  align:'left'},
						    { text: '重量', dataIndex: 'beginWeight', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '本期入库', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'inQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'inTotalPrice', width:100, style :"text-align:center",  align:'left'},
						    { text: '体积', dataIndex: 'inVolume', width:100, style :"text-align:center",  align:'left'},
						    { text: '重量', dataIndex: 'inWeight', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '本期调拨入库', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'transferInQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'transferInTotalPrice', width:100, style :"text-align:center",  align:'left'},
						    { text: '体积', dataIndex: 'transferInVolume', width:100, style :"text-align:center",  align:'left'},
						    { text: '重量', dataIndex: 'transferInWeight', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '本期出库', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'outQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'outTotalPrice', width:100, style :"text-align:center",  align:'left'},
						    { text: '体积', dataIndex: 'outVolume', width:100, style :"text-align:center",  align:'left'},
						    { text: '重量', dataIndex: 'outWeight', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '本期调拨出库', 
		    	columns : [
		    	           	{ text: '数量', dataIndex: 'transferOutQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'transferOutTotalPrice', width:100, style :"text-align:center",  align:'left'},
						    { text: '体积', dataIndex: 'transferOutVolume', width:100, style :"text-align:center",  align:'left'},
						    { text: '重量', dataIndex: 'transferOutWeight', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '本期退库', 
		    	columns : [
		    	           	{ text: '数量', dataIndex: 'cancelQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'cancelTotalPrice', width:100, style :"text-align:center",  align:'left'},
						    { text: '体积', dataIndex: 'cancelVolume', width:100, style :"text-align:center",  align:'left'},
						    { text: '重量', dataIndex: 'cancelWeight', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '期末库存', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'endQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'endTotalPrice', width:100, style :"text-align:center",  align:'left'},
						    { text: '体积', dataIndex: 'endVolume', width:100, style :"text-align:center",  align:'left'},
						    { text: '重量', dataIndex: 'endWeight', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的期初期末信息！',
			store : Ext.create('WMS.store.report.FutureInventoryViewStr'),
			tbar: this.createTBar(),
			columns: this.createColumns()/*,
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }*/
		});
		this.callParent(arguments);
	}/*,
	listeners:{
		//panel显示事件
		afterrender:function(view,eOpts){
			//绑定分页栏的store为grid的store
			view.down('pagingtoolbar').bindStore(view.getStore());
		}
	}*/
});
