/**
 * 库龄报表管理view.
 * @author 杨志文
 * @version 1.0.0, 2015-12-21
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.define('WMS.view.report.LibraryAgeReportView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.libraryagereportview',
	resizable : false,
	multiSelect : true,
	closeAction : 'hide',
	loadMask : true,
	layout:'fit',
	requires : [
		'WMS.store.report.LibraryAgeReportViewStr'
	],
	models : [
		'WMS.model.report.LibraryAgeReportViewMdl'
	],
	stores : [
		'WMS.store.report.LibraryAgeReportViewStr'
	],
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
			        xtype:'combobox',
					fieldLabel:'供应商',
					name:'supplierName',
					labelWidth:70,
					width:230,
					emptyText: "--选择或输入--",
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					editable: true,
					queryMode: 'remote',
		            displayField: 'supplierName',
		            valueField: 'supplierId',
		           // value:-1,
		            store: Ext.create('WMS.store.baseinfo.SupplierViewStr',{
		            	params:{
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'supplier/getSupplierList.action'        	
		            }),
		            //监听事件对下拉选项进行模糊匹配
		            listeners:{
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
		            				// 如果是字母 true
		            				if (regFile.test(value) == true){
		            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
		            					record.set('code', code);
			            				text = record.get('code');
		            				}
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
		   		},{
					xtype:'combobox',
					fieldLabel:'货物编号',
					name:'goodsCode',
					labelWidth:70,
					width:230,
					editable: false,
					queryMode: 'remote',
		            displayField: 'goodsCode',
		            valueField: 'goodsId',
		            value:-1,
		            store: Ext.create('WMS.store.baseinfo.GoodsStr',{
		            	params:{
		            	 	supplierId: -1,
		            	 	goodsId: -1,
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'goods/getGoodsList.action'        	
		            })
				},{
					xtype:'combobox',
					fieldLabel:'货物名称',
					name:'goodsName',
					labelWidth:70,
					width:230,
					editable: false,
					queryMode: 'remote',
		            displayField: 'goodsName',
		            valueField: 'goodsId',
		            value:-1,
		            store: Ext.create('WMS.store.baseinfo.GoodsStr',{
		            	params:{
		            		supplierId: -1,
		            	 	goodsId: -1,
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'goods/getGoodsList.action'        	
		            })
				}]	
			},{
				xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 70,
	        	 	margin: 6
				},
				items:[{
					xtype:'combobox',
					fieldLabel:'库区名称',
					name:'areaName',
					labelWidth:70,
					width:230,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					editable: false,
					queryMode: 'remote',
		            displayField: 'areaName',
		            valueField: 'areaId',
		            value:-1,
		            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
		            	params:{
		            	 	areaNature: -1,
		            	 	status : -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'warehouseArea/getWarehouseAreaList.action'        	
		            })
				},{
					xtype:'combobox',
					fieldLabel:'库位',
					name:'locationNo',
					labelWidth:70,
					width:230,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					editable: false,
					queryMode: 'remote',
		            displayField: 'locationNo',
		            valueField: 'locationId',
		            value:-1,
		            store: Ext.create('WMS.store.baseinfo.WarehouseLocationStr',{
		            	params:{
		            	 	areaId: -1,
		            	 	areaNature:-1,
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'warehouseLocation/getWarehouseLocationViewList.action'        	
		            })
				},{
					xtype:'combobox',
					fieldLabel:'库位性质',
					name:'natureId',
					labelWidth:70,
					width:230,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					editable: false,
					queryMode: 'remote',
		            displayField: 'natureName',
		            valueField: 'natureId',
		            value:-1,
		            store: Ext.create('WMS.store.common.LocationNatureNameStr',{
		            	params:{
		            	 	status: -1,
		            	 	areaId:-1
		            	},
                    	hasEmptyItem: true,
		            	url: 'locationNature/getLocationNatureList.action'        	
		            })
				}]
		   	},{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
		    		border:false,
		    		width:15
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'查询',
			    	name:'btn-search',
			    	iconCls: 'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'重置',
			    	name:'btn-clear',
			    	iconCls: 'btn-clear'
	   			}]	
			}]
		};
		
		return scPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel()
			]
		};
	},
	//创建表格列
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:center", align:'center'
	      	}),
	      	{ text: '货物编号', dataIndex: 'goodsCode', width:140,style :"text-align:center",align:'left'},
		    { text: '货物名称', dataIndex: 'goodsName', width:90,style :"text-align:center",align:'center'},
		    { text: '供应商', dataIndex: 'supplierName', style :"text-align:center", width:140,  align:'center'},
		    { text: '规格', dataIndex: 'specs', style :"text-align:center", width:140,  align:'center'},
		    { text: '单位', dataIndex: 'unit', width:160, style :"text-align:center", align:'left'},
		    { text: '库存性质', dataIndex: 'stocknature', width:100, style :"text-align:center", align:'left'},
		    { text: '1天-10天', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'Quantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'TotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '10天-20天', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'Quantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'TotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '20天-30天', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'Quantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'TotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
//		    { text: '一个月', 
//		    	columns : [
//		    	            { text: '数量', dataIndex: 'Quantity', width:100, style :"text-align:center", align:'left'},
//						    { text: '金额', dataIndex: 'TotalPrice', width:100, style :"text-align:center",  align:'left'}
//		    	           ]
//		    },
		    { text: '30天-40天', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'Quantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'TotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '40天-50天', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'endQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'endTotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '50天-60天', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'Quantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'TotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
//		    { text: '两个月', 
//		    	columns : [
//		    	            { text: '数量', dataIndex: 'Quantity', width:100, style :"text-align:center", align:'left'},
//						    { text: '金额', dataIndex: 'TotalPrice', width:100, style :"text-align:center",  align:'left'}
//		    	           ]
//		    },
		    { text: '60天-70天', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'endQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'endTotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '70天-80天', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'endQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'endTotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '80天-90天', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'endQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'endTotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
//		    { text: '三个月', 
//		    	columns : [
//		    	            { text: '数量', dataIndex: 'endQuantity', width:100, style :"text-align:center", align:'left'},
//						    { text: '金额', dataIndex: 'endTotalPrice', width:100, style :"text-align:center",  align:'left'}
//		    	           ]
//		    },
		    { text: '四个月', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'endQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'endTotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '五个月', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'endQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'endTotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '六个月', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'endQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'endTotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    },
		    { text: '六个月以上', 
		    	columns : [
		    	            { text: '数量', dataIndex: 'endQuantity', width:100, style :"text-align:center", align:'left'},
						    { text: '金额', dataIndex: 'endTotalPrice', width:100, style :"text-align:center",  align:'left'}
		    	           ]
		    }
		];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的库存报表信息！',
			store : Ext.create('WMS.store.report.LibraryAgeReportViewStr'),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	}
});
