/**
 * 操作流水信息编辑view.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-20
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.define('WMS.view.stock.OperFlowSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.operflowsearchview',
	id: 'operflowsearchview',
	resizable : false,
	closeAction : 'hide',
	multiSelect : true,
	loadMask : true,
	layout:'fit',
	requires:[
	    'WMS.store.common.AreaNatureStr',
	    'WMS.store.common.OperTypeStr',
	    'WMS.store.stock.OperFlowViewStr',
	    'Ext.ux.form.DateTimeField'
	],
	stores:[
	    'WMS.store.stock.OperFlowViewStr'
	],
	models:[
	    'WMS.model.stock.OperFlowViewMdl'
	],
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'form',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
			    	xtype:'textfield',
					fieldLabel:'货物号',
					margin: '10 0 0 10',
					name:'goodsCode',
					labelWidth:90,
					width:250,
	        		length: 15,
	        		vtype:'exceptChinese',
	        		vtypeText : '货物号不可以输入汉字，并且最多可输入15个字符'
		   		},{
		   			xtype:'datetimefield',
					fieldLabel:'操作开始时间',
					name:'beginDateTime',
					labelWidth:100,
					width:260,
					format : "Y-m-d",
					length:19,
	        		vtypeText:'操作开始时间必须早于操作结束时间',
					vtype:'datetime'
		  		},{
			        xtype:'datetimefield',
					fieldLabel:'操作结束时间',
					name:'endDateTime',
					labelWidth:100,
					width:260,
					format : "Y-m-d",
					vtype:'datetime',
					length:19,
					compareTo:'beginDateTime',
					vtypeText : '操作结束时间必须晚于操作开始时间。'
		    	},]
			},{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
					labelAlign : 'right',
					labelWidth : 70,
					margin : 6
				},
				items:[{
				    xtype:'combobox',
					fieldLabel:'库区性质',
					margin: '10 0 0 10',
					name:'areaNature',
					labelWidth:90,
					width:250,
					editable: false,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.AreaNatureStr'),
		            value: '-1'
				},{
					xtype:'combobox',
					fieldLabel:'库区名称',
					name:'areaName',
					id:'areaName',
					labelWidth:100,
					width:260,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					editable: false,
					queryMode: 'remote',
		            displayField: 'areaName',
		            valueField: 'areaId',
		            value:-1,
		            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
		            	params:{
		            	 	areaNature: -1,
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'warehouseArea/getWarehouseAreaList.action'        	
		            })
				},{
					xtype:'combobox',
					fieldLabel:'库位号',
					name:'locationNo',
					labelWidth:100,
					width:260,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					editable: false,
					queryMode: 'remote',
		            displayField: 'locationNo',
		            valueField: 'locationId',
		            value:-1,
		            store: Ext.create('WMS.store.baseinfo.WarehouseLocationStr',{
		            	params:{
		            	 	areaId: -1,
		            	 	areaNature:-1,
		            	 	status : -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'warehouseLocation/getWarehouseLocationViewList.action'        	
		            })
				}]
			},{
				xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 70,
	        	 	margin: 6
				},
				items:[,{
			        xtype:'combobox',
					fieldLabel:'操作类型',
					margin: '10 0 0 0',
					name:'operType',
					labelWidth:100,
					width:260,
					editable: false,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.OperTypeStr'),
		            value: '-1'
		   		},{
			        xtype:'combobox',
					fieldLabel:'操作原因',
					name:'remark',
					labelWidth:100,
					width:260,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					editable: false,
					queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            value: -1,
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
		            		dictType: -1,
		            		status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'dict/getDictList.action'   
		            }).load()
		   		},{
			        xtype:'combobox',
					fieldLabel:'操作员',
					name:'userId',
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					labelWidth:100,
					width:260,
					editable: false,
					queryMode: 'remote',
		            displayField: 'staffName',
		            valueField: 'staffId',
		            value:-1,
		            store: Ext.create('WMS.store.baseinfo.StaffViewStr',{
		            	params:{
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'staff/getUserList.action'        	
		            })
		   		}]
			},{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
					labelAlign : 'right',
					labelWidth : 70,
					margin : 6
				},
				items:[{
			        xtype:'combobox',
					fieldLabel:'供应商',
					margin: '10 0 0 10',
					name:'supplierName',
					labelWidth:90,
					width:250,
					emptyText: "--选择或输入--",
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					editable: true,
					queryMode: 'remote',
		            displayField: 'supplierName',
		            valueField: 'supplierId',
		           // value:-1,
		            store: Ext.create('WMS.store.baseinfo.SupplierViewStr',{
		            	params:{
		            	 	status: -1
		            	},
                    	hasEmptyItem: true,
		            	url: 'supplier/getSupplierList.action'        	
		            }),
		            //监听事件对下拉选项进行模糊匹配
		            listeners:{
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
		            				// 如果是字母 true
		            				if (regFile.test(value) == true){
		            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
		            					record.set('code', code);
			            				text = record.get('code');
		            				}
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
		   		},{
					xtype:'combobox',
				    fieldLabel:'需方商',
				    margin: '10 0 0 15',
				    // allowBlank:false,
				    name:'demanderName',
				    //labelWidth:120,
					emptyText: "--选择或输入--",
					labelWidth:90,
					width:250,
					editable: true,
					forceSelection:true,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 11);
    	                }
    	            },
					displayField: 'demanderName',
		            valueField: 'demanderId',
		            store: Ext.create('WMS.store.baseinfo.DemanderViewStr',{
		            	params:{
		            	 	status: 1,
		            	 	demanderId: -1
		            	},
		            	url: 'demander/getDemanderList.action'        	
		            }),
		            listeners:{  //监听事件对下拉选项进行模糊匹配
		            	beforequery:function(e){
		            		var combo =e.combo;
		            		if(!e.forceAll){
		            			var value = e.query;
		            			combo.store.filterBy(function(record,id){
		            				var text = record.get(combo.displayField);
		            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
		            				// 如果是字母 true
		            				if (regFile.test(value) == true){
		            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
		            					record.set('code', code);
			            				text = record.get('code');
		            				}
		            				return(text.indexOf(value)!=-1);
		            			});
		            			combo.expand();
		            			return false;
		            		}
		            	}
		            }
		   		},/*,{
		   			xtype : 'label',
		   			margin : '10 0 0 0',
		   			html : '<font style="bl;"><请先选择操作类型再选择操作原因></font>',
		   			//text : '<请先选择操作类型再选择操作原因>',
		   			labelStyle : 'color: red'
		   		}*/,{
		    		border:false
		    	},{
		    		border:false
		    	},{
		    		xtype:'checkbox',
		    		boxLabel:'显示禁用项',
		    		boxLabel:'<span>显示禁用项</span><img data-qtip="选中时显示所有查询条件（下拉框项）中已禁用的项，<br/>查询结果中包含已禁用项的结果；未选中时不显示" src="images/hint.png" class="hintico">',
		    		name: 'showForbidden',
		    		checked: true
		    	},{
			    	xtype:'button',
					width:60,
			    	text:'查询',
			    	width: 60,
			    	name:'btn-search',
					iconCls: 'btn-search'
		    	},{
			    	xtype:'button',
					width:60,
			    	text:'重置',
			    	width: 60,
			    	name:'btn-clear',
					iconCls: 'btn-clear'
	   			}]
			},,{
				xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 70,
	        	 	margin: 6
				},
				items:[{
			    	xtype:'textfield',
					fieldLabel:'送货人',
					margin: '10 0 0 10',
					name:'deliveryman',
					labelWidth:90,
					width:250,
	        		length: 15,
	        		vtypeText : '送货人最多可输入20个字符<br>送货人不能输入数字',
        		    vtype: 'exceptNumber'
		   		},{
			    	xtype:'textfield',
					fieldLabel:'车辆号码',
					margin: '10 0 0 15',
					name:'vehicleNo',
					labelWidth:90,
					width:250,
	        		length: 15,
	        		/**
	        		 * @author 李树雪 2015年12月22日 上午17.24
	        		 * @bug 717
	        		 * @code:385-391
	        		 */
	        		vtypeText : '车辆号码格式不对，应该以汉字开头，后面是6位数字或字母。<br><br>如：京A00000',
        		    vtype: 'checkNumber'
		   		},
		   		]
			}]
		};
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 60,
			 	margin: 6
			},
			items:[ {
				xtype:'button',
				text:'导出',
				name:'btn-export',
				iconCls: 'btn-export'
			}]
	    };
		
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			height:210,
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列    bug:632 将序号宽度从40改为60  彭婷婷
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:left", align:'center'
	      	}),

		    { text: '供应商', dataIndex: 'supplierName', width:130,style :"text-align:center",align:'left'},
		    { text: '需求方', dataIndex: 'demanderName', style :"text-align:center", width:130,  align:'left'},
		    { text: '需求号', dataIndex: 'demandNo', width:130, style :"text-align:center", align:'left'},
		    { text: '货物号', dataIndex: 'goodsCode', width:130, style :"text-align:center", align:'left'},
		    { text: '品名', dataIndex: 'goodsName', width:130, style :"text-align:center", align:'left'},
		    { text: '生产批号', dataIndex: 'productBatch', width:130, style :"text-align:center",  align:'left'},
		    { text: '数量', dataIndex: 'quantity', width:130, style :"text-align:center",  align:'center'},
		    { text: '库区名称', dataIndex: 'displayarea', width:130, style :"text-align:center",  align:'left'},
		    { text: '库区性质', dataIndex: 'displayAreaNature', width:130, style :"text-align:center",  align:'center'},
		    { text: '库位号', dataIndex: 'displayLocationNo', width:130, style :"text-align:center",  align:'left'},
		    { text: '操作类型', dataIndex: 'displayOperType', width:130, style :"text-align:center",  align:'center'},
		    { text: '操作时间', dataIndex: 'operTime', width:150, style :"text-align:center",  align:'center'},
		    { text: '操作原因', dataIndex: 'causeName', width:130, style :"text-align:center",  align:'left'},
		    { text: '车辆号码', dataIndex: 'vehicleNo', width:130, style :"text-align:center", align:'left'},
		    { text: '送货人', dataIndex: 'deliveryman', width:130, style :"text-align:center", align:'left'},
		    { text: '送货公司', dataIndex: 'deliveryCompany', width:130, style :"text-align:center", align:'left'},
		    { text: '操作员', dataIndex:'staffName', width:130,style:"text-align:center", align:'left'}
		];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的操作流水信息！',
			store: Ext.create('WMS.store.stock.OperFlowViewStr'),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
	listeners:{
		//panel显示事件
		afterrender:function(view, eOpts){
    		//绑定分页栏的store为grid的store
    		view.down('pagingtoolbar').bindStore(view.getStore());
		}
	}
});