/**
 * 库存信息编辑view.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.view.stock.StockSearchView', {
	extend: 'Ext.tree.Panel',
	alias: 'widget.stocksearchview',
	id: 'stocksearchview',
	collapsible: true,
	useArrows: true,
	rootVisible: false,
	multiSelect: true,
	closeAction : 'hide',
	singleExpand: false,
	loadMask : true,
	layout:'fit',
	requires:[
	    'WMS.store.common.AreaNatureStr',
        'WMS.store.stock.StockViewStr'
	],
	stores:[
        'WMS.store.stock.StockViewStr'
	],
	models:[
	    'WMS.model.stock.StockViewMdl'
	],
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
				xtype:'form',
				border: 1,
				width:'100%',
				items:[{
					xtype:'panel',
					layout : 'column',
					bodyStyle:'background:#E8E8E8;',
					border : false,
					defaults : {
						labelAlign : 'right',
						labelWidth : 70,
						margin : 6
					},
					items:[{
						xtype:'textfield',
						fieldLabel:'货物号',
						name:'goodsCode',
						labelWidth:70,
						width:230
					},{
						xtype:'combobox',
						fieldLabel:'库区性质',
						name:'areaNature',
						labelWidth:70,
						width:230,
						editable: false,
						displayField: 'name',
			            valueField: 'value',
		            	store: Ext.create('WMS.store.common.AreaNatureStr'),
			            value: '-1'
					},{
						xtype:'combobox',
						fieldLabel:'库区名称',
						name:'areaName',
						labelWidth:70,
						width:230,
						listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
	    	                }
	    	            },
						editable: false,
						queryMode: 'remote',
			            displayField: 'areaName',
			            valueField: 'areaId',
			            value:-1,
			            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
			            	params:{
			            	 	areaNature: -1,
			            	 	status : -1
			            	},
	                    	hasEmptyItem: true,
			            	url: 'warehouseArea/getWarehouseAreaList.action'        	
			            })
					}]
				},{
					xtype: 'panel',
					bodyStyle:'background:#E8E8E8;',
					layout : 'column',
					border:false,
					defaults : {
						labelAlign : 'right',
						labelWidth : 70,
						margin: 6
					},
					items:[{
						xtype:'textfield',
						labelWidth:70,
						width:230,
						fieldLabel:'订单号',
						name:'orderNo'
					},{

						xtype:'combobox',
					    fieldLabel:'供应商',
					   // allowBlank:false,
					    name:'supplierName',
						labelWidth:70,
						width:230,
		        		emptyText: "--选择或输入--",
		        		editable: true,
						listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
	    	                }
	    	            },
		        		displayField: 'supplierName',
			            valueField: 'supplierId',
			            store: Ext.create('WMS.store.baseinfo.SupplierViewStr',{
			            	params:{
			            	 	status: 1
			            	},
			            	url: 'supplier/getSupplierList.action'        	
			            }),
			            
			            //监听事件对下拉选项进行模糊匹配
			            listeners:{
			            	beforequery:function(e){
			            		var combo =e.combo;
			            		if(!e.forceAll){
			            			var value = e.query;
			            			combo.store.filterBy(function(record,id){
			            				var text = record.get(combo.displayField);
			            				var regFile = new RegExp(/^\w+$/);//正则表达式判断输入的是汉字还是字母
			            				// 如果是字母 true
			            				if (regFile.test(value) == true){
			            					var code = ACBEE.Ext.Pinyin.Pinyin_GetJP(text);
			            					record.set('code', code);
				            				text = record.get('code');
			            				}
			            				return(text.indexOf(value)!=-1);
			            			});
			            			combo.expand();
			            			return false;
			            		}
			            	}
			            }
			   		},{
						xtype:'combobox',
						fieldLabel:'库位',
						name:'locationNo',
						labelWidth:70,
						width:230,
						listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
	    	                }
	    	            },
						editable: false,
						queryMode: 'remote',
			            displayField: 'locationNo',
			            valueField: 'locationId',
			            value:-1,
			            store: Ext.create('WMS.store.baseinfo.WarehouseLocationStr',{
			            	params:{
			            	 	areaId: -1,
			            	 	areaNature:-1,
			            	 	status: -1
			            	},
	                    	hasEmptyItem: true,
			            	url: 'warehouseLocation/getWarehouseLocationViewList.action'        	
			            })
					}]
				},{
					xtype: 'panel',
					bodyStyle:'background:#E8E8E8;',
					layout : 'column',
					border:false,
					defaults : {
						xtype: 'radiofield',
						labelAlign : 'right',
						labelWidth : 70,
						margin : 6
					},
					items:[{
						xtype:'radiogroup',
						labelWidth:70,
						fieldLabel:'统计方式',
						name: 'totalType',
						defaults : {
	    					labelAlign : 'right',
	    					xtype: 'radiofield',
	    					margin: '0 2'
	    				},
						items:[{
							boxLabel : '货物',
							width:65,
							name : 'useState',
							inputValue: '0',
							checked:true
						},{
							boxLabel : '库位号',
							width:65,
							name : 'useState',
							inputValue: '1'
						},{
							boxLabel : '供应商',
							width:65,
							name : 'useState',
							inputValue: '2'
						}]
					},{
			    		xtype:'checkbox',
			    		boxLabel:'显示禁用项',
			    		boxLabel:'<span>显示禁用项</span><img data-qtip="选中时显示所有查询条件（下拉框项）中已禁用的项，<br/>查询结果中包含已禁用项的结果；未选中时不显示" src="images/hint.png" class="hintico">',
			    		name: 'showForbidden',
			    		checked: true
			    	},{
						xtype:'button',
						width:60,
						text:'查询',
				    	width: 60,
						name:'btn-search',
						iconCls: 'btn-search'
					},{
						xtype:'button',
						width:60,
						text:'重置',
				    	width: 60,
						name:'btn-clear',
						iconCls: 'btn-clear'
					}]
				}]
			};
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 60,
			 	margin: 6
			},
			items:[{
				xtype:'button',
				text:'导出',
				name:'btn-export',
				iconCls: 'btn-export'
			}]
	    };
		
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列
	createColumns:function(){
		var columns = [
		    {text: '供应商', dataIndex: 'supplierName', width:200, style :"text-align:center",align:'left'},
		    {text: '货物号', dataIndex: 'goodsCode', width:130, style :"text-align:center", align:'left', xtype: 'treecolumn'},
		    {text: '品名', dataIndex: 'goodsName', width:130, style :"text-align:center", align:'left'},
		    {text: '订单号', dataIndex: 'orderNo', width:130, style :"text-align:center", align:'left'},
		    {text: '生产批号', dataIndex: 'productBatch', width:130, style :"text-align:center", align:'left'},
		    {text: '数量', dataIndex: 'quantity', width:130, style :"text-align:center", align:'right'},
		    {text: '存放库位', dataIndex: 'locationNo', width:130, style :"text-align:center", align:'left'},
		    {text: '所在库区', dataIndex: 'areaName', width:130, style :"text-align:center", align:'left'},
		    {text: '入库时间', dataIndex: 'instockTime',width:150,style :"text-align:center",align:'left'}
		];
		return columns;	
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '---没有符合条件的库存信息---',
			store: this.createTreeStore(),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true,
		        store: this.createPagingStore(),
				listeners: {
					/**
					 * 页码等改变事件
					 * 触发treegrid的store加载事件
					 */
					change: function(p, pageData, eOpts){
						//保存分页store查询参数
						var params = p.getStore().proxy.extraParams;
						//增加分页相关的参数
						params.limit = p.pageSize;
						if(undefined == pageData) {
							params.page	= 1;
							params.start = 0;
						} else {
							params.page	= pageData.currentPage;
							params.start = p.pageSize * (pageData.currentPage - 1);
						}
						
						//取得表格树store
						var treeStore = this.getStore();
						//将分页组件的store参数赋给grid的store
						treeStore.proxy.extraParams = params;
						//表格store加载数据
						treeStore.load();
			        },
			        scope: this
			    }
		    }
		});
		this.callParent(arguments);
	},
	/**
	 * 是否第一次加载
	 * -1:第一次加载; 1或其它值:非第一次加载
	 * 本参数是为了解决首次打开模块时，树结点加载二次问题
	 */
	firstLoad: -1,
	/**
	 * 创建表格树store
	 */
	createTreeStore: function() {
		var treeStore = Ext.create('Ext.data.TreeStore', {  
			model: 'WMS.model.stock.StockViewMdl',
			autoLoad: false,
			proxy: {  
				type: 'ajax',
				actionMethods: 'POST',
				extraParams: {
					totalType: -1,
					firstLoad: this.firstLoad
				},
				url: 'stock/getStockViewTreeList.action'
			}
		}); 
		this.firstLoad = 1;
		
		return treeStore;
	},
	/**
	 * 创建分页store
	 */
	createPagingStore: function() {
		return Ext.create('WMS.store.stock.StockViewStr', {
			params: {
				totalType: -1
			},
			url: 'stock/searchStockViewPage.action'
		});
	}
});