/**
 * 分配用户view.
 * @author 奚志敏
 * @version 1.0.0, 2015-07-31
 */
Ext.define('WMS.view.systemservice.AssignUserView', {
	extend : 'Ext.window.Window',
	alias : 'widget.assignuserview',
	title : '分配用户',
	constrainHeader:true,
	closeAction : 'hide',
	resizable : false,
	width : 750,
	height : 450,
	layout : 'fit',
	modal : true,
	requires: [
	    'WMS.store.baseinfo.StaffViewStr'
  	],
  	stores:[
  	    'WMS.store.baseinfo.StaffViewStr'
   	],
   	models:[
   	    'WMS.model.baseinfo.StaffViewMdl'
   	],
	//创建表格列
	createColumns:function(){
		var columns = [
			new Ext.grid.RowNumberer({
				header:"序号", width:40, style :"text-align:center", align:'left'
			}),
		    { text: '员工姓名', dataIndex: 'staffName', width:80,style :"text-align:center",align:'left'},
		    { text: '用户名', dataIndex: 'userName', width:100,style :"text-align:center",align:'left'},
		    { text: '工号', dataIndex: 'jobNumber', width:100,style :"text-align:center",align:'left'},
		    { text: '部门', dataIndex: 'deptName', width:120,style :"text-align:center",align:'left'},
		    { text: '组别', dataIndex: 'groupName', width:120,style :"text-align:center",align:'left'},
		    { text: '职级', dataIndex: 'rankName', width:120,style :"text-align:center",align:'left'}
		];
		return columns;		
	},
	initComponent : function(){
		this.items={
			xtype : 'grid',
			border : false,
			height : 295,
			multiSelect : true,
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			columns : this.createColumns(),
			store : Ext.create('WMS.store.baseinfo.StaffViewStr', {
				url: 'staff/getUserList.action',
				params: {
					status: 1
				}
			})
		};
		this.fbar = [{
    		xtype : 'button',
        	margin : '5',
        	text : '保存',
        	name : 'btn-save',
        	iconCls: 'btn-save'
    	},{
    		xtype : 'button',
        	margin : '5',
        	text : '取消',
        	name : 'btn-cancel',
        	iconCls: 'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		
		this.callParent(arguments);
	}
});
