/**
 * 数据库管理view.
 * @author 楊偉艾
 * @version 1.0.0, 2015-12-11
 */
Ext.define('WMS.view.systemservice.DatabaseView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.databaseview',
	id: 'databaseview',
	resizable : false,
	closeAction : 'hide',
	multiSelect : true,
	loadMask : true,
	layout:'fit',
	requires : [
		'WMS.store.systemservice.database.DatabaseViewStr',
	    'Ext.ux.form.DateTimeField'
	],
	stores:[
		'WMS.store.systemservice.database.DatabaseViewStr'
	],
	models:[
		'WMS.model.systemservice.database.DatabaseViewMdl'
	],
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'form',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 10,
				    margin : '10 5'
				},
				items:[{ 
					xtype:'textfield',
					fieldLabel:'操作员',
					name:'userName',
					labelWidth:101,
					width:260
				},{
					xtype:'textfield',
					fieldLabel:'文件名',
					name:'fileName',
					labelWidth:103,
					width:262
				}],
				
			    },{
					xtype:'form',
					layout : 'column',
					bodyStyle:'background:#E8E8E8;',
					border : false,
					defaults : {
					    labelAlign : 'right',
					    labelWidth : 70,
					    margin : 6
				},
				items:[{    
					xtype:'datetimefield',
					fieldLabel:'备份开始时间',
					name:'startBackupTime',
					labelWidth:100,
					width:260,
					format : "Y-m-d",
					length:19,
					vtype:'datetime'
		  		    },{
		   			xtype:'datetimefield',
					fieldLabel:'备份截止时间',
					name:'endBackupTime',
					labelWidth:100,
					width:260,
					format : "Y-m-d",
					length:19,
					vtype:'datetime'
		  		},{
		    		border:false,
		    		width:15
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'查询',
			    	name:'btn-search',
			    	iconCls: 'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'重置',
			    	name:'btn-clear',
			    	iconCls: 'btn-clear'
		    	}],
			}]
		};
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 60,
			 	margin: 6
			},
		items:[{
		    	xtype:'button',
				width:60,
		    	text:'备份',
		    	width: 60,
		    	name:'btn-backup',
		    	iconCls: 'btn-backup'
	    	}]
	    };
		
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列  bug:632 将序号宽度从50改为60  彭婷婷
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:center", align:'center'
	      	}),
		    { text: '文件名', dataIndex: 'targetName', width:200,style :"text-align:center",align:'left'},
		    { text: '备份路径', dataIndex: 'targetPath', width:720,style :"text-align:center",align:'left'},
		    { text: '操作员', dataIndex: 'operator', width:70, style :"text-align:center", align:'left'},
		    { text: '备份时间', dataIndex: 'backupTime', width:135, style :"text-align:center", align:'center'},
		    ACBEE.Ext.Util.createEditBtn(this.functionCodes)
		    ];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的备份信息！',
			store:Ext.create('WMS.store.systemservice.database.DatabaseViewStr'),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
	listeners:{
		//panel显示事件
		afterrender:function(view,eOpts){
			//绑定分页栏的store为grid的store
			view.down('pagingtoolbar').bindStore(view.getStore());
		}
	}
});