/**
 * 供应商、需求方性质信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2015-07-14
 */
Ext.define('WMS.view.systemservice.DictEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.dicteditview',
	id : 'dicteditview',
	title : '信息编辑',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	width : 350,
	height : 240,
	layout : 'fit',
	modal : true,
	initComponent : function() {
		this.items = [{
			xtype : 'panel',
			border : false,
			margin : 25,
			items : [{
				xtype : 'form',
				border : false,
				items : [{
					xtype : 'panel',
			        layout:'column',
				    border: false,
			        defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '5'
			    	},
		    		items: [{
				        xtype: 'label',
				        margin: '8 0 0 5',
				        name: 'dictTypeLabelFlag',
				        text: '*',
				        cls: 'requiredflag',
				        width:5,
				        style: 'text-align: right;'
				    },{
				        xtype: 'label',
				        margin: '8 0 0 5',
				        name: 'dictTypeLabel',
				        width:75,
				        style: 'text-align: right;'
				    },{
		    			xtype: 'textfield',
		        		width: 180,
		        		name: 'dictName',
		        		allowBlank : false,
		        		length: 50,
		        		vtypeText : '名称最多可输入50个字符',
		        		vtype: 'limitLen',
		        		listeners:{  
	        				   'blur':function(e){e.setValue(e.getValue().trim())}  
			        				} 
					}]
				},{
					xtype:'panel',
					layout:'column',
			    	border: false,
			    	defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 84,
			        	margin: '5'
			    	},
		    		items:[{
						xtype:'fieldcontainer',
						fieldLabel:'状态',
						layout: 'hbox',
						allowBlank : false,
						defaults : {
	    					labelAlign : 'right',
	    					xtype: 'radiofield',
	    					margin: '0 2'
	    				},
					    items:[{
					    	name: 'status',
	    					boxLabel : '启用',
	                		inputValue: '1',
	                		checked:"checked"
	    			    },{
	    			    	name: 'status',
	    			        boxLabel : '禁用',
	                		inputValue: '0'
				    	}]
			    	}]
				},{
					xtype : 'panel',
			        layout:'column',
				    border: false,
			        defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '5'
			    	},
		    		items: [{
		    			xtype: 'textfield',
		        		width: 265,
		        		labelWidth : 85,
		        		fieldLabel:'排序号',
		        		name: 'dictOrder',
		        		allowBlank : false,
		        		length: 3,
		        		vtypeText : '排序号只能输入数字，且最多可输入3位数字',
		        		vtype: 'number'
					}]
				}]
			}]
		}],
		this.fbar = [{
    		xtype: 'button',
        	margin: '5',
        	text: '保存',
        	name: 'btn-save',
			iconCls: 'btn-save'
    	},{
    		xtype: 'button',
        	margin: '5',
        	text: '取消',
        	name: 'btn-cancel',
			iconCls: 'btn-cancel',
        	scope: this,
        	handler: this.close
    	}];
		
		this.callParent(arguments);
	}
});