/**
 * 数据字典管理view.
 * @author 高元称
 * @version 1.0.0, 2015-07-14
 */
Ext.define('WMS.view.systemservice.DictSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.dictsearchview',
	id: 'dictsearchview',
	resizable : false,
	closeAction : 'hide',
	multiSelect : true,
	loadMask : true,
	layout:'fit',
	requires: [
	    'WMS.store.common.StatusStr',
        'WMS.store.common.DictStr'
	],
	stores:[
		'WMS.store.common.DictStr'
	],
	models:[
		'WMS.model.common.DictMdl'
	],
	 
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
			        xtype: 'label',
			        margin: '8 0 0 5',
			        name: 'dictTypeLabel',
			        width:70,
			        style: 'text-align: right;'
			    },{
			    	xtype:'textfield',
			    	name:'dictName',
	        		length: 50,
	        		vtypeText : '名称最多可输入50个字符',
	        		vtype: 'limitLen',
			        width:168
				},{
			    	xtype:'combobox',
				    fieldLabel:'状态',
				    editable: false,
				    name:'status',
				    labelWidth :70,
				    width : 175,
		        	displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.StatusStr'),
		            value: '-1'
				},{
					xtype:'button',
					text:'查询',
					width: 70,
					name:'btn-search',
					iconCls: 'btn-search'
				},{
					xtype:'button',
					text:'重置',
					width: 70,
					name:'btn-clear',
					iconCls: 'btn-clear'
				}]	
			}]
		};
		
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 70,
			 	margin: 6
			},
			items:[{
				xtype : 'button',
				text : '添加',
				name : 'btn-add',
				iconCls: 'btn-add'
			}, {
				xtype : 'button',
				text : '删除',
				name : 'btn-delete',
				iconCls: 'btn-delete'
			}, {
				xtype : 'button',
				text : '启用',
				name : 'btn-openStatus',
				iconCls: 'btn-openStatus'
			}, {
				xtype : 'button',
				text : '禁用',
				name : 'btn-closeStatus',
				iconCls: 'btn-closeStatus'
			}]
	    };
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列  bug:632 将序号宽度从40改为60  彭婷婷
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:left", align:'center'
	      	}),
		    { text: '名称', dataIndex: 'dictName', width:200,style :"text-align:center",align:'left'},
		    { text: '状态', dataIndex: 'displayStatus', width:80,style :"text-align:center",align:'center'},
		    { text: '排序号', dataIndex: 'dictOrder', width:80,style :"text-align:center",align:'right'},
		    ACBEE.Ext.Util.createEditBtn(this.functionCodes)
		];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的信息！',
			store: Ext.create('WMS.store.common.DictStr', {
				url: 'dict/searchDictPage.action'
			}),
			/********
			 * 2015/12/26
			 * 王玉涛
			 * bug745
			 */
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
	listeners: {
    	//panel渲染后事件
		afterrender: function(view, eOpts) {
    		//绑定分页栏的store为grid的store
    		view.down('pagingtoolbar').bindStore(view.getStore());
    	}
    }
});
