/**
 * 货物类别信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2015-07-16
 */
Ext.define('WMS.view.systemservice.GoodCategoryEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.goodcategoryeditview',
	id : 'goodcategoryeditview',
	title : '添加货物类别信息',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	width : 350,
	height : 200,
	layout : 'fit',
	modal : true,
	initComponent : function() {
		this.items = [{
			xtype : 'panel',
			border : false,
			margin : 25,
			items : [{
				xtype : 'form',
				border : false,
				items : [{
					xtype : 'panel',
			        layout:'column',
				    border: false,
			        defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '5'
			    	},
		    		items: [{
		    			xtype: 'textfield',
		        		width: 200,
		        		labelWidth : 90,
		        		name: 'parentName',
		        		allowBlank : false,
		        		maxLength: 90,
		        		fieldLabel:'父类名称'
					},{
		    			xtype: 'textfield',
		        		width: 200,
		        		labelWidth : 90,
		        		name: 'typeName',
		        		allowBlank : false,
		        		maxLength: 90,
		        		fieldLabel:'货物名称'
					}]
				    },{
							xtype:'panel',
							layout:'column',
					    	border: false,
				        	defaults : {
				    			labelAlign : 'right',
				    			labelWidth : 70,
					        	margin: '5'
				    		}
							},{
									xtype:'panel',
									layout:'column',
							    	border: false,
						        	defaults : {
						    			labelAlign : 'right',
						    			labelWidth : 70,
							        	margin: '5'
						    		},
						    		items:[{
										xtype:'radiogroup',
										labelWidth:90,
										fieldLabel:'状态',
										name: 'stateGroup',
										defaults : {
					    					labelAlign : 'right',
					    					xtype: 'radiofield',
					    					margin: '0 2'
					    				},
					    			    items:[{
					    					boxLabel : '启用',
					                		name : 'useState',
					                		inputValue: '1',
					                		checked:"btn-openStatus"
					    			    },{
					    			        boxLabel : '禁用',
					                		name : 'btn-closeStatus',
					                		inputValue: '2'
				    			    	}]
			    					}]
								}]
							}]
					}],
			this.fbar = [{
	    		xtype: 'button',
	        	margin: '5',
	        	text: '保存',
	        	name: 'btn-save'
	    	},{
	    		xtype: 'button',
	        	margin: '5',
	        	text: '取消',
	        	name: 'btn-exit',
	        	scope: this,
	        	handler: this.close
	    		}];
			this.callParent(arguments);
	}
});