/**
 * 货物类别信息管理view.
 * @author 高元称
 * @version 1.0.0, 2015-07-16
 */
Ext.define('WMS.view.systemservice.GoodCategorySearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.goodcategorysearchview',
	id: 'goodcategorysearchview',
	resizable : false,
	multiSelect : true,
	closeAction : 'hide',
	loadMask : true,
	layout:'fit',
	dictType: '1',
	requires : [
		'WMS.store.systemservice.dictionary.GoodsCategoryViewStr'
	],
	stores:[
		'WMS.store.systemservice.dictionary.GoodsCategoryViewStr'
	],
	models:[
		'WMS.model.systemservice.dictionary.GoodsCategoryViewMdl'
	], 
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
			    	xtype:'textfield',
			    	fieldLabel: '货物类别名称',
			    	name:'name',
			        labelWidth:90,
			        width:250,
	        		length: 50,
	        		vtypeText : '货物类别名称最多可输入50个字符',
	        		vtype: 'exceptNumber'
				},{
			    	xtype:'combobox',
				    fieldLabel:'状态',
				    editable: false,
				    name:'status',
				    labelWidth :70,
				    width : 175,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.StatusStr'),
		            value: '-1'
				},{
					xtype:'button',
					text:'查询',
					width:60,
					name:'btn-search',
					iconCls: 'btn-search'
				},{
					xtype:'button',
					text:'重置',
					width:60,
					iconCls: 'btn-clear',
					name:'btn-clear'
				}]	
			}]
		};
		
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 60,
			 	margin: 6
			},
			items:[{
				xtype : 'button',
				text : '添加',
				name : 'btn-add',
				iconCls: 'btn-add'
			},{
				xtype : 'button',
				text : '删除',
				name : 'btn-delete',
				iconCls: 'btn-delete'
			},{
			    xtype : 'button',
			    text : '导入',
			    name : 'btn-import',
			    iconCls: 'btn-import'
			},{
			    xtype : 'button',
			    text : '导出',
			    name : 'btn-export',
			    iconCls: 'btn-export'
			},{
				xtype : 'button',
				text : '启用',
				name : 'btn-openStatus',
				iconCls: 'btn-openStatus'
			}, {
				xtype : 'button',
				text : '禁用',
				name : 'btn-closeStatus',
				iconCls: 'btn-closeStatus'
			}]
	    };
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'center'
	      	}),
	      	{ text: '父货物类别名称', dataIndex: 'parentName',hidden:true},
		    { text: '货物类别名称', dataIndex: 'name', width:140,style :"text-align:center",align:'left'},
		    { text: '状态', dataIndex: 'displayStatus', width:80,style :"text-align:center",align:'left'},
		    ACBEE.Ext.Util.createEditBtn([])
		];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的货物类别信息！',
			store: Ext.create('WMS.store.systemservice.dictionary.GoodsCategoryViewStr',{
				url:'goodsCategory/searchGoodsCategoryPage.action',
				params : {
					gcId : 0,
					name: '',
					status: -1
				}
			}),
			/********
			 * 2015/12/26
			 * 王玉涛
			 * bug745
			 */
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
	listeners:{
		//panel渲染后事件
		afterrender:function(view,eOpts){
			//绑定分页栏的store为grid的store
			view.down('pagingtoolbar').bindStore(view.getStore());
		}
	}
});
