/**
 * 货物类别view.
 * @author 高元称
 * @version 1.0.0, 2015-08-06
 */
Ext.define('WMS.view.systemservice.GoodsCategoryAddEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.goodsCategoryAddEditView',
	id : 'goodsCategoryAddEditView',
	title : '添加货物类别名称',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	width : 380,
	height : 240,
	layout : 'fit',
	modal : true,
	initComponent : function() {
		this.items = [{
			xtype : 'panel',
			border : false,
			margin : 25,
			items : [{
				xtype : 'form',
				border : false,
				items : [{
					xtype : 'panel',
			        layout:'column',
				    border: false,
			        defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '10'
			    	},
		    		items: [{
			    		xtype:'textfield',
						width:280,
						labelWidth:100,
						name:'name',
		        		allowBlank : false,
						fieldLabel:'货物类别名称',
		        		length: 50,
		        		vtypeText : '货物类别名称最多可输入50个字符',
		        		vtype: 'exceptNumber',
		        		listeners:{  
	        				   'blur':function(e){e.setValue(e.getValue().trim())}  
			        				} 
			        }]
				},{
					xtype:'panel',
					layout:'column',
					border: false,
					defaults : {
						labelAlign : 'right',
						labelWidth : 70,
						margin: '5'
					},
					items:[{
						xtype:'radiogroup',
						labelWidth:100,
						allowBlank : false,
						fieldLabel:'状态',
						defaults : {
							labelAlign : 'right',
							xtype: 'radiofield',
							margin: '0 2'
						},
						items:[{
							boxLabel : '启用',
							name : 'status',
							inputValue: '1',
							checked:"checked"
						},{
							boxLabel : '禁用',
							name : 'status',
							inputValue: '0'
						}]
					}]
				}]
			}]
		}],
		this.fbar = [{
			xtype: 'button',
			margin: '5',
			text: '保存',
			name: 'btn-save',
			iconCls: 'btn-save'
		},{
			xtype: 'button',
			margin: '5',
			text: '取消',
			name: 'btn-exit',
			iconCls: 'btn-cancel',
			scope: this,
			handler: this.close
		}];
		this.callParent(arguments);
	}
});