/**
 * 库位性质信息编辑view.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-14
 */
Ext.define('WMS.view.systemservice.LocationNatureEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.locationnatureeditview',
	id : 'locationnatureeditview',
	title : '库位性质信息编辑',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	width : 340,
	height : 220,
	layout : 'fit',
	modal : true,
	initComponent : function() {
		this.items = [{
			xtype : 'panel',
			border : false,
			margin : 5,
			items : [{
				xtype : 'form',
				border : false,
				items : [{
					xtype : 'panel',
			        layout:'column',
				    border: false,
			        defaults : {
		    			labelAlign : 'right',
		    			labelWidth : 70,
			        	margin: '10'
			    	},
		    		items: [{
			    		xtype:'textfield',
						width:280,
						labelWidth:100,
						name:'natureName',
		        		allowBlank : false,
						fieldLabel:'库位性质名称',
		        		length: 50,
		        		vtypeText : '库位性质名称最多可输入50个字符',
		        		vtype: 'exceptNumber',
		        		listeners:{  
	        				   'blur':function(e){e.setValue(e.getValue().trim())}  
			        				} 
					},{
		    			xtype:'combobox',
						fieldLabel:'所属库区性质',
						name:'areaNature',
						labelWidth:100,
						width:280,
						allowBlank : false,
						displayField: 'name',
			            valueField: 'value',
		            	store: Ext.create('WMS.store.common.AreaNatureStr', {
		            		hasEmptyItem: false
		            	}),
			            value: 1
			        }]
				},{
					xtype:'panel',
					layout:'column',
					border: false,
					defaults : {
						labelAlign : 'right',
						labelWidth : 70,
						margin: '5'
					},
					items:[{
						xtype:'radiogroup',
						labelWidth:100,
						allowBlank : false,
						fieldLabel:'状态',
						defaults : {
							labelAlign : 'right',
							xtype: 'radiofield',
							margin: '0 2'
						},
						items:[{
							boxLabel : '启用',
							name : 'status',
							inputValue: '1',
							checked:"checked"
						},{
							boxLabel : '禁用',
							name : 'status',
							inputValue: '0'
						}]
					}]
				}]
			}]
		}],
		this.fbar = [{
			xtype: 'button',
			margin: '5',
			text: '保存',
			name: 'btn-save',
			iconCls: 'btn-save'
		},{
			xtype: 'button',
			margin: '5',
			text: '取消',
			name: 'btn-exit',
			iconCls: 'btn-cancel',
			scope: this,
			handler: this.close
		}];
		this.callParent(arguments);
	}
});