/**
 * 库位性质信息管理view.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-14
 */
Ext.define('WMS.view.systemservice.LocationNatureSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.locationnaturesearchview',
	id: 'locationnaturesearchview',
	resizable : false,
	closeAction : 'hide',
	multiSearch : true,
	loadMask : true,
	layout:'fit',
	requires: [
	      	    'WMS.store.common.AreaNatureStr',
	      	    'WMS.store.common.StatusStr',
	      	    'WMS.store.common.LocationNatureStr'
	],
	stores:[
	        'WMS.store.common.LocationNatureStr'
	],
	models:[
	   	    'WMS.model.common.LocationNatureMdl'
	],
	 
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'panel',
			border: 1,
			width:'100%',
			items:[{
				xtype:'form',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
			    	xtype:'combobox',
					fieldLabel:'所属库区性质',
					name:'areaNature',
					labelWidth:90,
					width:250,
					editable: false,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.AreaNatureStr'),
		            value: '-1'
				},{
					xtype:'textfield',
					fieldLabel:'库位性质名称',
					name:'natureName',
					labelWidth:90,
					width:250,
	        		length: 50,
	        		vtypeText : '库位性质名称最多可输入50个字符',
	        		vtype: 'exceptNumber'
				}]	
			},{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					xtype:'combobox',
					fieldLabel:'状态',
					name:'status',
					labelWidth:90,
					width:250,
					editable: false,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.StatusStr'),
		            value: '-1'
				},{
		    		border:false
		    	},{
			    	xtype:'button',
			    	width: 70,
			    	text:'查询',
			    	name:'btn-search',
					iconCls: 'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 70,
			    	text:'重置',
			    	name:'btn-clear',
					iconCls: 'btn-clear'
	   			}]	
			}]
		};
		
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
		    	width: 70,
			 	margin: 6
			},
			items:[{
				xtype : 'button',
				text : '添加',
				name : 'btn-add',
				iconCls: 'btn-add'
			}, {
				xtype : 'button',
				text : '删除',
				name : 'btn-delete',
				iconCls: 'btn-delete'
			}, {
				xtype:'button',
				text:'启用',
				name:'btn-openStatus',
				iconCls: 'btn-openStatus'
			}, {
				xtype:'button',
				text:'禁用',
				name:'btn-closeStatus',
				iconCls: 'btn-closeStatus'
			}]
	    };
		
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"编号", width:40, style :"text-align:left", align:'center'
	      	}),
	      	{ text: '所属库区性质', dataIndex: 'displayAreaNature', width:120,style :"text-align:center",align:'left'},
		    { text: '库位性质名称', dataIndex: 'natureName', width:120,style :"text-align:center",align:'left'},
		    { text: '状态', dataIndex: 'displayStatus', style :"text-align:center", width:120,  align:'left'},
		    ACBEE.Ext.Util.createEditBtn(this.functionCodes)
		];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的库位性质信息！',
			store:new Ext.create('WMS.store.common.LocationNatureStr'),
			/********
			 * 2015/12/26
			 * 王玉涛
			 * bug745
			 */
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
    listeners: {
    	//panel显示事件
    	afterrender: function(view, eOpts) {
    		//绑定分页栏的store为grid的store
    		view.down('pagingtoolbar').bindStore(view.getStore());
    	}
    }
});
