/**
 * 日志编辑view.
 * @author 苏亚欣
 * @version 1.0.0, 2015-09-15
 */
Ext.define('WMS.view.systemservice.LogDetailView', {
	extend : 'Ext.window.Window',
	alias : 'widget.logdetailview',
	id : 'logdetailview',
	title : '日志详情',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	width : 550,
	height : 400,
	layout : 'fit',
	modal : true,
	initComponent : function() {
		this.items = [{
			xtype : 'form',
			border : false,
			items : [{
				xtype : 'panel',
		        layout:'column',
			    border: false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin: '6'
		    	},
	    		items: [{
	        		xtype: 'textfield',
	        		width: 260,
	        		labelWidth : 100,
	        		name: 'userName',
	        		readOnly: true,
	        		fieldLabel: '操作员',
	        		fieldStyle:'background-color:rgb(244,244,244)'
	       		 },{
					xtype:'textfield',
					fieldLabel:'模块',
	        		readOnly: true,
					name:'moduleName',
					labelWidth:60,
					width:220,
	        		fieldStyle:'background-color:rgb(244,244,244)'
				}]
			},{
				xtype:'form',
				layout : 'column',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
		   			xtype:'textfield',
					fieldLabel:'操作时间',
	        		readOnly: true,
					name:'logTime',
					labelWidth:100,
					width:260,
	        		fieldStyle:'background-color:rgb(244,244,244)'
		  		},{
					xtype:'textfield',
					fieldLabel:'IP地址',
	        		readOnly: true,
					name:'ip',
					labelWidth:60,
					width:220,
	        		fieldStyle:'background-color:rgb(244,244,244)'
				}]
			},{
				xtype:'form',
				layout : 'column',
				border : false,
				defaults : {
				    labelAlign : 'left',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
		    		xtype : 'label',
	        		width : 100,
	        		name : 'logContent',
	        		text : '日志内容:',
	        		style: 'text-align: right;'
				},{
		    		xtype: 'textarea',
			        name: 'logContent',
	        		readOnly: true,
	        		margin:'5 0 0 -1',
			        rows:12,
			        cols:48,
	        		fieldStyle:'background-color:rgb(244,244,244)'
				}]
			}]
		}];
		this.fbar = [{
    		xtype: 'button',
        	margin: '6',
        	text: '关闭',
        	name: 'btn-close',
        	scope: this,
        	handler: this.close
    	}];
		this.callParent(arguments);
	}
})