/**
 * 报表view.
 * @author 苏亚欣
 * @version 1.0.0, 2015-09-15
 */
Ext.define('WMS.view.systemservice.LogSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.logsearchview',
	id: 'logsearchview',
	resizable : false,
	closeAction : 'hide',
	multiSelect : true,
	loadMask : true,
	layout:'fit',
	requires : [
		'WMS.store.systemservice.log.LogViewStr',
	    'Ext.ux.form.DateTimeField'
	],
	stores:[
		'WMS.store.systemservice.log.LogViewStr'
	],
	models:[
		'WMS.model.systemservice.log.LogViewMdl'
	],
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'form',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					xtype:'textfield',
					fieldLabel:'操作员',
					name:'userName',
					labelWidth:90,
					width:250
				},{
		   			xtype:'datetimefield',
					fieldLabel:'操作开始时间',
					name:'beginDateTime',
					labelWidth:100,
					width:260,
					format : "Y-m-d",
					length:19,
	        		vtypeText:'操作开始时间必须早于操作结束时间',
					vtype:'datetime'
		  		},{
			        xtype:'datetimefield',
					fieldLabel:'操作结束时间',
					name:'endDateTime',
					labelWidth:100,
					width:260,
					format : "Y-m-d",
					vtype:'datetime',
					length:19,
					compareTo:'beginDateTime',
					vtypeText : '操作结束时间必须晚于操作开始时间。'
				}]
			},{
				xtype:'form',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					xtype:'combobox',
					fieldLabel:'模块',
					name:'moduleName',
					id: 'moduleName',
					labelWidth:90,
					width:250,
					editable: false,
					queryMode: 'remote',
		            displayField: 'moduleName',
		            valueField: 'moduleId',
		            value:-1,
		            store: Ext.create('WMS.store.menufunction.ModuleStr',{
		            	params:{
		            	 	parentId: 0
		            	},
                    	hasEmptyItem: true,
		            	url: 'module/searchModuleList.action'        	
		            })
				},{
					xtype:'textfield',
					fieldLabel:'日志内容',
					name:'logContent',
					labelWidth:100,
					width:260
				},{
					xtype:'textfield',
					fieldLabel:'IP地址',
					name:'IP',
					labelWidth:100,
					width:260
				},{
		    		border:false,
		    		width:15
		    	},{
			    	xtype:'button',
					width:60,
			    	text:'查询',
			    	width: 60,
			    	name:'btn-search',
					iconCls: 'btn-search'
		    	},{
			    	xtype:'button',
					width:60,
			    	text:'重置',
			    	width: 60,
			    	name:'btn-clear',
					iconCls: 'btn-clear'
	   			}]
			}]
		};
		return scPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			]
		};
	},
	//创建表格列   bug:632 将序号宽度从50改为60  彭婷婷
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:left", align:'center'
	      	}),
		    { text: '日志内容', dataIndex: 'logContent', width:720,style :"text-align:center",align:'left'},
		    { text: '模块', dataIndex: 'moduleName', width:100,  style :"text-align:center", align:'left'},
		    { text: 'IP地址', dataIndex: 'ip', width:100, style :"text-align:center", align:'center'},
		    { text: '操作员', dataIndex: 'userName', width:70, style :"text-align:center", align:'left'},
		    { text: '操作时间', dataIndex: 'logTime', width:135, style :"text-align:center", align:'center'},
		    ACBEE.Ext.Util.createEditBtn(this.functionCodes)
		    ];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的日志信息！',
			store:Ext.create('WMS.store.systemservice.log.LogViewStr'),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
	listeners:{
		//panel显示事件
		afterrender:function(view,eOpts){
			//绑定分页栏的store为grid的store
			view.down('pagingtoolbar').bindStore(view.getStore());
			
		}
	}
});