/**
 * 角色信息编辑controller.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-14
 */
Ext.define('WMS.view.systemservice.RoleEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.roleeditview',
	id : 'roleeditview',
	title : '角色信息编辑',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	width : 360,
	height : 275,
	layout : 'fit',
	modal : true,
	initComponent : function() {
		this.items = [{
			xtype : 'form',
			border : false,
			padding: 10,
			items : [{
				xtype : 'panel',
		        layout:'column',
			    border: false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin: '5'
		        },
	    		items: [{
	    			xtype: 'textfield',
	        		width: 300,
	        		name: 'roleName',
	        		allowBlank : false,
	        		fieldLabel:'角色名称',
	        		length: 20,
	        		vtypeText : '角色名称最多可输入20个字符',
	        		vtype: 'limitLen',
	        		listeners:{  
     				   'blur':function(e){e.setValue(e.getValue().trim())}  
		        				} 
				}]
			},{
				xtype:'panel',
				layout:'column',
		    	border: false,
	        	defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin: '5'
	    		},
				items:[{
					xtype:'fieldcontainer',
					fieldLabel:'状态',
					layout: 'hbox',
					allowBlank : false,
					defaults : {
    					labelAlign : 'right',
    					xtype: 'radiofield',
    					margin: '0 5'
    				},
				    items:[{
				    	name: 'status',
    					boxLabel : '启用',
                		inputValue: '1',
                		checked:"checked"
    			    },{
    			    	name: 'status',
    			        boxLabel : '禁用',
                		inputValue: '0'
			    	}]
		    	}]
			},{
				xtype:'panel',
				layout:'column',
		    	border: false,
	        	defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin: '5'
	    		},
	    		items:{
	    			xtype:'textarea',
	    			fieldLabel:'备注',
	    			name:'remark',
	    			width: 300,
	    			height: 80,
	    			length: 200,
	        		vtypeText : '备注信息最多可输入200个字符',
	        		vtype: 'limitLen'
	    		}
			}]
		}],
		
		this.fbar = [{
    		xtype: 'button',
        	margin: '6',
        	text: '保存',
        	name: 'btn-save',
			iconCls: 'btn-save'
    	},{
    		xtype: 'button',
        	margin: '6',
        	text: '取消',
        	name: 'btn-cancel',
			iconCls: 'btn-cancel',
        	scope: this,
        	handler: this.close
    	}];
		
		this.callParent(arguments);
	}
});