/**
 * 角色信息管理controller.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-14
 * @author 奚志敏
 * @version 1.0.1, 2015-07-20
 */
Ext.define('WMS.view.systemservice.RoleSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.rolesearchview',
	id: 'rolesearchview',
	resizable : false,
	closeAction : 'hide',
	multiSelect : true,
	loadMask : true,
	layout:'fit',
	requires: [
   	    'WMS.store.common.StatusStr',
   	    'WMS.store.systemservice.userrole.RoleStr'
   	],
   	stores:[
	    'WMS.store.systemservice.userrole.RoleStr'
	],
	models:[
	    'WMS.model.systemservice.userrole.RoleMdl'
	],
	 
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'panel',
			border: 1,
			width:'100%',
			items:[{
				xtype:'form',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : '10 5'
				},
				items:[{
					xtype:'textfield',
					fieldLabel:'角色名称',
					name:'roleName',
			        labelWidth:70,
			        width:260,
			        length: 20,
	        		vtypeText : '角色名称最多可输入20个字符',
	        		vtype: 'limitLen'
				},{
					xtype:'combobox',
					fieldLabel:'状态',
					name:'status',
					labelWidth:40,
					width:160,
					editable: false,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.StatusStr'),
		            value: '-1'
				},{
			    	xtype:'button',
			    	width: 70,
			    	text:'查询',
			    	name:'btn-search',
					iconCls: 'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 70,
			    	text:'重置',
			    	name:'btn-clear',
					iconCls: 'btn-clear'
	   			}]	
			}]
		};
		
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 70,
			 	margin: 6
			},
			items:[{
				xtype : 'button',
				text : '添加',
				name : 'btn-add',
				iconCls: 'btn-add'
			}, {
				xtype : 'button',
				text : '删除',
				name : 'btn-delete',
				iconCls: 'btn-delete'
			}, {
				xtype:'button',
				text:'启用',
				name:'btn-openStatus',
				iconCls:'btn-openStatus'
			}, {
				xtype:'button',
				text:'禁用',
				name:'btn-closeStatus',
				iconCls:'btn-closeStatus'
			}]
	    };
		
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列  bug:632 将序号宽度从40改为60  彭婷婷
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:center", align:'center'
	      	}),
	      	{ text: '角色名称', dataIndex: 'roleName', width:120,style :"text-align:center",align:'left'},
	      	{ text: '备注', dataIndex: 'remark', width:260,style :"text-align:center",align:'left'},
		    { text: '状态', dataIndex: 'displayStatus', style :"text-align:center", width:80,  align:'center'},
		    ACBEE.Ext.Util.createEditBtn(this.functionCodes)
	    ];
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的角色信息！',
			store : Ext.create('WMS.store.systemservice.userrole.RoleStr', {
				url: 'role/searchRolePage.action'
			}),
			/********
			 * 2015/12/26
			 * 王玉涛
			 * bug745
			 */
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
    listeners: {
    	//panel渲染后事件
		afterrender: function(view, eOpts) {
    		//绑定分页栏的store为grid的store
    		view.down('pagingtoolbar').bindStore(view.getStore());
    	}
    }
});
