/**
 * 员工信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2016-07-10
 */
Ext.define('WMS.view.systemservice.StaffEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.staffeditview',
	id : 'staffeditview',
	title : '员工信息编辑',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	width : 630,
	height : 530,
	layout : 'fit',
	modal : true,
	requires:[
	    'WMS.store.common.DictStr'
	],
	initComponent : function() {
		this.items = [{
			xtype : 'panel',
			border : false,
			margin : 0,
			items : [{
				xtype : 'form',
				title: '员工基本信息',
				border : false,
				items : [{
					xtype : 'panel',
			        layout:'column',
				    border: false,
			        defaults : {
		    			labelAlign : 'right',
		    			labelWidth: 100,
			        	margin: '6'
			    	},
		    		items: [{
		    			xtype: 'textfield',
		        		width: 270,
		        		name: 'staffName',
		        		allowBlank: false,
		        		fieldLabel: '员工姓名',
		        		length: 20,
		        		vtypeText : '员工姓名最多可输入20个字符',
		        		vtype: 'limitLen',
		        		listeners:{  
	        				   'blur':function(e){e.setValue(e.getValue().trim())}  
			        				} 
		    		},{
		    			xtype: 'textfield',
		        		width: 270,
		        		name: 'jobNumber',
		        		allowBlank: false,
		        		fieldLabel: '工号',
		        		length: 20,
		        		vtypeText : '工号最多可输入20个字符',
		        		vtype: 'limitLen',
		        		listeners:{  
	        				   'blur':function(e){e.setValue(e.getValue().trim())}  
			        				} 
	    		    }]
			     },{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			labelWidth: 100,
		    			editable: false,
			        	margin: '6'
		    		},
		    		items:[{
	        			xtype:'combobox',
						fieldLabel:'部门',
						name:'deptId',
						allowBlank: false,
						emptyText: "--请选择--", 
						width:270,
						listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
	    	                }
	    	            },
						queryMode: 'remote',
			            displayField: 'dictName',
			            valueField: 'dictId',
			            store: Ext.create('WMS.store.common.DictStr',{
			            	params:{
								dictType: 8,
			            	 	status: 1
			            	},
			            	url: 'dict/getDictList.action'        	
			            })
					},{
		    			xtype:'combobox',
						fieldLabel:'组别',
						name:'groupId',
						allowBlank: false,
						emptyText: "--请选择--", 
						width:270,
						listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
	    	                }
	    	            },
						queryMode: 'remote',
			            displayField: 'dictName',
			            valueField: 'dictId',
			            store: Ext.create('WMS.store.common.DictStr',{
			            	params:{
								dictType: 10,
			            	 	status: 1
			            	},
			            	url: 'dict/getDictList.action'        	
			            })
		    		}]
			    },{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			labelWidth: 100,
			        	margin: '6'
		    		},
		    		items:[{
		        		xtype:'combobox',
						fieldLabel:'职级',
						name:'rankId',
						allowBlank: false,
						editable: false,
						emptyText: "--请选择--", 
						width:270,
						listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
	    	                }
	    	            },
						queryMode: 'remote',
			            displayField: 'dictName',
			            valueField: 'dictId',
			            store: Ext.create('WMS.store.common.DictStr',{
			            	params:{
								dictType: 9,
			            	 	status: 1
			            	},
			            	url: 'dict/getDictList.action'        	
			            })
		       		},{
				    	xtype: 'textfield',
		        		width: 270,
		        		name: 'tel',
		        		fieldLabel: '联系电话',
		        		length: 50,
		        		vtypeText : '联系电话最多可输入50个字符',
		        		vtype: 'phone'
	   				}]
			    },{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			labelWidth: 100,
			        	margin: '6'
		    		},
		    		items:[{
		    			xtype:'datefield',
						fieldLabel:'入职日期',
						name:'entryTime',
						labelAlign : 'right',
						width:270,
						format : "Y-m-d",
		        		length: 10,
		        		vtype: 'date'
	    			},{
		    			xtype: 'textfield',
		        		width: 270,
		        		name: 'leader',
		        		allowBlank: false,
		        		fieldLabel: '负责人',
		        		length: 20,
		        		vtypeText : '负责人最多可输入20个字符',
		        		vtype: 'limitLen',
		        		listeners:{  
	        				   'blur':function(e){e.setValue(e.getValue().trim())}  
			        				} 
    				}]
				},{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			labelWidth: 100,
			        	margin: '6'
		    		},
		    		items:[{
		    			xtype: 'textarea',
		        		width: 552,
		        		height: 90,
		        		name: 'workContent',
		        		fieldLabel: '工作内容',
		        		length: 200,
		        		vtypeText : '工作内容最多可输入200个字符',
		        		vtype: 'limitLen'
		    		}]
				},{
					xtype:'panel',
					layout:'column',
			    	border: false,
		        	defaults : {
		    			labelAlign : 'right',
		    			xtype: 'radiofield',
		    			labelWidth : 100,
		    			margin: '0 5'
		    		},
		    		items:[{
				        xtype: 'displayfield',
				        margin: '0 0 0 5',
				        fieldLabel: '状态',
				        width: 100,
				        style: 'text-align: right;'
				    },{
    					boxLabel : '启用',
                		name : 'status',
                		inputValue: '1',
                		checked:"checked"
    			    },{
    			        boxLabel : '禁用',
                		name : 'status',
                		inputValue: '0'
			    	}]
				},{
					xtype : 'panel',
					title: '系统登录信息',
				    border: false,
					items: [{
						xtype : 'panel',
				        layout:'column',
				        border: false,
				        defaults : {
			    			labelAlign : 'right',
			    			labelWidth: 100,
				        	margin: '6'
				    	},
			    		items: [{
		        			xtype:'textfield',
							fieldLabel:'用户名',
							name:'userName',
							allowBlank: false,
							width:270,
			        		length: 20,
			        		vtypeText : '用户名最多可输入20个字符',
			        		vtype: 'limitLen'
						},{
		        			xtype:'label',
		        			text:'同员工姓名',
		        			margin: '8 6 6 6',
							name:'lblsamename',
							width:270,
							cls: 'link'
						}]
					},{
						xtype : 'panel',
				        layout:'column',
					    border: false,
				        defaults : {
			    			labelAlign : 'right',
			    			labelWidth: 100,
				        	margin: '6'
				    	},
			    		items: [{
			        		xtype:'textfield',
							fieldLabel:'密码',
							name:'password',
							inputType : 'password',
							allowBlank: false,
							width:270,
			        		length: 16,
			        		vtypeText : '密码最多可输入16个字符',
			        		vtype: 'password'
			       		},{
			        		xtype:'textfield',
							fieldLabel:'确认密码',
							name:'confirmPwd',
							inputType : 'password',
							allowBlank: false,
							width:270,
			        		length: 16,
			        		vtypeText : '确认密码最多可输入16个字符，且必须与密码一致',
			        		vtype: 'password',
			        		compareTo: 'password'
			       		}]
					}]
			     }]
			}]
		}],
		this.fbar = [{
    		xtype: 'button',
        	margin: '6',
        	text: '保存',
        	name: 'btn-save',
			iconCls: 'btn-save'
    	},{
    		xtype: 'button',
        	margin: '6',
        	text: '取消',
        	name: 'btn-cancel',
        	iconCls: 'btn-cancel',
        	scope: this,
        	handler: this.close
		}];
		this.callParent(arguments);
	}
});