/**
 * 员工信息管理view.
 * @author 高元称
 * @version 1.0.0, 2015-07-10
 */
Ext.define('WMS.view.systemservice.StaffSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.staffsearchview',
	id: 'staffsearchview',
	resizable : false,
	closeAction : 'hide',
	multiSelect : true,
	loadMask : true,
	layout:'fit',
	requires: [
  	    'WMS.store.baseinfo.StaffViewStr'
    ],
  	stores:[
        'WMS.store.baseinfo.StaffViewStr'
   	],
   	models:[
   	    'WMS.model.baseinfo.StaffViewMdl'
   	],
	 
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
			    	xtype:'textfield',
					fieldLabel:'员工姓名',
					name:'staffName',
					width:250,
	        		length: 20,
	        		vtypeText : '员工姓名最多可输入20个字符',
	        		vtype: 'limitLen'
		   		},{
					xtype:'textfield',
					fieldLabel:'工号',
					name:'jobNumber',
					width:250,
	        		length: 20,
	        		vtypeText : '工号最多可输入20个字符',
	        		vtype: 'limitLen'
				},{
			    	xtype:'combobox',
					fieldLabel:'部门',
					name:'deptId',
					width:250,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 10);
    	                }
    	            },
					editable: false,
					value: -1,
					queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 8,
		            	 	status: -1
		            	},
		            	url: 'dict/getDictList.action',
		            	hasEmptyItem: true
		            })
				},{
		    		border:false
		    	},{
		    		xtype:'checkbox',
		    		boxLabel:'<span>显示禁用项</span><img data-qtip="选中时显示所有查询条件（下拉框项）中已禁用的项，<br/>查询结果中包含已禁用项的结果；未选中时不显示" src="images/hint.png" class="hintico">',
		    		name: 'showForbidden',
		    		checked: true
		    	}]	
			},{
				xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 70,
	        	 	margin: 6
				},
				items:[{
					xtype:'combobox',
					fieldLabel:'组别',
					name:'groupId',
					width:250,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 10);
    	                }
    	            },
					value: -1,
					queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 10,
		            	 	status: -1
		            	},
		            	url: 'dict/getDictList.action',
		            	hasEmptyItem: true
		            })
				},{
				    xtype:'combobox',
				    fieldLabel:'职级',
				    editable: false,
				    name:'rankId',
				    width:250,
				    value: -1,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 10);
    	                }
    	            },
					queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 9,
		            	 	status: -1
		            	},
		            	url: 'dict/getDictList.action',
		            	hasEmptyItem: true
		            })
				},{
			        xtype:'textfield',
					fieldLabel:'联系电话',
					name:'tel',
					width:250,
	        		length: 50,
	        		vtypeText : '联系电话最多可输入50个字符,且只能输入字符或数字',
	        		vtype: 'phone'
		   		}]
		   	},{
		   		xtype: 'panel',
				bodyStyle:'background:#E8E8E8;',
				layout : 'column',
				border:false,
			    defaults : {
    			 	labelAlign : 'right',
    			 	labelWidth : 70,
	        	 	margin: 6
				},
				items:[{
			    	xtype:'textfield',
					fieldLabel:'用户名',
					name:'userName',
					width:250,
	        		length: 20,
	        		vtypeText : '用户名最多可输入20个字符',
	        		vtype: 'limitLen'
		   		},{
				    xtype:'combobox',
				    fieldLabel:'状态',
				    editable: false,
				    name:'status',
				    width :250,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.StatusStr'),
		            value: '-1'
				},{
			    	xtype:'button',
			    	width: 70,
			    	margin: '6 6 6 20',
			    	text:'查询',
			    	name:'btn-search',
					iconCls : 'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 70,
			    	text:'重置',
			    	name:'btn-clear',
					iconCls : 'btn-clear'
	   			}]	
		   	}]
		};
		
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 70,
			 	margin: 6
			},
			items:[{
				xtype : 'button',
				text : '添加',
				name : 'btn-add',
				iconCls : 'btn-add'
			}, {
				xtype : 'button',
				text : '删除',
				name : 'btn-delete',
				iconCls : 'btn-delete'
			}, {
				xtype : 'button',
				text : '导入',
				name : 'btn-import',
				iconCls: 'btn-import'
			}, {
				xtype:'button',
				text:'导出',
				name:'btn-export',
				iconCls: 'btn-export'
			},{
				xtype:'button',
				text:'启用',
				name:'btn-openStatus',
				iconCls: 'btn-openStatus'
			}, {
				xtype:'button',
				text:'禁用',
				name:'btn-closeStatus',
				iconCls: 'btn-closeStatus'
			}]
	    };
		
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列  将序列号从40改为60  彭婷婷
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:left", align:'center'
	      	}),
	      	{ text: '员工姓名', dataIndex: 'staffName', width:100,style :"text-align:left",align:'left'},
		    { text: '工号', dataIndex: 'jobNumber', width:100,style :"text-align:left",align:'left'},
		    { text: '部门', dataIndex: 'deptName', style :"text-align:left", width:120,  align:'left'},
		    { text: '组别', dataIndex: 'groupName', width:120, style :"text-align:left", align:'left'},
		    { text: '职级', dataIndex: 'rankName', style :"text-align:left", width:120,  align:'left'},
		    { text: '联系电话', dataIndex: 'tel', style :"text-align:left", width:100,  align:'left'},
		    { text: '入职日期', dataIndex: 'entryTime', width:90, style :"text-align:center", align:'left'},
		    { text: '用户名', dataIndex: 'userName', style :"text-align:left", width:80,  align:'left'},
		    { text: '最后登录IP', dataIndex: 'lastLoginIP', style :"text-align:center", width:100,  align:'left'},
		    { text: '最后登录时间', dataIndex: 'lastLoginTime', style :"text-align:center", width:140,  align:'left'},
		    { text: '工作内容', dataIndex: 'workContent', hidden: true},
		    { text: '负责人', dataIndex: 'leader', hidden: true},
		    { text: '状态', dataIndex: 'displayStatus', width:50, style :"text-align:center",  align:'left'},
		    ACBEE.Ext.Util.createEditBtn(this.functionCodes)
	    ];
		
		return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '没有符合条件的员工信息！',
			store : Ext.create('WMS.store.baseinfo.StaffViewStr', {
				url: 'staff/searchStaffViewPage.action'
			}),
			/********
			 * 2015/12/26
			 * 王玉涛
			 * bug745
			 */
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
	listeners: {
		//panel渲染后事件
		afterrender: function(view, eOpts) {
    		//绑定分页栏的store为grid的store
    		view.down('pagingtoolbar').bindStore(view.getStore());
    	}
    }
});
