/**
 * 供应商列表view.
 * @author 高元称
 * @version 1.0.0, 2015-08-26
 */
/**
 * 预约入库信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.view.transferstock.SupplierListView', {
	extend : 'Ext.window.Window',
	alias : 'widget.supplierlistview',
	resizable : false,
	header: false,
	constrain: true,
	closeAction : 'hide',
	width : 210,
	height : 300,
	layout : 'fit',
	modal : true,
	stores:[
	    'WMS.store.common.StockSupplierStr'
	],
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createSupplierInfo()
			]
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '3',
        	text : '确定',
        	name : 'btn-sure',
        	iconCls: 'btn-save'
    	},{
    		xtype : 'button',
        	margin : '3',
        	text : '取消',
        	name : 'btn-cancel',
        	iconCls: 'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	},
	//供应商列表
	createSupplierInfo : function(){
		var supplierInfo={
			xtype : 'grid',
			border : false,
			height : 295,
			store : 'WMS.store.common.StockSupplierStr',
			columns : this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		};
		return supplierInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
			new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'left'
	      	}),
	      	{text: '供应商名称', dataIndex: 'supplierName', width:150,style :"text-align:center",align:'left'},
	      	{text: '供应商Id', dataIndex: 'supplierId', hidden : true}
		];
		return columns;		
	}
});

