/**
 * 预约调拨信息编辑view.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-21
 */

Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.define('WMS.view.transferstock.TransferStockDemandBillEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.transferstockdemandbilleditview',
	id :'transferstockdemandbilleditview',
	title : '预约调拨信息编辑',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	width : 830,
	height : 665,
	layout : 'fit',
	modal : true,
	requires : [
		'Ext.ux.form.DateTimeField'
	],
	stores:[
	    'WMS.store.transferstock.TransferStockDemandBillItemGoodsViewStr',
	    'WMS.store.stock.StockViewStr'
	],
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createInstockDemand(),
				this.createGoodsInfo()
			]	
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '5',
        	text : '保存',
        	name : 'btn-save',
        	iconCls:'btn-save'
    	},{
    		xtype : 'button',
        	margin : '5',
        	text : '打印',
        	name : 'btn-print'
    	},{
    		xtype : 'button',
        	margin : '5',
        	text : '取消',
        	name : 'btn-cancel',
        	iconCls:'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	},
	//创建预约入库编辑form
	createInstockDemand : function(){
		var instockDemand={
			xtype : 'form',
			border : false,
			margin : '10',
			items : [{
			    xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '5'
		    	},
		    	items : [{
	        		xtype : 'textfield',
	        		width : 250,
	        		labelWidth : 80,
	        		name : 'demandNo',
	        		allowBlank : false,
	        		fieldLabel : '调拨需求号',
	        		readOnly : true,
	        		allowBlank : false,
	        		length:15,
	        		vtypeText : '调拨需求号最多可输入15个字符<br>调拨需求号不能输入中文',
        		    vtype: 'exceptChinese'
				},{
					xtype : 'datefield',
	        		width : 240,
	        		labelWidth : 70,
	        		name : 'appointmentDate',
	        		allowBlank : false,
	        		fieldLabel : '预约日期',
	        		allowBlank : false,
					format : "Y-m-d",
					length:10,
	        		vtypeText:'预约日期必须早于早于计划调拨时间',
	        		vtype: 'date'
				},{
		    		xtype : 'datetimefield',
	        		width : 267,
	        		labelWidth : 95,
	        		name : 'planTransferTime',
	        		allowBlank : false,
	        		fieldLabel : '计划调拨时间',
					format : "Y-m-d",
					length:19,
					vtype:'datetime',
					compareToDate: true,
					compareTo: 'appointmentDate',
					vtypeText : '计划调拨时间必须晚于预约日期'
		    	}]
			},{
				xtype:'panel',
				layout : 'column',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
	        		xtype : 'textfield',
	        		width : 250,
	        		labelWidth : 80,
	        		name : 'pickupCompany',
	        		allowBlank : true,
	        		fieldLabel : '提货公司',
	        		length:100,
	        		vtypeText : '提货公司最多可输入100个字符',
        		    vtype: 'limitLen'
				},{
	        		xtype : 'textfield',
	        		width : 237,
	        		labelWidth : 67,
	        		name : 'vehicleNo',
	        		allowBlank : true,
	        		fieldLabel : '车辆号码',
	        		length:10,
	        		/**
	        		 * @author 李树雪 2015年12月22日 上午17.24
	        		 * @bug 717
	        		 * @code:139-145
	        		 */
	        		vtypeText : '车辆号码格式不对，应该以汉字开头，后面是6位数字或字母。<br><br>如：京A00000',
        		    vtype: 'checkNumber'
				},{
	        		xtype : 'textfield',
	        		width : 265,
	        		labelWidth : 93,
	        		name : 'pickupPerson',
	        		allowBlank : true,
	        		fieldLabel : '提货人',
        			length:20,
	        		vtypeText : '提货人最多可输入20个字符<br>提货人不能输入数字',
        		    vtype: 'exceptNumber'
				}]
			},{
				xtype:'panel',
				layout : 'column',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
		    		xtype:'combobox',
				    fieldLabel:'调拨原因',
				    editable: false,
				    name:'transferCause',
	        		width : 250,
	        		labelWidth : 80,
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 8);
    	                }
    	            },
	        		allowBlank : false,
	        		queryMode: 'remote',
		            displayField: 'dictName',
		            emptyText: "--请选择--",
		            valueField: 'dictId',
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
		            		dictType: 6,
		            		status: 1
		            	},
		            	url: 'dict/getDictList.action'   
		            }).load()
		    	},{
		    		xtype : 'label',
			        margin: '10 0 0 25',
	        		width : 80,
	        		text : '货物总数量：'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 0',
			        name: 'totalQuantity',
			        width: 50
				},{
		    		xtype : 'label',
			        margin: '10 0 0 0',
	        		width : 80,
	        		text : '货物总金额：'
		    	},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 0',
			        name: 'totalPrice',
			        width: 80
				}]
			},{
				xtype:'panel',
				layout : 'column',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					border:false
				},{
					xtype:'fieldset',
					title:'调拨出',
					width:'44%',
					height:150,
					defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    style:'margin-left:47px'
					},
					items:[{
			    		xtype:'combo',
					    fieldLabel:'库区',
					    name:'outAreaId',
					    emptyText: "--选择或输入--",  
					    allowBlank : false,
		        		width : 230,
		        		labelWidth : 60,
		        		forceSelection: true,
		        		editable: true,
	        			queryMode: 'remote',
			            displayField: 'areaName',
			            valueField: 'areaId',
			        	listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
	    	                }
	    	            },
			            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
			            	params:{
			            	 	areaNature: -1,
			            	 	status : 1
			            	},
			            	url: 'warehouseArea/getWarehouseAreaList.action'        	
			            }).load() //bug737.  李树雪2015.12.29.   添加个.load(),下面303.364.411行，同理
		    		},{
		    			xtype : 'panel',
						layout : 'column',
						border : false,
						defaults : {
						    labelAlign : 'right',
						    labelWidth : 70,
						    margin : 6
						},
						items:[{
			        		xtype : 'label',
			        		width : 70,
			        		name : 'outAreaNatureLabel',
			        		text : '库区性质:',
			        		margin : '10 0 0 -10',
			        		style: 'text-align: right;'
						},{
			        		xtype : 'displayfield',
			        		width : 163,
			        		name : 'outAreaNature1'
						}]
					},{
				    	xtype:'combo',
					    fieldLabel:'库位号',
					    name:'outLocationId',
					    emptyText: "--选择或输入--",
					    allowBlank : false,
		        		width : 230,
		        		labelWidth : 60,
		        		editable: true,
		        		forceSelection: true,
		        		queryMode: 'remote',
			            displayField: 'locationNo',
			            valueField: 'locationId',
			        	listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 10);
	    	                }
	    	            },
			            store: Ext.create('WMS.store.baseinfo.WarehouseLocationStr',{
			            	params:{
			            	 	areaId: -1,
			            	 	areaNature:-1,
			            	 	status : 1
			            	},
			            	url: 'warehouseLocation/getWarehouseLocationViewList.action'        	
			            }).load()
					},{
		    			xtype : 'panel',
						layout : 'column',
						border : false,
						defaults : {
						    labelAlign : 'right',
						    labelWidth : 70,
						    margin : 6
						},
						items:[{
		        		xtype : 'label',
		        		width : 70,
		        		name : 'outLocationNatureLabel',
		        		text : '库位性质:',
		        		style: 'text-align: right;',
		        		margin : '10 0 0 -10'
					},{
						xtype : 'displayfield',
		        		width : 163,
		        		name : 'outLocationNature1'
					}]
					}]
				},{
				 border:false,
				 width:38
				},{
					xtype:'fieldset',
					title:'调拨入',
					width:'44%',
					height:150,
					defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    style:'margin-left:47px'
					},
					items:[{
			    		xtype:'combo',
					    fieldLabel:'库区',
					    editable: true,
					    forceSelection: true,
					    name:'inAreaId',
		        		width : 230,
		        		labelWidth : 60,
		        		emptyText: "--选择或输入--",
	        			queryMode: 'remote',
			            displayField: 'areaName',
			            allowBlank : false,
			            valueField: 'areaId',
			        	listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
	    	                }
	    	            },
			            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
			            	params:{
		            			areaId: -1,
			            	 	areaNature: -1,
			            	 	status : 1
			            	},
			            	url: 'warehouseArea/getWarehouseAreaList.action'        	
			            }).load()
		    		},{
		    			xtype : 'panel',
						layout : 'column',
						border : false,
						defaults : {
						    labelAlign : 'right',
						    labelWidth : 70,
						    margin : 6
						},
						items:[{
		        		xtype : 'label',
		        		width : 70,
		        		name : 'inAreaNatureLabel',
		        		text : '库区性质:',
		        		style: 'text-align: right;',
		        		margin : '10 0 0 -10'
					},{
		        		xtype : 'displayfield',
		        		width : 163,
		        		name : 'inAreaNature2'
					}]
					},{
				    	xtype:'combo',
					    fieldLabel:'库位号',
					    editable: true,
					    forceSelection: true,
					    name:'inLocationId',
		        		width : 230,
		        		labelWidth : 60,
						listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 10);
	    	                }
	    	            },
		        		emptyText: "--选择或输入--",
		        		allowBlank : false,
		        		queryMode: 'remote',
			            displayField: 'locationNo',
			            valueField: 'locationId',
			            store: Ext.create('WMS.store.baseinfo.WarehouseLocationStr',{
			            	params:{
			            	 	areaId: -1,
			            	 	areaNature:-1,
			            	 	status : 1
			            	},
			            	url: 'warehouseLocation/getWarehouseLocationViewList.action'        	
			            }).load()
					},{
		    			xtype : 'panel',
						layout : 'column',
						border : false,
						defaults : {
						    labelAlign : 'right',
						    labelWidth : 70,
						    margin : 6
						},
						items:[{
		        		xtype : 'label',
		        		width : 70,
		        		name : 'inLocationNatureLabel',
		        		text : '库位性质:',
		        		style: 'text-align: right;',
		        		margin : '10 0 0 -10'
					},{
						xtype : 'displayfield',
		        		width : 163,
		        		name : 'inLocationNature2'
					}]
					}]	
				}]
			}]
		};
		return instockDemand;
	},
	//创建预约入库货物明细
	createGoodsInfo : function(){
		var goodsInfo={
			xtype : 'grid',
			border : false,
			height : 290,
			columns : this.createColumns(),
			selModel:Ext.create('Ext.selection.RowModel',{mode:"SIMPLE"}),
			store :  'WMS.store.transferstock.TransferStockDemandBillItemGoodsViewStr',
			plugins:[
					Ext.create('Ext.grid.plugin.CellEditing', {
						clicksToEdit: 1 //设置单击单元格编辑  
					})  
				],
			listeners : {
				beforeedit : function(editor, e, eOpts){
					if(this.up('window').oldTransferstockDemandBillId!=0 && this.up('window').status){
						var goodsCode = e.record.data.goodsCode;
						e.cancel = (null == goodsCode || "" == goodsCode ? false : true);
					}
				},
				edit:function(editor,e){
					if(1 == e.colIdx){
						var goodsCode = this.down('textfield[name=goodsCode]').getValue();
						ACBEE.Ext.Util.ajaxRequest("goods/searchGoodsByGoodsCode.action",{goodsCode:goodsCode},function(result){
							if(true == result.success){
								e.record.data.goodsCode = result.map.goodsCode;
								e.record.data.goodsName = result.map.goodsName;
								e.record.data.price = result.map.price;
		                		e.record.data.goodsId = result.map.goodsId;
							} else {
								ACBEE.Ext.Util.showAlertBox(result.msg);
								e.record.data.goodsCode = '';
								e.record.data.goodsName = '';
								e.record.data.price = '';
								e.record.data.goodsId = '';
								e.record.data.planArrivalQuantity = '';
								e.record.data.productBatch = '';
								e.record.data.supplierId = '';
							}
							e.record.commit();
						});
					}
				}
			},
		 	fbar:[{
		        	xtype : 'button',
		        	margin : '5',
		        	text : '添加',
		        	name : 'btn-add',
		        	iconCls:'btn-add'
	        	},{
		        	xtype : 'button',
		        	margin : '5',
		        	text : '导入',
		        	name : 'btn-import',
		        	iconCls:'btn-import'
	        	},{
		        	xtype : 'button',
		        	margin : '5',
		        	text : '导出',
		        	name : 'btn-export',
		        	iconCls:'btn-export'
	        	},{
		        	xtype : 'button',
		        	margin : '5',
		        	text : '删除',
		        	name : 'btn-delete',
		        	iconCls:'btn-delete'
	        	},'->'
        	]
		};
		return goodsInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
  		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'left'
	      	}),
	      	{text: '货物号', dataIndex: 'goodsCode', width:100,style :"text-align:center",align:'left',field:{
      	    	allowBlank: false,
	      		length:20,
        		vtypeText : '货物号最多可输入20个字符',
    		    vtype: 'exceptChinese'
	      	}},
		    { text: '品名', dataIndex: 'goodsName', width:100,style :"text-align:center",align:'left'},
		    { text: '生产批号', dataIndex: 'productBatch', width:100, style :"text-align:center", align:'left'},
		    { text: '货物Id', dataIndex: 'goodsId', width:100,style :"text-align:center",align:'left',hidden: true},
		    { text: '计划调拨数量', dataIndex: 'planTransferQuantity', width:100, style :"text-align:center", align:'left',field:{
      			allowBlank: true,
	      		length:15,
        		vtypeText : '计划调拨数量最多可输入15个字符<br>计划调拨数量只能输入正整数',
    		    vtype: 'currency'
	      	}},
		    { text: '单价', dataIndex: 'price', width:100, style :"text-align:center",  align:'left'},
		    { text: '金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'left',
		    renderer:function(value,metaData,record,rowIndex,colIndex,store){
	        	var planTransferQuantity = (null == record.data.planTransferQuantity ? 0 : record.data.planTransferQuantity);
	  	    	var price =(null == record.data.price ? 0 : record.data.price);
	  	    	
	  	    	record.data.totalPrice = (planTransferQuantity*10000) * (price*10000)/100000000;
	  	        return (planTransferQuantity*10000) * (price*10000)/100000000;
        	}},
		    { text: '供应商名称', dataIndex: 'supplierName', width:120, style :"text-align:center",  align:'left'}
		];
		return columns;		
	}
});