/**
 * 预约调拨信息管理view.
 * @author 苏亚欣
 * @version 1.0.0, 2015-07-20
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.define('WMS.view.transferstock.TransferStockDemandBillSearchView', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.transferstockdemandbillsearchview',
	id: 'transferstockDemandbillsearchview',
	resizable : false,
	closeAction : 'hide',
	multiSelect : true,
	loadMask : true,
	layout:'fit',
	requires : [
		'WMS.store.transferstock.TransferStockDemandBillStr',
		'Ext.ux.form.DateTimeField'
	],
	models : [
		'WMS.model.cancelstock.CancelStockDemandBillMdl'
	],
	stores : [
		'WMS.store.transferstock.TransferStockDemandBillStr'
	],
	 
	/**
	 * 创建查询条件面板
	 */
	createSearchConditionPanel : function(){
		var scPanel = {
			xtype:'form',
			border: 1,
			width:'100%',
			items:[{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					xtype:'textfield',
					fieldLabel:'调拨需求号',
					name:'demandNo',
					labelWidth:120,
					width:280,
					length:15,
	        		vtypeText : '调拨需求号最多可输入15个字符<br>调拨需求号不能输入中文',
        		    vtype: 'exceptChinese'
				},{
			        xtype:'datefield',
					fieldLabel:'预约开始日期',
					name:'transferBillBeginDate',
					labelWidth:120,
					width:280,
					format : "Y-m-d",
					length:10,
	        		vtypeText:'预约开始日期必须早于或等于预约结束日期',
	        		vtype: 'date'
		  		},{
			        xtype:'datefield',
					fieldLabel:'预约结束日期',
					name:'transferBillEndDate',
					labelWidth:120,
					width:280,
					format : "Y-m-d",
					length:10,
	        		vtypeText:'预约结束日期必须晚于或等于预约开始日期',
	        		vtype: 'date',
	        		compareTo:'transferBillBeginDate'
		    	}]	
			},{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
						xtype:'combobox',
						fieldLabel:'调拨原因',
						name:'transferCause',
						labelWidth:120,
						width:280,
						listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
	    	                }
	    	            },
						editable: false,
						queryMode: 'remote',
			            displayField: 'dictName',
			            valueField: 'dictId',
			            value : -1,
			            store: Ext.create('WMS.store.common.DictStr',{
			            	params:{
			            		dictType: 6,
			            		status: -1
			            	},
			            	hasEmptyItem: true,
			            	url: 'dict/getDictList.action'   
			            }).load()
					},{
				        xtype:'datetimefield',
						fieldLabel:'计划调拨开始时间',
						name:'planTransferBeginTime',
						labelWidth:120,
						width:280,
						format : "Y-m-d",
						length:19,
						vtype:'datetime',
						vtypeText : '计划调拨开始时间必须早于计划调拨结束时间'
			    	},{
				        xtype:'datetimefield',
						fieldLabel:'计划调拨结束时间',
						name:'planTransferEndTime',
						labelWidth:120,
						width:280,
						format : "Y-m-d",
						vtype:'datetime',
						length:19,
						compareTo:'planTransferBeginTime',
						vtypeText : '计划调拨结束时间必须晚于计划调拨开始时间。'
			    	}]
			},{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					xtype:'combobox',
					fieldLabel:'调拨出-库区',
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					name:'outAreaId',
					labelWidth:120,
					width:280,
					editable: false,
					queryMode: 'remote',
		            displayField: 'areaName',
		            valueField: 'areaId',
		            value : -1,
		            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
		            	params:{
		            	 	areaNature: -1,
		            	 	status : -1
		            	},
		            	hasEmptyItem: true,
		            	url: 'warehouseArea/getWarehouseAreaList.action'        	
		            }).load()
				},{
					xtype:'combobox',
					fieldLabel:'调拨出-库区性质',
					name:'outAreaNature',
					labelWidth:120,
					width:280,
					editable: false,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.AreaNatureStr'),
		            value: '-1'
				},{
					xtype:'combobox',
					fieldLabel:'调拨状态',
					name:'status',
					labelWidth:120,
					width:280,
					editable: false,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.TransferStatusStr'),
		            value: '-1'
				}]
			},{
				xtype:'panel',
				layout : 'column',
				bodyStyle:'background:#E8E8E8;',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					xtype:'combobox',
					fieldLabel:'调拨入-库区',
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
    	                }
    	            },
					name:'inAreaId',
					labelWidth:120,
					width:280,
					editable: false,
					queryMode: 'remote',
		            displayField: 'areaName',
		            valueField: 'areaId',
		            value : -1,
		            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
		            	params:{
		            	 	areaNature: -1,
		            	 	status : -1
		            	},
		            	hasEmptyItem: true,
		            	url: 'warehouseArea/getWarehouseAreaList.action'        	
		            }).load()
				},{
					xtype:'combobox',
					fieldLabel:'调拨入-库区性质',
					name:'inAreaNature',
					labelWidth:120,
					width:280,
					editable: false,
					displayField: 'name',
		            valueField: 'value',
	            	store: Ext.create('WMS.store.common.AreaNatureStr'),
		            value: '-1'
				},{
		    		border:false
		    	},{
		    		xtype:'checkbox',
		    		boxLabel:'显示禁用项',
		    		boxLabel:'<span>显示禁用项</span><img data-qtip="选中时显示所有查询条件（下拉框项）中已禁用的项，<br/>查询结果中包含已禁用项的结果；未选中时不显示" src="images/hint.png" class="hintico">',
		    		name: 'showForbidden',
		    		checked: true
		    	},{
		   			border:false
		   		},{
			    	xtype:'button',
			    	width: 60,
			    	text:'查询',
			    	name:'btn-search',
			    	iconCls:'btn-search'
		    	},{
			    	xtype:'button',
			    	width: 60,
			    	text:'重置',
			    	name:'btn-clear',
			    	iconCls:'btn-clear'
	   			}]	
			}]
		};
		
		return scPanel;
	},
	/**
	 * 创建功能按钮面板
	 */
	createButtonPanel: function() {
		var buttonPanel = {
		    xtype : 'panel',
			border : false,
			layout : 'column',
		    defaults : {
			 	width: 60,
			 	margin: 6
			},
			items:[{
				xtype : 'button',
				text : '编制',
				name : 'btn-drawUp',
				iconCls:'btn-drawUp'
			},{
				xtype : 'button',
				text : '删除',
				name : 'btn-delete',
				iconCls:'btn-delete'
			}]
	    };
		return buttonPanel;
	},
	/**
	 * 创建顶部面板（包括查询条件和按钮）
	 */
	createTBar: function() {
		return {
			xtype:'panel',
			width:'100%',
			border:false,
			margin: 1,
			items:[
			    //查询条件面板
			    this.createSearchConditionPanel(),
			    //功能按钮面板
			    this.createButtonPanel()
			]
		};
	},
	//创建表格列  bug:632 将序号宽度从40改为60  彭婷婷
	createColumns:function(){
		var columns = [
		    new Ext.grid.RowNumberer({
	      		header:"序号", width:60, style :"text-align:left", align:'center'
	      	}),
	      	{ text: '调拨需求号', dataIndex: 'demandNo', width:150,style :"text-align:center",align:'left'},
		    { text: '预约日期', dataIndex: 'appointmentDate', width:150,style :"text-align:center",align:'center'},
		    { text: '计划调拨时间', dataIndex: 'planTransferTime', style :"text-align:center", width:150,  align:'center'},
		    { text: '提货公司', dataIndex: 'pickupCompany', width:150, style :"text-align:center", align:'left'},
		    { text: '车辆号码', dataIndex: 'vehicleNo', width:150, style :"text-align:center", align:'left'},
		    { text: '提货人', dataIndex: 'pickupPerson', width:150, style :"text-align:center", align:'left'},
		    { text: '调拨原因', dataIndex: 'transferCauseName', width:150, style :"text-align:center",  align:'left'},
		    { text: '调拨出-库区名称', dataIndex: 'warehouseareaoutName', width:150, style :"text-align:center",  align:'left'},
		    { text: '调拨出-库区性质', dataIndex: 'outAreaNature', style :"text-align:center", width:150,  align:'left'},
		    { text: '调拨出-库位号', dataIndex: 'outLocationNo', style :"text-align:center", width:150,  align:'left'},
		    { text: '调拨出-库位性质', dataIndex: 'outLocationNature', style :"text-align:center", width:150,  align:'left'},
		    { text: '调拨入-库区名称', dataIndex: 'warehouseareaName', style :"text-align:center", width:150,  align:'left'},
		    { text: '调拨入-库区性质', dataIndex: 'inAreaNature', style :"text-align:center", width:150,  align:'left'},
		    { text: '调拨入-库位号', dataIndex: 'inLocationNo', style :"text-align:center", width:150,  align:'left'},
		    { text: '调拨入-库位性质', dataIndex: 'inLocationNature', style :"text-align:center", width:150,  align:'left'},
		    { text: '货物总数量', dataIndex: 'totalQuantity', width:100, style :"text-align:center",  align:'left'},
		    { text: '货物总金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'left'},
		    { text: '调拨状态', dataIndex: 'displayStatus', style :"text-align:center", width:150,  align:'center'},
		      ACBEE.Ext.Util.createEditBtn(this.functionCodes)
		];
			return columns;		
	},
	initComponent:function(){
		Ext.apply(this, {
			emptyText: '---没有符合条件的预约调拨信息！---',
			store: Ext.create('WMS.store.transferstock.TransferStockDemandBillStr',{
				params : {
					flag : 0
				}
			}),
			/********
			 * 2015/12/26
			 * 王玉涛
			 * bug745
			 */
			selModel:new Ext.selection.CheckboxModel({checkOnly:false}),
			tbar: this.createTBar(),
			columns: this.createColumns(),
			bbar: {
		        xtype: 'pagingtoolbar',
		        pageSize: 25,
		        displayInfo: true
		    }
		});
		this.callParent(arguments);
	},
	listeners:{
		//panel显示事件
		afterrender:function(view,eOpts){
			//绑定分页栏的store为grid的store
			view.down('pagingtoolbar').bindStore(view.getStore());
			
		}
	}
});