/**
 * 调拨操作信息编辑view.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.Loader.setPath('Ext.ux', 'plugins/extjs4.2.1/ux/');

Ext.define('WMS.view.transferstock.TransferstockDemandBillItemEditView', {
	extend : 'Ext.window.Window',
	alias : 'widget.transferstockbilleditview',
	title : '调拨操作信息编辑',
	resizable : false,
	closeAction : 'hide',
	constrainHeader:true,
	autoHeight : true,
	width : 900,
	//height : 660,
	layout : 'fit',
	modal : true,
	stores:[
	    'WMS.store.transferstock.TransferStockDemandBillItemGoodsViewStr'
	],
	requires : [
		'Ext.ux.form.DateTimeField'
	],
	initComponent : function(){
		this.items=[{
			xtype : 'panel',
			border : false,
			items : [
				this.createInstockDemand(),
				this.createGoodsInfo()
			]	
		}];
		this.fbar = [{
    		xtype : 'button',
        	margin : '5',
        	text : '保存',
        	name : 'btn-save',
        	iconCls:'btn-save'
    	},{
    		xtype : 'button',
        	margin : '5',
        	text : '取消',
        	name : 'btn-cancel',
        	iconCls:'btn-cancel',
        	scope : this,
        	handler : this.close
    	}];
		this.callParent(arguments);
	},
	//创建调拨操作编辑form
	createInstockDemand : function(){
		var instockDemand={
			xtype : 'form',
			border : false,
			margin : '10',
			items : [{
			    xtype : 'panel',
		        layout :'column',
			    border : false,
		        defaults : {
	    			labelAlign : 'right',
	    			labelWidth : 70,
		        	margin : '5'
		    	},
		    	items : [{
	        		xtype : 'label',
	        		width : 70,
	        		stylr:'text-align: right;',
	        		margin:'10 0 0 50',
	        		name : 'demandNoLabel',
	        		text : '调拨需求号:'
				},{
		    		xtype: 'displayfield',
		    		margin: '5 0 0 5',
			        name: 'demandNo',
			        width:145
				},{
					xtype : 'label',
	        		width : 90,
	        		margin:'10 0 0 10',
	        		style: 'text-align:right;',
	        		name : 'appointmentDateLabel',
	        		text : '预约日期:'
				},{
					xtype: 'displayfield',
					width : 145,
					name: 'appointmentDate',
					margin:'5 0 0 5'
				},{
		    		xtype : 'label',
	        		width : 86,
	        		name : 'planTransferTimeLabel',
	        		margin:'10 0 0 15',
	        		style:'text-align:right;',
	        		text : '计划调拨时间:'
		    	},{
		    		xtype:'displayfield',
		    		width:145,
		    		name:'planTransferTime',
		    		margin:'5 0 0 5'
		    	}]
			},{
				xtype:'panel',
				layout : 'column',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
	        		xtype : 'label',
	        		width : 70,
	        		style:'text-align:right;',
	        		margin:'10 0 0 50',
	        		name : 'pickupCompanyLabel',
	        		text : '提货公司:'
				},{
					xtype:'displayfield',
					margin:'5 0 0 5',
					width:145,
					name:'pickupCompany'
				},{
	        		xtype : 'label',
	        		width : 90,
	        		style:'text-align:right;',
	        		margin:'10 0 0 10',
	        		name : 'vehicleNoLable',
	        		text : '车辆号码:'
				},{
					xtype:'displayfield',
					width:145,
					margin:'5 0 0 5',
					name:'vehicleNo'
				},{
		    		xtype : 'datetimefield',
	        		width : 235,
	        		margin:'10 0 0 0',
	        		labelWidth : 100,
	        		style:'text-align:right;',
	        		name : 'actualTransferTime',
	        		allowBlank : false,
	        		fieldLabel : '实际调拨时间',
					format : "Y-m-d",
					length:19,
					vtype:'datetime',
					vtypeText : '实际调拨时间最多可输入19位字符'
		    	}]
			},{
				xtype:'panel',
				layout : 'column',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
	        		xtype : 'label',
	        		width : 70,
	        		margin:'10 0 0 50',
	        		style:'text-align:right;',
	        		name : 'pickupPersonLabel',
	        		text : '提货人:'
				},{
					xtype:'displayfield',
					width:145,
					name:'pickupPerson',
					margin:'5 0 0 5'
				},{
		    		xtype:'label',
				    text:'调拨原因:',
				    name:'transferCauseLabel',
				    style:'text-align:right;',
				    margin:'10 0 0 10',
	        		width : 90
		    	},{
		    		xtype:'displayfield',
		    		width:145,
		    		margin:'5 0 0 5',
		    		name:'transferCauseName'
		    	},{
	        		xtype : 'combobox',
	        		width : 235,
	        		labelWidth : 90,
	        		margin:'5 0 0 7',
	        		name : 'actualTransferstockGroup',
				    labelAlign : 'right',
	        		fieldLabel : '实际调拨组:',
					listConfig: {
    	            	getInnerTpl: function(displayField) {
    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 6);
    	                }
    	            },
	        		editable: false,
				    allowBlank : false,
	        		queryMode: 'remote',
		            displayField: 'dictName',
		            valueField: 'dictId',
		            emptyText: "--请选择--", 
		            store: Ext.create('WMS.store.common.DictStr',{
		            	params:{
							dictType: 10,
		            	 	status: 1
		            	},
		            	url: 'dict/getDictList.action'        	
		            }).load()
				}]
			},{
				xtype:'panel',
				layout : 'column',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
	        		xtype : 'label',
	        		width : 70,
	        		name : 'statusLable',
	        		margin:'10 0 0 50',
				    style:'text-align:right;',
	        		text : '调拨状态:'
				},{
			    	xtype:'displayfield',
					width:145,
					margin:'5 0 0 5',
					name:'displayStatus'
			    }]
			},{
				xtype:'panel',
				layout : 'column',
				border : false,
				defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    margin : 6
				},
				items:[{
					border:false
				},{
					xtype:'fieldset',
					title:'调拨出:',
					width:'44%',
					height:180,
					defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    style:'margin-left:47px'
					},
					items:[{
			    		xtype:'combobox',
			    		editable: false,
					    fieldLabel:'库区:',
					    name:'outAreaId',
		        		width : 230,
		        		labelWidth : 60,
					    name:'outAreaId',
					    readOnly : true,
			            displayField: 'areaName',
			            valueField: 'areaId',
			            listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
	    	                }
	    	            },
			            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
			            	params:{
			            	 	areaNature: -1,
			            	 	status : 1
			            	},
			            	url: 'warehouseArea/getWarehouseAreaList.action'        	
			            })
		    		},{
		    			xtype : 'panel',
						layout : 'column',
						border : false,
						defaults : {
						    labelAlign : 'right',
						    labelWidth : 70,
						    margin : 6
						},
						items:[{
			        		xtype : 'label',
			        		width : 60,
			        		name : 'outAreaNatureLable',
			        		margin : '10 0 0 0',
			        		style:'text-align:right',
			        		text : '库区性质:'
						},{
							xtype:'displayfield',
							width:145,
							name:'outAreaNature'
						}
					]},{
				    	xtype:'combobox',
					    fieldLabel:'库位号:',
					    editable: false,
					    readOnly : true,
						listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 10);
	    	                }
	    	            },
		        		width : 230,
		        		labelWidth : 60,
		        		name:'outLocationId',
					    emptyText: "--请选择--",
					    allowBlank : false,
		        		queryMode: 'remote',
			            displayField: 'locationNo',
			            valueField: 'locationId',
			            store: Ext.create('WMS.store.baseinfo.WarehouseLocationStr',{
			            	params:{
			            	 	areaId: -1,
			            	 	areaNature:-1,
			            	 	status : 1
			            	},
			            	url: 'warehouseLocation/getWarehouseLocationViewList.action'        	
			            })
					},{
		    			xtype : 'panel',
						layout : 'column',
						border : false,
						defaults : {
						    labelAlign : 'right',
						    labelWidth : 70,
						    margin : 6
						},
						items:[{
							xtype : 'label',
			        		width : 60,
			        		margin : '10 0 0 0',
			        		name : 'outLocationNatureLabel',
			        		text : '库位性质:'
						},{
							xtype:'displayfield',
							width:145,
							name:'outLocationNature'
						}]
					}]
				},{
				 border:false,
				 width:38
				},{
					xtype:'fieldset',
					title:'调拨入:',
					width:'44%',
					height:180,
					defaults : {
				    labelAlign : 'right',
				    labelWidth : 70,
				    style:'margin-left:47px'
					},
					items:[{
			    		xtype:'combobox',
					    fieldLabel:'库区:',
					    readOnly : true,
					    listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 9);
	    	                }
	    	            },
					    editable: false,
					    name:'inAreaId',
		        		width : 230,
		        		labelWidth : 60,
		        		emptyText: "--请选择--",
	        			queryMode: 'remote',
			            displayField: 'areaName',
			            allowBlank : false,
			            valueField: 'areaId',
			            store: Ext.create('WMS.store.baseinfo.WarehouseAreaStr',{
			            	params:{
			            	 	areaNature: -1,
			            	 	status : 1
			            	},
			            	url: 'warehouseArea/getWarehouseAreaList.action'        	
			            })
		    		},{
		    			xtype : 'panel',
						layout : 'column',
						border : false,
						defaults : {
						    labelAlign : 'right',
						    labelWidth : 70,
						    margin : 6
						},
						items:[{
							xtype : 'label',
			        		width : 60,
			        		name : 'inAreaNatureLabel',
			        		margin : '10 0 0 0',
			        		text : '库区性质:',
			        		style:'text-align:right;'
						},{
							xtype:'displayfield',
							name:'inAreaNature',
							width:145
						}]
					},{
				    	xtype:'combobox',
					    fieldLabel:'库位号:',
					    editable: false,
						listConfig: {
	    	            	getInnerTpl: function(displayField) {
	    	                    return ACBEE.Ext.Util.formatComboxTpl(displayField, 10);
	    	                }
	    	            },
					    name:'inLocationId',
		        		width : 230,
		        		labelWidth : 60,
		        		name:'inLocationId',
		        		emptyText: "--请选择--",
		        		allowBlank : false,
		        		 readOnly : true,
		        		queryMode: 'remote',
			            displayField: 'locationNo',
			            valueField: 'locationId',
			            store: Ext.create('WMS.store.baseinfo.WarehouseLocationStr',{
			            	params:{
			            	 	areaId: -1,
			            	 	areaNature:-1,
			            	 	status : 1
			            	},
			            	url: 'warehouseLocation/getWarehouseLocationViewList.action'        	
			            })
					},{
		    			xtype : 'panel',
						layout : 'column',
						border : false,
						defaults : {
						    labelAlign : 'right',
						    labelWidth : 70,
						    margin : 6
						},
						items:[{
							xtype : 'label',
			        		width : 60,
			        		name : 'inLocationNatureLabel',
			        		text : '库位性质:',
			        		margin : '10 0 0 0',
			        		style:'text-align:right;'
						},{
							xtype:'displayfield',
							width:145,
							name:'inLocationNature'
						}]
					}]	
				}]
			}]
		};
		return instockDemand;
	},
	//创建调拨操作货物明细
	createGoodsInfo : function(){
		var goodsInfo={
			xtype : 'grid',
			border : false,
			autoScroll : true,
			height : 232,
			store :  'WMS.store.transferstock.TransferStockDemandBillItemGoodsViewStr',
			plugins:[
					Ext.create('Ext.grid.plugin.CellEditing', {
						clicksToEdit: 1 //设置单击单元格编辑  
					})  
			],
			columns : this.createColumns()
		};
		return goodsInfo;
	},
	//创建表格列
	createColumns:function(){
		var columns = [
  		    new Ext.grid.RowNumberer({
	      		header:"序号", width:40, style :"text-align:left", align:'left'
	      	}),
	      	{text: '货物号', dataIndex: 'goodsCode', width:100,style :"text-align:center",align:'left'},
		    { text: '品名', dataIndex: 'goodsName', width:100,style :"text-align:center",align:'left'},
		    { text: '生产批号', dataIndex: 'productBatch', width:100, style :"text-align:center", align:'left'},
		    { text: '计划调拨数量', dataIndex: 'planTransferQuantity', width:100, style :"text-align:center", align:'left'},
		    { text: '实际调拨数量', dataIndex: 'actualTransferQuantity', width:100, style :"text-align:center", align:'left',field:{
	      		allowBlank: true,
	      		length:15,
        		vtypeText : '实际调拨数量最多可输入15个字符<br>实际调拨数量只能输入正整数',
    		    vtype: 'currency'
	      	}},
		    { text: '单价', dataIndex: 'price', width:100, style :"text-align:center",  align:'left'},
		    { text: '金额', dataIndex: 'totalPrice', width:100, style :"text-align:center",  align:'left',
		    renderer:function(value,metaData,record,rowIndex,colIndex,store){
	        	var planTransferQuantity = (null == record.data.planTransferQuantity ? 0 : record.data.planTransferQuantity);
	  	    	var price =(null == record.data.price ? 0 : record.data.price);
	  	    	 
	  	        return (planTransferQuantity*10000) * (price*10000)/100000000;
        	}},
		    { text: '供应商名称', dataIndex: 'supplierName', width:120, style :"text-align:center",  align:'left'},
		    { text: '下架状态', dataIndex: 'displayStatus', width:120, style :"text-align:center",  align:'left'}
		];
		return columns;		
	}
});
