local Build = select(4, GetBuildInfo())
local WotLKBuild = Build <= 30300
local AddonName, AddonTable = ...
local L = AddonTable.Localize
LibStub:GetLibrary("BigLibTimer3"):Register(AddonTable)
SpellFlashCore = {}
local FrameNames = {}
local ButtonFrames = {}
ButtonFrames.Action = {}
ButtonFrames.Pet = {}
ButtonFrames.Form = {}
ButtonFrames.Vehicle = {}
local Buttons = {}
Buttons.Spell = {}
Buttons.Macro = {}
Buttons.Item = {}
local Frames = {}
Frames.Spell = {}
Frames.Macro = {}
Frames.Item = {}
local BUTTONSREGISTERED = nil
local FRAMESREGISTERED = nil
local LOADING = true
if not SpellFlashCoreAddonConfig then
	SpellFlashCoreAddonConfig = {}
end


local COLORTABLE = {
	white = {r=1.0, g=1.0, b=1.0},
	yellow = YELLOW_FONT_COLOR,
	purple = {r=1.0, g=0.0, b=1.0},
	blue = {r=0.0, g=0.0, b=1.0},
	orange = ORANGE_FONT_COLOR,
	aqua = {r=0.0, g=1.0, b=1.0},
	green = GREEN_FONT_COLOR,
	red = RED_FONT_COLOR,
	pink = {r=0.9, g=0.4, b=0.4},
	gray = GRAY_FONT_COLOR,
}

AddonTable.PetActions = {
	Attack = "PET_ACTION_ATTACK",
	Follow = "PET_ACTION_FOLLOW",
	Stay = "PET_ACTION_WAIT",
	["Move To"] = "PET_ACTION_MOVE_TO",
	Aggressive = "PET_MODE_AGGRESSIVE",
	Defensive = "PET_MODE_DEFENSIVE",
	Passive = "PET_MODE_PASSIVE",
	PET_ACTION_ATTACK = "PET_ACTION_ATTACK",
	PET_ACTION_FOLLOW = "PET_ACTION_FOLLOW",
	PET_ACTION_WAIT = "PET_ACTION_WAIT",
	PET_ACTION_MOVE_TO = "PET_ACTION_MOVE_TO",
	PET_MODE_AGGRESSIVE = "PET_MODE_AGGRESSIVE",
	PET_MODE_DEFENSIVE = "PET_MODE_DEFENSIVE",
	PET_MODE_PASSIVE = "PET_MODE_PASSIVE",
	[PET_ACTION_ATTACK or "PET_ACTION_ATTACK"] = "PET_ACTION_ATTACK",
	[PET_ACTION_FOLLOW or "PET_ACTION_FOLLOW"] = "PET_ACTION_FOLLOW",
	[PET_ACTION_WAIT or "PET_ACTION_WAIT"] = "PET_ACTION_WAIT",
	[PET_ACTION_MOVE_TO or "PET_ACTION_MOVE_TO"] = "PET_ACTION_MOVE_TO",
	[PET_MODE_AGGRESSIVE or "PET_MODE_AGGRESSIVE"] = "PET_MODE_AGGRESSIVE",
	[PET_MODE_DEFENSIVE or "PET_MODE_DEFENSIVE"] = "PET_MODE_DEFENSIVE",
	[PET_MODE_PASSIVE or "PET_MODE_PASSIVE"] = "PET_MODE_PASSIVE",
}


local function Message(...)
	print("SpellFlashCore:", ...)
end

local function GetSpellName(GlobalSpellID, NoSubName)
	if type(GlobalSpellID) == "number" then
		local SpellName, SubName = GetSpellInfo(GlobalSpellID)
		if not WotLKBuild and not NoSubName and SubName and SubName ~= "" then
			return SpellName.."("..SubName..")"
		end
		return SpellName
	end
	return nil
end

local function GetItemName(ItemID)
	if type(ItemID) == "number" then
		return (GetItemInfo(ItemID))
	end
	return nil
end

local function BodyHasMetaTag(body)
	return body and body:match("#show") and (
		body:match("^ *#show *$")
		or body:match("\n *#show *$")
		or body:match("^ *#show *\n")
		or body:match("\n *#show *\n")
		or body:match("^ *#show ")
		or body:match("\n *#show ")
		or body:match("^ *#showtooltip *$")
		or body:match("\n *#showtooltip *$")
		or body:match("^ *#showtooltip *\n")
		or body:match("\n *#showtooltip *\n")
		or body:match("^ *#showtooltip ")
		or body:match("\n *#showtooltip ")
	)
end

local function RegisterButtons()
	BUTTONSREGISTERED = nil
	wipe(Buttons.Spell)
	wipe(Buttons.Macro)
	wipe(Buttons.Item)
	wipe(Frames.Spell)
	wipe(Frames.Macro)
	wipe(Frames.Item)
	--SpellFlashCore.debug("-     Button Slots Found:")
	for i = 1, 144 do
		if HasAction(i) then
			local Type, ID = GetActionInfo(i)
			if Type == "macro" then
				if BodyHasMetaTag(GetMacroBody(ID)) then
					ID = tostring(ID)
					if not Buttons.Macro[ID] then
						Buttons.Macro[ID] = {}
					end
					tinsert(Buttons.Macro[ID], i)
				end
				--SpellFlashCore.debug("Macro: "..GetActionText(i).." = "..i)
			elseif Type == "item" then
				local ItemName = GetItemName(ID)
				if ItemName then
					if not Buttons.Item[ItemName] then
						Buttons.Item[ItemName] = {}
					end
					tinsert(Buttons.Item[ItemName], i)
					--SpellFlashCore.debug("Item: "..ItemName.." = "..i)
				end
			elseif Type == "spell" then
				if WotLKBuild then
					ID = select(4, GetActionInfo(i))
				end
				local SpellName = GetSpellName(ID)
				if SpellName then
					if not Buttons.Spell[SpellName] then
						Buttons.Spell[SpellName] = {}
					end
					tinsert(Buttons.Spell[SpellName], i)
					--SpellFlashCore.debug(SpellName.." = "..i)
				end
			end
		end
	end
	if IsAddOnLoaded("ExtraBar") then
		local t = GetActiveTalentGroup()
		for b=1,4 do
			local i = 1
			local frame = _G["ExtraBar"..b.."Button"..i]
			while type(frame) == "table" do
				local Name = frame["set"..t.."name"]
				if type(Name) == "string" and Name ~= "" then
					local ID = frame["set"..t.."value"]
					local Type = frame["set"..t.."type"]
					if Type == "macro" then
						if BodyHasMetaTag(GetMacroBody(ID)) then
							ID = tostring(ID)
							if not Frames.Macro[ID] then
								Frames.Macro[ID] = {}
							end
							tinsert(Frames.Macro[ID], frame)
						end
						--SpellFlashCore.debug("ExtraBar Macro: "..Name.." = Bar: "..b.." Button: "..i)
					elseif Type == "item" then
						if not Frames.Item[Name] then
							Frames.Item[Name] = {}
						end
						tinsert(Frames.Item[Name], frame)
						--SpellFlashCore.debug("ExtraBar Item: "..Name.." = Bar: "..b.." Button: "..i)
					elseif Type == "spell" then
						local SpellName = GetSpellName(ID) or Name
						if not Frames.Spell[SpellName] then
							Frames.Spell[SpellName] = {}
						end
						tinsert(Frames.Spell[SpellName], frame)
						--SpellFlashCore.debug("ExtraBar: "..SpellName.." = Bar: "..b.." Button: "..i)
					end
				end
				i = i + 1
				frame = _G["ExtraBar"..b.."Button"..i]
			end
		end
	end
	if IsAddOnLoaded("ButtonForge") then
		local i = 1
		local frame = _G["ButtonForge"..i]
		while type(frame) == "table" do
			if type(frame.ParentButton) == "table" then
				if frame.ParentButton.Mode == "macro" and type(frame.ParentButton.MacroName) == "string" and frame.ParentButton.MacroName ~= "" then
					local ID = frame.ParentButton.MacroIndex
					if BodyHasMetaTag(GetMacroBody(ID)) then
						ID = tostring(ID)
						if not Frames.Macro[ID] then
							Frames.Macro[ID] = {}
						end
						tinsert(Frames.Macro[ID], frame)
					end
					--SpellFlashCore.debug("ButtonForge Macro: "..frame.ParentButton.MacroName.." = Button: "..i)
				elseif frame.ParentButton.Mode == "item" and type(frame.ParentButton.ItemName) == "string" and frame.ParentButton.ItemName ~= "" then
					if not Frames.Item[frame.ParentButton.ItemName] then
						Frames.Item[frame.ParentButton.ItemName] = {}
					end
					tinsert(Frames.Item[frame.ParentButton.ItemName], frame)
					--SpellFlashCore.debug("ButtonForge Item: "..frame.ParentButton.ItemName.." = Button: "..i)
				elseif frame.ParentButton.Mode == "spell" and type(frame.ParentButton.SpellName) == "string" and frame.ParentButton.SpellName ~= "" then
					local SpellName = GetSpellName(frame.ParentButton.SpellId) or frame.ParentButton.SpellName
					if not Frames.Spell[SpellName] then
						Frames.Spell[SpellName] = {}
					end
					tinsert(Frames.Spell[SpellName], frame)
					--SpellFlashCore.debug("ButtonForge: "..SpellName.." = Button: "..i)
				end
			end
			i = i + 1
			frame = _G["ButtonForge"..i]
		end
	end
	BUTTONSREGISTERED = 1
end

local function DuplicateFrame(frame)
	for Type in pairs(ButtonFrames) do
		for _, v in ipairs(ButtonFrames[Type]) do
			if v == frame then
				return true
			end
		end
	end
	return false
end

FrameNames.Form = {
	"DominosClassButton", -- Dominos
	"VFLStanceButton", -- OpenRDX
}

FrameNames.Pet = {
	"VFLPetButton", -- OpenRDX
}

FrameNames.Action = {
	"BT4Button", -- Bartender
	"VFLButton", -- OpenRDX
}

local function RegisterFrames()
	FRAMESREGISTERED = nil
	wipe(ButtonFrames.Action)
	wipe(ButtonFrames.Pet)
	wipe(ButtonFrames.Form)
	wipe(ButtonFrames.Vehicle)
	local frame
	for Type in pairs(FrameNames) do
		for _, Name in ipairs(FrameNames[Type]) do
			for i = 1, 144 do
				frame = _G[Name..i]
				if frame and not DuplicateFrame(frame) then
					tinsert(ButtonFrames[Type], frame)
				end
			end
		end
	end
	frame = EnumerateFrames()
	while frame do
		if frame.IsProtected and frame.GetObjectType and frame.GetScript and frame:GetObjectType() == "CheckButton" and frame:IsProtected() then
			if frame:GetScript("OnClick") == ShapeshiftButton1:GetScript("OnClick") then
				if not DuplicateFrame(frame) then
					tinsert(ButtonFrames.Form, frame)
				end
			elseif frame:GetScript("OnClick") == PetActionButton1:GetScript("OnClick") then
				if not DuplicateFrame(frame) then
					tinsert(ButtonFrames.Pet, frame)
				end
			elseif frame:GetScript("OnClick") == VehicleMenuBarActionButton1:GetScript("OnClick") then
				if not DuplicateFrame(frame) then
					tinsert(ButtonFrames.Vehicle, frame)
				end
			elseif frame:GetScript("OnClick") == ActionButton1:GetScript("OnClick") then
				if not DuplicateFrame(frame) then
					tinsert(ButtonFrames.Action, frame)
				end
			end
		end
		frame = EnumerateFrames(frame)
	end
	FRAMESREGISTERED = 1
end

function SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
	if frame and frame:IsVisible() then
		if blink and frame:GetName() and not UIFrameIsFading(frame) then
			UIFrameFlash(frame, 0, 0.2, 0.2, true, 0, 0)
		end
		if not frame.SpellFlashCoreAddonFlashFrame then
			frame.SpellFlashCoreAddonFlashFrame = CreateFrame("Frame", nil, frame)
			frame.SpellFlashCoreAddonFlashFrame:Hide()
			frame.SpellFlashCoreAddonFlashFrame:SetAllPoints(frame)
			frame.SpellFlashCoreAddonFlashFrame.FlashTexture = frame.SpellFlashCoreAddonFlashFrame:CreateTexture(nil, "OVERLAY")
			frame.SpellFlashCoreAddonFlashFrame.FlashTexture:SetTexture("Interface\\Cooldown\\star4")
			frame.SpellFlashCoreAddonFlashFrame.FlashTexture:SetPoint("CENTER", frame.SpellFlashCoreAddonFlashFrame, "CENTER")
			frame.SpellFlashCoreAddonFlashFrame.FlashTexture:SetBlendMode("ADD")
			frame.SpellFlashCoreAddonFlashFrame:SetAlpha(1)
			frame.SpellFlashCoreAddonFlashFrame.UpdateInterval = 0.02
			frame.SpellFlashCoreAddonFlashFrame.TimeSinceLastUpdate = 0
			function frame.SpellFlashCoreAddonFlashFrame.OnUpdate(self, elapsed)
				self.TimeSinceLastUpdate = self.TimeSinceLastUpdate + elapsed
				if self.TimeSinceLastUpdate >= self.UpdateInterval then
					self.modifier = self.FlashModifier
					self.FlashModifier = self.modifier - self.modifier * self.TimeSinceLastUpdate
					self.TimeSinceLastUpdate = 0
					self.alpha = self.FlashModifier * self.FlashBrightness
					if self.modifier < 0.1 or self.alpha <= 0 then
						self:Hide()
					else
						self.FlashTexture:SetHeight(self.modifier * self:GetHeight() * self.FlashSize)
						self.FlashTexture:SetWidth(self.modifier * self:GetWidth() * self.FlashSize)
						self.FlashTexture:SetAlpha(self.alpha)
					end
				end
			end
			frame.SpellFlashCoreAddonFlashFrame:SetScript("OnUpdate", frame.SpellFlashCoreAddonFlashFrame.OnUpdate)
		end
		frame.SpellFlashCoreAddonFlashFrame.FlashModifier = 1
		frame.SpellFlashCoreAddonFlashFrame.FlashSize = (size or 240) / 100
		frame.SpellFlashCoreAddonFlashFrame.FlashBrightness = (brightness or 100) / 100
		frame.SpellFlashCoreAddonFlashFrame.FlashTexture:SetAlpha(1 * frame.SpellFlashCoreAddonFlashFrame.FlashBrightness)
		frame.SpellFlashCoreAddonFlashFrame.FlashTexture:SetHeight(frame.SpellFlashCoreAddonFlashFrame:GetHeight() * frame.SpellFlashCoreAddonFlashFrame.FlashSize)
		frame.SpellFlashCoreAddonFlashFrame.FlashTexture:SetWidth(frame.SpellFlashCoreAddonFlashFrame:GetWidth() * frame.SpellFlashCoreAddonFlashFrame.FlashSize)
		if type(color) == "table" then
			frame.SpellFlashCoreAddonFlashFrame.FlashTexture:SetVertexColor(color.r or 1, color.g or 1, color.b or 1)
		elseif type(color) == "string" then
			local color = COLORTABLE[color:lower()]
			if color then
				frame.SpellFlashCoreAddonFlashFrame.FlashTexture:SetVertexColor(color.r or 1, color.g or 1, color.b or 1)
			else
				frame.SpellFlashCoreAddonFlashFrame.FlashTexture:SetVertexColor(1, 1, 1)
			end
		else
			frame.SpellFlashCoreAddonFlashFrame.FlashTexture:SetVertexColor(1, 1, 1)
		end
		frame.SpellFlashCoreAddonFlashFrame:Show()
		return true
	end
	return false
end

local function FlashActionButton(button, color, size, brightness, blink)
	if FRAMESREGISTERED and button then
		for _, frame in ipairs(ButtonFrames.Action) do
			if frame._state_action then
				if frame._state_action == button then
					SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
				end
			elseif frame.action == button then
				SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
			end
		end
	end
end

local function SetMultiCastSpellHook()
	BUTTONSREGISTERED = nil
	AddonTable:SetTimer("RegisterButtons", 1, 0, RegisterButtons)
end
hooksecurefunc("SetMultiCastSpell", SetMultiCastSpellHook)

local function OnEvent(self, event, ...)
	if event == "ACTIONBAR_SHOWGRID" then
			
			BUTTONSREGISTERED = nil
			
	elseif event == "ACTIONBAR_HIDEGRID" or event == "LEARNED_SPELL_IN_TAB" or event == "CHARACTER_POINTS_CHANGED" or event == "ACTIVE_TALENT_GROUP_CHANGED" or event == "UPDATE_MACROS" or event == "VEHICLE_UPDATE" then
			
			FRAMESREGISTERED = nil
			AddonTable:SetTimer("RegisterFrames", 0.5, 0, RegisterFrames)
			BUTTONSREGISTERED = nil
			AddonTable:SetTimer("RegisterButtons", 1, 0, RegisterButtons)
			
	elseif event == "PLAYER_ENTERING_WORLD" or event == "PLAYER_ALIVE" then
			
			if LOADING then
				AddonTable:SetTimer("RegisterFrames", 2, 0, RegisterFrames)
				AddonTable:SetTimer("RegisterButtons", 2, 0, RegisterButtons)
				LOADING = nil
			end
			
	elseif event == "ADDON_LOADED" then
			
			if select(1, ...) == AddonName then
				if not SpellFlashCoreAddonConfig then
					SpellFlashCoreAddonConfig = {}
				elseif SpellFlashCoreAddonConfig.DebugEvents then
					for event in pairs(SpellFlashCoreAddonConfig.DebugEvents) do
						SpellFlashCore.RegisterDebugEvent(event)
					end
				elseif SpellFlashCoreAddonConfig.AllDebugEventsEnabled then
					SpellFlashCore.RegisterAllDebugEvents()
				end
			end
			
	end
end
local EventFrame = CreateFrame("Frame")
EventFrame:RegisterEvent("ADDON_LOADED")
EventFrame:RegisterEvent("ACTIONBAR_HIDEGRID")
EventFrame:RegisterEvent("ACTIONBAR_SHOWGRID")
EventFrame:RegisterEvent("LEARNED_SPELL_IN_TAB")
EventFrame:RegisterEvent("CHARACTER_POINTS_CHANGED")
EventFrame:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
EventFrame:RegisterEvent("UPDATE_MACROS")
EventFrame:RegisterEvent("VEHICLE_UPDATE")
EventFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
EventFrame:RegisterEvent("PLAYER_ALIVE")
EventFrame:SetScript("OnEvent", OnEvent)


local function SlashHandler(msg)
	if msg:lower():match("event") then
		if msg:lower():match("unregister%s+all%s+event") or msg:lower():match("remove%s+all%s+event") then
			SpellFlashCore.UnregisterAllDebugEvents()
			Message(L["all events unregistered"])
		elseif msg:lower():match("^%s*register%s+all%s+event") then
			SpellFlashCore.RegisterAllDebugEvents()
			Message(L["all events registered"])
		else
			local event = msg:match("[Ee][Vv][Ee][Nn][Tt]%s+(%S+)%s*$")
			if event then
				if msg:lower():match("unregister%s+event%s+%S+%s*$") or msg:lower():match("remove%s+event%s+%S+%s*$") then
					if SpellFlashCoreAddonConfig.DebugEvents then
						SpellFlashCore.UnregisterDebugEvent(event)
						Message("-", event)
					end
				else
					SpellFlashCore.RegisterDebugEvent(event)
					Message("+", event)
				end
			end
		end
	elseif msg:lower():match("debug") then
		if msg:lower():match("on") then
			Message(L["debug is enabled"])
			SpellFlashCoreAddonConfig.Debug = true
		elseif msg:lower():match("off") then
			Message(L["debug is disabled"])
			SpellFlashCoreAddonConfig.Debug = nil
		elseif SpellFlashCoreAddonConfig.Debug then
			Message(L["debug is disabled"])
			SpellFlashCoreAddonConfig.Debug = nil
		else
			Message(L["debug is enabled"])
			SpellFlashCoreAddonConfig.Debug = true
		end
	elseif msg:lower():match("reset.*all") or msg:lower():match("clear.*all") or msg:lower():match("delete.*all") then
		SpellFlashCore.UnregisterAllDebugEvents()
		wipe(SpellFlashCoreAddonConfig)
		Message(L["all settings cleared"])
	end
end
SlashCmdList.SpellFlashCoreAddon = SlashHandler
SLASH_SpellFlashCoreAddon1 = "/spellflashcore"
SLASH_SpellFlashCoreAddon2 = "/sfcore"
SLASH_SpellFlashCoreAddon3 = "/sfc"


local DebugCount = 0
function SpellFlashCore.debug(...)
	if SpellFlashCoreAddonConfig.Debug and select("#", ...) > 0 then
		DebugCount = DebugCount + 1
		print("["..DebugCount.."]  ", ...)
	end
end


function SpellFlashCore.Flashable(SpellName, NoMacros)
	if FRAMESREGISTERED and BUTTONSREGISTERED then
		local SpellName, FirstName = SpellName
		if type(SpellName) == "number" then
			if WotLKBuild then
				SpellName = GetSpellName(SpellName)
				FirstName = SpellName
			else
				FirstName, SpellName = GetSpellInfo(SpellName)
				if SpellName and SpellName ~= "" then
					SpellName = FirstName.."("..SpellName..")"
				else
					SpellName = FirstName
				end
			end
		else
			FirstName = SpellName
		end
		if type(SpellName) == "string" and SpellName ~= "" then
			if Buttons.Spell[SpellName] or Buttons.Item[SpellName] or Frames.Spell[SpellName] or Frames.Item[SpellName] then
				return true
			elseif not NoMacros and ( GetSpellInfo(SpellName) or GetItemCount(SpellName) > 0 ) then
				local SpellTexture = GetSpellTexture(SpellName)
				local ItemTexture = GetItemIcon(SpellName)
				for n in pairs(Buttons.Macro) do
					local name, MacroTexture, body = GetMacroInfo(tonumber(n))
					if ( MacroTexture == SpellTexture or MacroTexture == ItemTexture ) and body and body:lower():find(FirstName:lower(),nil,true) then
						return true
					end
				end
				for n in pairs(Frames.Macro) do
					local name, MacroTexture, body = GetMacroInfo(tonumber(n))
					if ( MacroTexture == SpellTexture or MacroTexture == ItemTexture ) and body and body:lower():find(FirstName:lower(),nil,true) then
						return true
					end
				end
			end
		end
	end
	return false
end

function SpellFlashCore.ItemFlashable(ItemName, NoMacros)
	return SpellFlashCore.Flashable(GetItemName(ItemName) or ItemName, NoMacros)
end

function SpellFlashCore.FlashAction(SpellName, color, size, brightness, blink, NoMacros)
	if FRAMESREGISTERED and BUTTONSREGISTERED then
		local SpellName, FirstName = SpellName
		if type(SpellName) == "number" then
			if WotLKBuild then
				SpellName = GetSpellName(SpellName)
				FirstName = SpellName
			else
				FirstName, SpellName = GetSpellInfo(SpellName)
				if SpellName and SpellName ~= "" then
					SpellName = FirstName.."("..SpellName..")"
				else
					SpellName = FirstName
				end
			end
		else
			FirstName = SpellName
		end
		if type(SpellName) == "string" and SpellName ~= "" then
			if Buttons.Spell[SpellName] then
				for _, button in ipairs(Buttons.Spell[SpellName]) do
					FlashActionButton(button, color, size, brightness, blink)
				end
			end
			if Buttons.Item[SpellName] then
				for _, button in ipairs(Buttons.Item[SpellName]) do
					FlashActionButton(button, color, size, brightness, blink)
				end
			end
			if Frames.Spell[SpellName] then
				for _, frame in ipairs(Frames.Spell[SpellName]) do
					SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
				end
			end
			if Frames.Item[SpellName] then
				for _, frame in ipairs(Frames.Item[SpellName]) do
					SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
				end
			end
			if not NoMacros and ( GetSpellInfo(SpellName) or GetItemCount(SpellName) > 0 ) then
				local SpellTexture = GetSpellTexture(SpellName)
				local ItemTexture = GetItemIcon(SpellName)
				for n, v in pairs(Buttons.Macro) do
					local name, MacroTexture, body = GetMacroInfo(tonumber(n))
					if ( MacroTexture == SpellTexture or MacroTexture == ItemTexture ) and body and body:lower():find(FirstName:lower(),nil,true) then
						for _, button in ipairs(v) do
							FlashActionButton(button, color, size, brightness, blink)
						end
					end
				end
				for n, v in pairs(Frames.Macro) do
					local name, MacroTexture, body = GetMacroInfo(tonumber(n))
					if ( MacroTexture == SpellTexture or MacroTexture == ItemTexture ) and body and body:lower():find(FirstName:lower(),nil,true) then
						for _, frame in ipairs(v) do
							SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
						end
					end
				end
			end
		end
	end
end

function SpellFlashCore.FlashItem(ItemName, color, size, brightness, blink, NoMacros)
	return SpellFlashCore.FlashAction(GetItemName(ItemName) or ItemName, color, size, brightness, blink, NoMacros)
end

function SpellFlashCore.FlashVehicle(SpellName, color, size, brightness, blink)
	if FRAMESREGISTERED and UnitInVehicle("player") then
		local SpellName = SpellName
		if type(SpellName) == "number" then
			SpellName = GetSpellName(SpellName)
		end
		if type(SpellName) == "string" and SpellName ~= "" then
			local ID
			for i = 121, 132 do
				
				if WotLKBuild then
					ID = select(4, GetActionInfo(i))
				else
					ID = select(2, GetActionInfo(i))
				end
				
				if ID and GetSpellName(ID) == SpellName then
					for _, frame in ipairs(ButtonFrames.Vehicle) do
						if frame._state_action then
							if frame._state_action == i then
								SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
							end
						elseif frame.action == i then
							SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
						end
					end
					for _, frame in ipairs(ButtonFrames.Action) do
						if frame._state_action then
							if frame._state_action == i then
								SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
							end
						elseif frame.action == i then
							SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
						end
					end
				end
			end
		end
	end
end

function SpellFlashCore.FlashPet(SpellName, color, size, brightness, blink)
	if FRAMESREGISTERED then
		local SpellName = SpellName
		if type(SpellName) == "number" then
			SpellName = GetSpellName(SpellName)
		end
		if type(SpellName) == "string" and SpellName ~= "" then
			for n = 1, NUM_PET_ACTION_SLOTS do
				local name, subtext = GetPetActionInfo(n)
				if not WotLKBuild and subtext and subtext ~= "" then
					name = name.."("..subtext..")"
				end
				if ( AddonTable.PetActions[SpellName] or SpellName ) == name then
					for _, frame in ipairs(ButtonFrames.Pet) do
						if frame.id then
							if frame.id == n then
								SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
							end
						elseif frame:GetID() == n then
							SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
						end
					end
				end
			end
		end
	end
end

function SpellFlashCore.FlashForm(SpellName, color, size, brightness, blink)
	if FRAMESREGISTERED then
		local SpellName = SpellName
		if type(SpellName) == "number" then
			SpellName = GetSpellName(SpellName, 1)
		end
		if type(SpellName) == "string" and SpellName ~= "" then
			for n=1,GetNumShapeshiftForms() do
				if select(2,GetShapeshiftFormInfo(n)) == SpellName then
					for _, frame in ipairs(ButtonFrames.Form) do
						if frame.id then
							if frame.id == n then
								SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
							end
						elseif frame:GetID() == n then
							SpellFlashCore.FlashFrame(frame, color, size, brightness, blink)
						end
					end
				end
			end
		end
	end
end


local TotemCallFrames = {
	"MultiCastSummonSpellButton", -- Blizzard
	"DominosSpellButton10", -- Dominos
	"DominosSpellButton21", -- Dominos
	"DominosSpellButton32", -- Dominos
}

function SpellFlashCore.FlashTotemCall(color, size, brightness, blink)
	for _, frame in ipairs(TotemCallFrames) do
		SpellFlashCore.FlashFrame(_G[frame], color, size, brightness, blink)
	end
end

local TotemRecallFrames = {
	"MultiCastRecallSpellButton", -- Blizzard
	"DominosSpellButton11", -- Dominos
	"DominosSpellButton22", -- Dominos
	"DominosSpellButton33", -- Dominos
}

function SpellFlashCore.FlashTotemRecall(color, size, brightness, blink)
	for _, frame in ipairs(TotemRecallFrames) do
		SpellFlashCore.FlashFrame(_G[frame], color, size, brightness, blink)
	end
end


local DebugEventFrame = CreateFrame("Frame")
DebugEventFrame.LastEventTime = 0
local function DebugOnEvent(self, event, ...)
	if SpellFlashCoreAddonConfig.Debug then
		local t = GetTime()
		SpellFlashCore.debug("event:  "..event)
		SpellFlashCore.debug("       Time:  "..t.."  -  "..self.LastEventTime.."  =  "..( t - self.LastEventTime ))
		self.LastEventTime = t
		local n = select("#", ...)
		if n > 0 then
			for i=1,n do
				if type(select(i, ...)) ~= "nil" then
					SpellFlashCore.debug("       arg"..i.." = "..type(select(i, ...))..": "..tostring(select(i, ...)))
				end
			end
		end
	end
end
DebugEventFrame:SetScript("OnEvent", DebugOnEvent)

function SpellFlashCore.RegisterDebugEvent(event)
	if SpellFlashCoreAddonConfig.AllDebugEventsEnabled then
		DebugEventFrame:UnregisterAllEvents()
		SpellFlashCoreAddonConfig.AllDebugEventsEnabled = nil
		SpellFlashCoreAddonConfig.DebugEvents = nil
	end
	DebugEventFrame:RegisterEvent(event)
	if not SpellFlashCoreAddonConfig.DebugEvents then
		SpellFlashCoreAddonConfig.DebugEvents = {}
	end
	SpellFlashCoreAddonConfig.DebugEvents[event] = true
end

function SpellFlashCore.UnregisterDebugEvent(event)
	if SpellFlashCoreAddonConfig.AllDebugEventsEnabled then
		DebugEventFrame:UnregisterAllEvents()
		SpellFlashCoreAddonConfig.AllDebugEventsEnabled = nil
		SpellFlashCoreAddonConfig.DebugEvents = nil
	else
		DebugEventFrame:UnregisterEvent(event)
		if SpellFlashCoreAddonConfig.DebugEvents then
			SpellFlashCoreAddonConfig.DebugEvents[event] = nil
			if not next(SpellFlashCoreAddonConfig.DebugEvents) then
				SpellFlashCoreAddonConfig.DebugEvents = nil
			end
		end
	end
end

function SpellFlashCore.RegisterAllDebugEvents()
	DebugEventFrame:RegisterAllEvents()
	SpellFlashCoreAddonConfig.AllDebugEventsEnabled = true
	SpellFlashCoreAddonConfig.DebugEvents = nil
end

function SpellFlashCore.UnregisterAllDebugEvents()
	DebugEventFrame:UnregisterAllEvents()
	SpellFlashCoreAddonConfig.AllDebugEventsEnabled = nil
	SpellFlashCoreAddonConfig.DebugEvents = nil
end




-- This is used for testing purposes only
-- Example: SpellFlashCore.SaveAllFrameNameStringsIntoATable(SpellFlashAddonConfig)
function SpellFlashCore.SaveAllFrameNameStringsIntoATable(TABLE)
	if type(TABLE) == "table" then
		local n = "ALL DETECTABLE FRAME STRINGS"
		if not TABLE[n] then
			TABLE[n] = {}
		end
		wipe(TABLE[n])
		local frame = EnumerateFrames()
		while frame do
			if frame:GetName() then
				if frame.IsProtected and frame.GetObjectType and frame.GetScript and frame:GetObjectType() == "CheckButton" and frame:IsProtected() then
					if not TABLE[n].Buttons then
						TABLE[n].Buttons = {}
					end
					if frame:GetScript("OnClick") == ShapeshiftButton1:GetScript("OnClick") then
						if not TABLE[n].Buttons.Form then
							TABLE[n].Buttons.Form = {}
						end
						TABLE[n].Buttons.Form[frame:GetName()] = "form"
					elseif frame:GetScript("OnClick") == PetActionButton1:GetScript("OnClick") then
						if not TABLE[n].Buttons.Pet then
							TABLE[n].Buttons.Pet = {}
						end
						TABLE[n].Buttons.Pet[frame:GetName()] = "pet"
					elseif frame:GetScript("OnClick") == VehicleMenuBarActionButton1:GetScript("OnClick") then
						if not TABLE[n].Buttons.Vehicle then
							TABLE[n].Buttons.Vehicle = {}
						end
						TABLE[n].Buttons.Vehicle[frame:GetName()] = "vehicle"
					elseif frame:GetScript("OnClick") == ActionButton1:GetScript("OnClick") then
						if not TABLE[n].Buttons.Action then
							TABLE[n].Buttons.Action = {}
						end
						TABLE[n].Buttons.Action[frame:GetName()] = "action"
					else
						if not TABLE[n].Buttons.Other then
							TABLE[n].Buttons.Other = {}
						end
						TABLE[n].Buttons.Other[frame:GetName()] = "other"
					end
				else
					if not TABLE[n].Any then
						TABLE[n].Any = {}
					end
					TABLE[n].Any[frame:GetName()] = "any"
				end
			end
			frame = EnumerateFrames(frame)
		end
	end
end

