/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import java.util.ArrayList;
import junit.framework.Test;
import junit.runner.Version;
import org.junit.internal.runners.OldTestClassRunner;
import org.junit.internal.runners.TextListener;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class JUnitCore {
    private RunNotifier fNotifier = new RunNotifier();

    public static void main(String ... args) {
        Result result = new JUnitCore().runMain(args);
        JUnitCore.killAllThreads(result);
    }

    private static void killAllThreads(Result result) {
        System.exit(result.wasSuccessful() ? 0 : 1);
    }

    public static Result runClasses(Class ... classes) {
        return new JUnitCore().run(classes);
    }

    public Result runMain(String ... args) {
        System.out.println("JUnit version " + Version.id());
        ArrayList classes = new ArrayList();
        for (String each : args) {
            try {
                classes.add(Class.forName(each));
            }
            catch (ClassNotFoundException e) {
                System.out.println("Could not find class: " + each);
            }
        }
        TextListener listener = new TextListener();
        this.addListener(listener);
        return this.run(classes.toArray(new Class[0]));
    }

    public String getVersion() {
        return Version.id();
    }

    public Result run(Class ... classes) {
        return this.run(Request.classes("All", classes));
    }

    public Result run(Request request) {
        return this.run(request.getRunner());
    }

    public Result run(Test test2) {
        return this.run(new OldTestClassRunner(test2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result run(Runner runner) {
        Result result = new Result();
        RunListener listener = result.createListener();
        this.addFirstListener(listener);
        try {
            this.fNotifier.fireTestRunStarted(runner.getDescription());
            runner.run(this.fNotifier);
            this.fNotifier.fireTestRunFinished(result);
        }
        finally {
            this.removeListener(listener);
        }
        return result;
    }

    private void addFirstListener(RunListener listener) {
        this.fNotifier.addFirstListener(listener);
    }

    public void addListener(RunListener listener) {
        this.fNotifier.addListener(listener);
    }

    public void removeListener(RunListener listener) {
        this.fNotifier.removeListener(listener);
    }
}

