/*
 * Decompiled with CFR 0.152.
 */
package spreader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import weibo4j.Weibo;

public class Status {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private String status;
    private String imageFile;

    public Status(String string, String string2) {
        this.status = string;
        this.imageFile = string2;
    }

    public static List<Status> loadMessages(String string) {
        Row row;
        ArrayList<Status> arrayList = new ArrayList<Status>();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(fileInputStream);
        }
        catch (InvalidFormatException invalidFormatException) {
            invalidFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Sheet sheet = workbook.getSheetAt(0);
        int n = sheet.getFirstRowNum();
        int n2 = sheet.getLastRowNum();
        System.out.println(n + "," + n2);
        String string2 = Status.getFormatDate(new Date());
        for (int i = n + 1; i <= n2 && (row = sheet.getRow(i)) != null; ++i) {
            short s = row.getFirstCellNum();
            Date date = row.getCell(s, Row.CREATE_NULL_AS_BLANK).getDateCellValue();
            String string3 = Status.getFormatDate(date);
            if (!string2.equals(string3)) continue;
            String string4 = row.getCell(s + 1, Row.CREATE_NULL_AS_BLANK).getStringCellValue();
            String string5 = row.getCell(s + 2, Row.CREATE_NULL_AS_BLANK).getStringCellValue();
            Status status = new Status(string4, string5);
            System.out.println("Message:" + status);
            arrayList.add(status);
        }
        return arrayList;
    }

    public static String getFormatDate(Date date) {
        return DATE_FORMAT.format(date);
    }

    public String getStatus() {
        return this.status;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    private static Weibo getWeibo(boolean bl, String[] stringArray) {
        Weibo weibo = new Weibo();
        if (bl) {
            weibo.setToken(stringArray[0], stringArray[1]);
        } else {
            weibo.setUserId(stringArray[0]);
            weibo.setPassword(stringArray[1]);
        }
        return weibo;
    }
}

