/*
 * Decompiled with CFR 0.152.
 */
package spreader.schedule;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import spreader.schedule.ScheduleIterator;
import spreader.schedule.SchedulerTask;

public class Scheduler {
    private final Timer timer = new Timer();

    public void cancel() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SchedulerTask schedulerTask, ScheduleIterator scheduleIterator) {
        Date date = scheduleIterator.next();
        if (date == null) {
            schedulerTask.cancel();
        } else {
            Object object = schedulerTask.lock;
            synchronized (object) {
                if (schedulerTask.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                schedulerTask.state = 1;
                schedulerTask.timerTask = new SchedulerTimerTask(schedulerTask, scheduleIterator);
                this.timer.schedule(schedulerTask.timerTask, date);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reschedule(SchedulerTask schedulerTask, ScheduleIterator scheduleIterator) {
        Date date = scheduleIterator.next();
        if (date == null) {
            schedulerTask.cancel();
        } else {
            Object object = schedulerTask.lock;
            synchronized (object) {
                if (schedulerTask.state != 2) {
                    schedulerTask.timerTask = new SchedulerTimerTask(schedulerTask, scheduleIterator);
                    this.timer.schedule(schedulerTask.timerTask, date);
                }
            }
        }
    }

    class SchedulerTimerTask
    extends TimerTask {
        private SchedulerTask schedulerTask;
        private ScheduleIterator iterator;

        public SchedulerTimerTask(SchedulerTask schedulerTask, ScheduleIterator scheduleIterator) {
            this.schedulerTask = schedulerTask;
            this.iterator = scheduleIterator;
        }

        @Override
        public void run() {
            this.schedulerTask.run();
            Scheduler.this.reschedule(this.schedulerTask, this.iterator);
        }
    }
}

