/*
 * Decompiled with CFR 0.152.
 */
package spreader.schedule;

import java.util.List;
import java.util.Map;
import spreader.Status;
import spreader.schedule.DailyIterator;
import spreader.schedule.Scheduler;
import spreader.schedule.SchedulerTask;
import spreader.service.UpdateStatusService;
import spreader.ui.UIListener;
import weibo4j.http.AccessToken;

public class UpdateStatusTask {
    private final Scheduler scheduler = new Scheduler();
    private final int hourOfDay;
    private final int minute;
    private final int second;
    private Map<String, AccessToken> accessTokens;

    public void setAccessTokens(Map<String, AccessToken> map) {
        this.accessTokens = map;
    }

    public UpdateStatusTask(int n, int n2, int n3) {
        this.hourOfDay = n;
        this.minute = n2;
        this.second = n3;
    }

    public void start() {
        this.scheduler.schedule(new SchedulerTask(){

            @Override
            public void run() {
                List<Status> list = Status.loadMessages(UIListener.getMessageFilePath());
                String string = UIListener.getImageFolder();
                for (Status status : list) {
                    UpdateStatusService.updateStatus(UpdateStatusTask.this.accessTokens, status.getStatus(), string + "\\" + status.getImageFile());
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }, new DailyIterator(this.hourOfDay, this.minute, this.second));
    }
}

