/*
 * Decompiled with CFR 0.152.
 */
package spreader.service;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import weibo4j.Paging;
import weibo4j.Status;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.http.AccessToken;

public class CopyStatusService {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public static String getFormatDate(Date date) {
        return DATE_FORMAT.format(date);
    }

    public static void copyMessagesToEXL(String string, String string2, Map<String, AccessToken> map) {
        Iterator<String> iterator = map.keySet().iterator();
        if (iterator.hasNext()) {
            String string3 = iterator.next();
            AccessToken accessToken = map.get(string3);
            Weibo weibo = new Weibo();
            weibo.setToken(accessToken.getToken(), accessToken.getTokenSecret());
            Paging paging = new Paging(1, 40);
            try {
                List<Status> list = weibo.getUserTimeline(string, paging);
                String string4 = string2;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                Workbook workbook = null;
                try {
                    workbook = WorkbookFactory.create(fileInputStream);
                }
                catch (InvalidFormatException invalidFormatException) {
                    invalidFormatException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                Sheet sheet = workbook.getSheetAt(0);
                int n = sheet.getLastRowNum();
                Calendar calendar = Calendar.getInstance();
                Date date = calendar.getTime();
                long l = date.getTime() - 86400000L;
                Date date2 = new Date(l);
                for (Status status : list) {
                    if (!CopyStatusService.getFormatDate(status.getCreatedAt()).equals(CopyStatusService.getFormatDate(date2))) continue;
                    Row row = sheet.createRow(++n);
                    row.createCell(0).setCellValue(CopyStatusService.getFormatDate(new Date()));
                    row.createCell(1).setCellValue(status.getText());
                    row.createCell(2).setCellValue(new Random().nextInt(100) + ".jpg");
                }
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string4);
                    workbook.write(fileOutputStream);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            catch (WeiboException weiboException) {
                weiboException.printStackTrace();
            }
            return;
        }
    }
}

