/*
 * Decompiled with CFR 0.152.
 */
package spreader.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import spreader.db.DBUser;
import spreader.service.SearchUserService;
import spreader.service.base.AbstractWeiboService;
import spreader.service.base.Configuration;
import spreader.ui.UIListener;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.http.AccessToken;

public class CreateFriendService
extends AbstractWeiboService {
    private static int MAX_FRIEND_COUNT = 2000;
    private static int ADD_FRIEND_LOOP_TIMES = 1;
    private static int ADD_FRIEND_DELAY = 25000;
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private Map<String, AccessToken> accessTokens;

    public CreateFriendService(Map<String, AccessToken> map) {
        this.accessTokens = map;
    }

    public void createFriendship() {
        UIListener.updateBoard("\u8d26\u6237\u6dfb\u52a0\u5173\u6ce8\u5f00\u59cb\u6267\u884c...");
        for (String string : this.accessTokens.keySet()) {
            AccessToken accessToken = this.accessTokens.get(string);
            this.create(string, accessToken);
        }
        UIListener.updateBoard("\u8d26\u6237\u6dfb\u52a0\u5173\u6ce8\u5b8c\u6bd5!");
    }

    private void create(String string, AccessToken accessToken) {
        Weibo weibo = CreateFriendService.getWeibo(true, accessToken);
        Configuration configuration = new Configuration(UIListener.getGzConfigFilePath());
        String string2 = "";
        int n = 0;
        try {
            string2 = String.valueOf(weibo.verifyCredentials().getId());
            n = weibo.showUser(string2).getFriendsCount();
        }
        catch (WeiboException weiboException) {
            weiboException.printStackTrace();
        }
        if (n >= MAX_FRIEND_COUNT) {
            UIListener.updateBoard("\u8d26\u6237:" + string + "\u5df2\u7ecf\u5173\u6ce8\u4e862000\u4e2a\u597d\u53cb\u3002");
            return;
        }
        for (int i = 0; i < ADD_FRIEND_LOOP_TIMES; ++i) {
            List<DBUser> list = SearchUserService.getDBUsers();
            if (list.size() == 0) {
                configuration.setValue("GzDBUserid", "");
                configuration.setValue("GzDBUserCity", "");
                configuration.saveFile(UIListener.getGzConfigFilePath(), "\u914d\u7f6e\u6587\u4ef61");
                list = SearchUserService.getDBUsers();
            }
            for (DBUser dBUser : list) {
                String string3 = dBUser.getId();
                UIListener.updateBoard("\u8d26\u6237:" + string + "\u6b63\u5728\u52a0\u7528\u6237[id=" + dBUser.getId() + ",name=" + dBUser.getName() + "]\u4e3a\u597d\u53cb...");
                try {
                    if (n >= MAX_FRIEND_COUNT) {
                        UIListener.updateBoard("\u8d26\u6237:" + string + "\u5df2\u7ecf\u5173\u6ce8\u4e862000\u4e2a\u597d\u53cb\u3002");
                        return;
                    }
                    weibo.createFriendship(string3);
                    configuration.setValue("GzDBUserid", string3);
                    configuration.setValue("GzDBUserCity", dBUser.getCity());
                    configuration.saveFile(UIListener.getGzConfigFilePath(), "\u914d\u7f6e\u6587\u4ef61");
                    ++n;
                }
                catch (WeiboException weiboException) {
                    configuration.setValue("GzDBUserid", string3);
                    configuration.setValue("GzDBUserCity", dBUser.getCity());
                    configuration.saveFile(UIListener.getGzConfigFilePath(), "\u914d\u7f6e\u6587\u4ef61");
                    System.out.println("Spreader - Add Friend Service error:" + weiboException.getMessage());
                    weiboException.printStackTrace();
                }
            }
            try {
                Thread.sleep(ADD_FRIEND_DELAY);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        UIListener.updateBoard("\u8d26\u6237:" + string + "\u52a0\u5173\u6ce8\u7ed3\u675f(" + new SimpleDateFormat(DATE_TIME_FORMAT).format(new Date()) + ")\u3002");
    }
}

