/*
 * Decompiled with CFR 0.152.
 */
package spreader.service;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import spreader.db.DBSubContent;
import spreader.db.DBUser;
import spreader.db.MentionMethod;
import spreader.db.SubContentMethod;
import spreader.db.UserMethod;
import spreader.service.base.AbstractWeiboService;
import spreader.service.base.Configuration;
import spreader.ui.SendMentionPanel;
import spreader.ui.UIListener;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.http.AccessToken;

public class SendMentionService
extends AbstractWeiboService {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private Map<String, AccessToken> accessTokens;
    private int mentionid;
    private String mention;
    public static int CNT = 0;
    public static int mentionSate = 0;

    public SendMentionService(Map<String, AccessToken> map, int n, String string) {
        this.accessTokens = map;
        this.mentionid = n;
        this.mention = string;
    }

    public static long delay() {
        int n;
        Configuration configuration = new Configuration(UIListener.getConfigFilePath());
        int n2 = Integer.parseInt(configuration.getValue("mentionMinute"));
        long l = (n2 * 60 + (n = Integer.parseInt(configuration.getValue("mentionSecond")))) * 1000;
        if (l < 10000L) {
            l = 10000L;
        }
        return l;
    }

    public void sendMention() {
        Configuration configuration = new Configuration(UIListener.getConfigFilePath());
        int n = Integer.parseInt(configuration.getValue("mentionCnt"));
        String string = new SimpleDateFormat(DATE_TIME_FORMAT).format(new Date());
        UIListener.updateMentionBoard(string + " \u8d26\u6237\u53d1\u9001\u5fae\u535a@\u5f00\u59cb\u6267\u884c...");
        CNT = configuration.getValue("mentionCntBox").equals("0") ? 0 : MentionMethod.getMentionSendCnt(this.mentionid);
        while (true) {
            Date date = new Date();
            for (String string2 : this.accessTokens.keySet()) {
                AccessToken accessToken = this.accessTokens.get(string2);
                if (configuration.getValue("mentionCntBox").equals("0")) {
                    this.createIfZero(string2, accessToken);
                } else {
                    this.create(string2, accessToken);
                }
                if (mentionSate != 0) continue;
                break;
            }
            if (CNT >= n || mentionSate == 0) break;
            Date date2 = new Date();
            long l = date2.getTime() - date.getTime();
            if (l >= 300000L) continue;
            try {
                Thread.sleep(300000L - l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        UIListener.updateMentionState("\u53d1\u9001@\u5fae\u535a\u672a\u8fd0\u884c");
        UIListener.updateMentionBoard("\u53d1\u9001\u5fae\u535a@\u5b8c\u6bd5!");
    }

    private void create(String string, AccessToken accessToken) {
        String string2;
        if (mentionSate == 0) {
            return;
        }
        try {
            Thread.sleep(SendMentionService.delay());
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Weibo weibo = SendMentionService.getWeibo(true, accessToken);
        Configuration configuration = new Configuration(UIListener.getConfigFilePath());
        String string3 = configuration.getValue("mentionCity");
        if (string3.substring(0, 2).equals("\u5168\u90e8")) {
            try {
                string3 = new String(configuration.getValue("province").getBytes("ISO-8859-1"), "gbk");
                string3 = string3.substring(3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        String[] stringArray = string3.split(",");
        List<Object> list = new ArrayList();
        String string4 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            string4 = stringArray[i];
            string2 = MentionMethod.getMentionSendID(string4, this.mentionid);
            if (string2.equals("")) {
                list = UserMethod.getUserList(string4, configuration.getValue("mentionSex"), Integer.parseInt(configuration.getValue("mentionCntBox")), configuration.getValue("mentionFollow"));
                if (list.size() > 0) {
                    MentionMethod.insertMentionSend(string4, Integer.toString(this.mentionid), ((DBUser)list.get(0)).getId(), 0, string);
                }
            } else {
                list = UserMethod.getUserList(string4, configuration.getValue("mentionSex"), string2, Integer.parseInt(configuration.getValue("mentionCntBox")), configuration.getValue("mentionFollow"));
            }
            if (list.size() > 0) break;
        }
        if (list.size() == 0) {
            mentionSate = 0;
            return;
        }
        String string5 = "";
        string2 = "";
        for (DBUser dBUser : list) {
            string5 = dBUser.getId();
            string2 = string2 + "@" + dBUser.getName() + " ";
        }
        CNT += list.size();
        List<DBSubContent> list2 = SubContentMethod.getSubContentList("2", SendMentionPanel.id);
        int n = list2.size();
        DBSubContent dBSubContent = null;
        if (n != 0) {
            int n2 = new Random().nextInt(n);
            dBSubContent = (DBSubContent)list2.get(n2);
            this.mention = dBSubContent.getContent();
        }
        String string6 = UUID.randomUUID().toString();
        this.mention = this.mention + string6.subSequence(0, 8);
        String string7 = this.mention + string2;
        if (string7.length() > 140) {
            int n3 = string7.length() - 140;
            string7 = this.mention.substring(0, this.mention.length() - n3) + string2;
        }
        try {
            weibo.updateStatus(string7);
            MentionMethod.updateMentionSend(string4, Integer.toString(this.mentionid), string5, CNT, string);
            if (SendMentionPanel.checkBox.isSelected()) {
                UIListener.setMentionBoard("\u5f00\u59cb\u65f6\u95f4\uff1a" + SendMentionPanel.begintime + ",\u5df2\u53d1\u9001\u4fe1\u606f\u4e2a\u6570\uff1a" + CNT);
            } else {
                String string8 = new SimpleDateFormat(DATE_TIME_FORMAT).format(new Date());
                UIListener.updateMentionBoard(CNT + " " + string8 + " \u8d26\u6237:" + string + "\u53d1\u8868\u5fae\u535a\u63d0\u5230\u4e86" + string2);
            }
        }
        catch (WeiboException weiboException) {
            MentionMethod.updateMentionSend(string4, Integer.toString(this.mentionid), string5, CNT -= list.size(), string);
            weiboException.printStackTrace();
        }
    }

    private void createIfZero(String string, AccessToken accessToken) {
        if (mentionSate == 0) {
            return;
        }
        try {
            Thread.sleep(SendMentionService.delay());
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Weibo weibo = SendMentionService.getWeibo(true, accessToken);
        List<DBSubContent> list = SubContentMethod.getSubContentList("2", SendMentionPanel.id);
        int n = list.size();
        DBSubContent dBSubContent = null;
        if (n != 0) {
            int n2 = new Random().nextInt(n);
            dBSubContent = list.get(n2);
            this.mention = dBSubContent.getContent();
        }
        String string2 = UUID.randomUUID().toString();
        this.mention = this.mention + string2.subSequence(0, 8);
        String string3 = this.mention;
        if (string3.length() > 140) {
            int n3 = string3.length() - 140;
            string3 = this.mention.substring(0, this.mention.length() - n3);
        }
        try {
            weibo.updateStatus(string3);
            ++CNT;
            if (SendMentionPanel.checkBox.isSelected()) {
                UIListener.setMentionBoard("\u5f00\u59cb\u65f6\u95f4\uff1a" + SendMentionPanel.begintime + ",\u5df2\u53d1\u9001\u4fe1\u606f\u4e2a\u6570\uff1a" + CNT);
            } else {
                String string4 = new SimpleDateFormat(DATE_TIME_FORMAT).format(new Date());
                UIListener.updateMentionBoard(CNT + " " + string4 + " \u8d26\u6237:" + string + "\u53d1\u8868\u4e86\u5fae\u535a");
            }
        }
        catch (WeiboException weiboException) {
            weiboException.printStackTrace();
        }
    }
}

